/*
 * Decompiled with CFR 0.152.
 */
package com.univ.batch.process;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.module.plugin.objetspartages.PluginFicheHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.multisites.InfosFicheComparator;
import com.univ.multisites.InfosFicheReferencee;
import com.univ.multisites.Site;
import com.univ.objetspartages.bean.HistoriqueBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.util.AffichageHistorique;
import com.univ.objetspartages.util.RessourceUtil;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.io.File;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanSite
extends LogReportJob
implements Runnable {
    private static String separateurLangue = ",LANGUE=";
    private static Logger LOGGER = LoggerFactory.getLogger(ScanSite.class);

    @Deprecated
    public String getDirectory(String url) {
        int irepertoire = url.lastIndexOf(47);
        String directory = irepertoire <= 6 ? url : url.substring(0, irepertoire);
        return directory;
    }

    public static void main(String[] args) {
        ScanSite capture = new ScanSite();
        Thread thread = new Thread(capture);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception e) {
            LOGGER.error("Echec thread.join()", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ContextePage ctx;
            ContexteUtil.setContexteSansRequete();
            this.logger.info("***** Suppression des fichiers temporaires *****");
            String tmpDir = WebAppUtil.getWorkDefaultPath();
            File dossierTemporaire = new File(tmpDir);
            this.removeContenuDossier(dossierTemporaire);
            String tmpDirSession = WebAppUtil.getSessionsPath();
            this.removeContenuDossier(new File(tmpDirSession));
            String majReferences = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("static.maj.references"), (String)"0");
            GregorianCalendar dateLimite = new GregorianCalendar();
            dateLimite.add(5, -1);
            this.logger.info("***** Traitement des fiches *****");
            this.logger.info("Purge des fiches obsol\u00e8tes");
            this.logger.info("Synchronisation des m\u00e9tatags");
            this.logger.info("Gestion des alertes");
            try {
                for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
                    String libelleObjet = ReferentielObjets.getLibelleObjet(codeObjet);
                    this.logger.info("***** " + libelleObjet + " *****");
                    ArrayList<Long> arrayMetatag = new ArrayList<Long>();
                    ArrayList<String> arrayRubriquePublication = new ArrayList<String>();
                    ctx = new ContextePage("");
                    try {
                        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
                        if (ficheUniv == null) continue;
                        ficheUniv.setCtx(ctx);
                        ficheUniv.init();
                        int count = ficheUniv.selectCodeLangueEtat("", "", "");
                        if (count > 0) {
                            while (ficheUniv.nextItem()) {
                                arrayMetatag.add(ficheUniv.getIdFiche());
                                if ("0003".equals(ficheUniv.getEtatObjet())) {
                                    arrayRubriquePublication.add(ficheUniv.getCode() + separateurLangue + ficheUniv.getLangue());
                                }
                                if ("0004".equals(ficheUniv.getEtatObjet()) || "0005".equals(ficheUniv.getEtatObjet()) || "0006".equals(ficheUniv.getEtatObjet())) {
                                    String traceSuppression = "";
                                    if (EtatFiche.A_SUPPRIMER.getEtat().equals(ficheUniv.getEtatObjet())) {
                                        traceSuppression = String.format("Suppression de la fiche '%s' de type '%s' et de langue '%s'", ficheUniv.getLibelleAffichable(), libelleObjet, LangueUtil.getDisplayName(ficheUniv.getLangue()));
                                        List<HistoriqueBean> historiqueFiche = AffichageHistorique.getHistorique(ficheUniv);
                                        Collections.sort(historiqueFiche);
                                        try {
                                            HistoriqueBean lastOperation = historiqueFiche.get(historiqueFiche.size() - 1);
                                            if (Metatag.getIntituleAction(Metatag.HISTORIQUE_SUPPRESSION).equals(lastOperation.getAction()) && StringUtils.isNotBlank((CharSequence)lastOperation.getUtilisateur())) {
                                                traceSuppression = traceSuppression + String.format(" par l'utilisateur '%s'", lastOperation.getUtilisateur());
                                            }
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    FicheUnivMgr.supprimerFiche(ficheUniv, true);
                                    if (!StringUtils.isNotBlank((CharSequence)traceSuppression)) continue;
                                    this.logger.info(traceSuppression);
                                    continue;
                                }
                                if (ficheUniv instanceof DiffusionSelective && ((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction().equals("")) {
                                    ((DiffusionSelective)((Object)ficheUniv)).setDiffusionModeRestriction("0");
                                    ficheUniv.update();
                                }
                                FicheUnivMgr.synchroniserMetaTag(ficheUniv, majReferences, true);
                                this.genererAlerte(codeObjet, ficheUniv);
                            }
                        }
                        ContextePage ctxFiche = new ContextePage("");
                        try {
                            this.supprimerMetaTag(ctxFiche, codeObjet, arrayMetatag);
                        }
                        catch (Exception e) {
                            this.logger.error("Exception lors de la suppression des metatgs", (Throwable)e);
                        }
                        finally {
                            ctxFiche.release();
                        }
                        ctxFiche = new ContextePage("");
                        try {
                            this.supprimerRubriquePublication(ctxFiche, codeObjet, arrayRubriquePublication);
                        }
                        catch (Exception e) {
                            this.logger.error("Exception lors de la suppression des rubriques de publication", (Throwable)e);
                        }
                        finally {
                            ctxFiche.release();
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Exception sur le traitement des fiches " + ReferentielObjets.getLibelleObjet(codeObjet), (Throwable)e);
                    }
                    finally {
                        ctx.release();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Ereur dans le traitement de la liste d'objet", (Throwable)e);
            }
            ctx = new ContextePage("");
            try {
                this.logger.info("***** Rubriquage automatique des fiches *****");
                this.rubriquerFiches(ctx);
                this.logger.info("***** Archivage des demandes de mot de passe *****");
                this.archiverDemandesMotPasse();
                this.logger.info("***** Purge des fichiers joints *****");
                this.purgeFichiersgw(ctx);
            }
            catch (Exception e) {
                this.logger.error("Echec maintenance", (Throwable)e);
            }
            finally {
                ctx.release();
            }
        }
        catch (Exception e) {
            this.logger.error("Erreur d'execution du scansite : ", (Throwable)e);
        }
        finally {
            ContexteUtil.releaseContexteUniv();
        }
    }

    public void supprimerMetaTag(OMContext ctx, String codeObjet, ArrayList<Long> listeExistante) throws Exception {
        if (listeExistante.size() > 0) {
            StringBuilder sbListeIdFiches = new StringBuilder("");
            Metatag metatag = new Metatag();
            metatag.init();
            metatag.setCtx(ctx);
            String requete = "WHERE META_CODE_OBJET='" + codeObjet + "'";
            ctx.getDatas().put("optimizedSelect", "1");
            metatag.selectNoCount(requete);
            while (metatag.nextItem()) {
                if (listeExistante.contains(metatag.getMetaIdFiche())) continue;
                sbListeIdFiches.append(",'").append(metatag.getMetaIdFiche()).append("'");
            }
            ctx.getDatas().remove("optimizedSelect");
            if (sbListeIdFiches.length() > 0) {
                sbListeIdFiches.deleteCharAt(0);
                String query = "DELETE FROM METATAG WHERE META_CODE_OBJET='" + codeObjet + "' AND META_ID_FICHE IN (" + sbListeIdFiches.toString() + ")";
                try (PreparedStatement _stmt = ctx.getConnection().prepareStatement(query);){
                    _stmt.executeUpdate();
                }
                catch (SQLException exc) {
                    throw new Exception("ERROR_IN_METHOD supprimerMetatag() " + exc);
                }
            }
        }
    }

    public void supprimerRubriquePublication(OMContext ctx, String codeObjet, ArrayList<String> listeExistante) throws Exception {
        if (listeExistante.size() > 0) {
            StringBuilder sbListeIdFiches = new StringBuilder("");
            Rubriquepublication rubpub = new Rubriquepublication();
            rubpub.init();
            rubpub.setCtx(ctx);
            String requete = "WHERE TYPE_FICHE_ORIG='" + codeObjet + "'";
            ctx.getDatas().put("optimizedSelect", "1");
            rubpub.selectNoCount(requete);
            while (rubpub.nextItem()) {
                String rubpubExistante = rubpub.getCodeFicheOrig() + separateurLangue + rubpub.getLangueFicheOrig();
                if (listeExistante.contains(rubpubExistante)) continue;
                sbListeIdFiches.append(",'").append(rubpubExistante).append("'");
            }
            ctx.getDatas().remove("optimizedSelect");
            if (sbListeIdFiches.length() > 0) {
                sbListeIdFiches.deleteCharAt(0);
                String query = "DELETE FROM RUBRIQUEPUBLICATION WHERE TYPE_FICHE_ORIG='" + codeObjet + "' AND CONCAT(CODE_FICHE_ORIG,'" + separateurLangue + "',LANGUE_FICHE_ORIG) IN (" + sbListeIdFiches.toString() + ")";
                try (PreparedStatement stmt = ctx.getConnection().prepareStatement(query);){
                    stmt.executeUpdate();
                }
                catch (SQLException exc) {
                    throw new Exception("ERROR_IN_METHOD supprimerRubriquePublication() " + exc);
                }
            }
        }
    }

    @Deprecated
    public void archiverDemandesMotPasse(OMContext ctx) throws Exception {
        this.archiverDemandesMotPasse();
    }

    private void archiverDemandesMotPasse() throws Exception {
        GregorianCalendar dateLimite = new GregorianCalendar();
        dateLimite.add(5, -1);
        try (ContexteDao ctx = new ContexteDao();){
            PreparedStatement stmt = ctx.getConnection().prepareStatement("DELETE FROM CHANGEMENTMOTPASSE WHERE DATE_DEMANDE < ?");
            stmt.setDate(1, new Date(dateLimite.getTimeInMillis()));
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException exc) {
            throw new Exception("ERROR_IN_METHOD ArchiverDemandesMotsDePasse " + exc);
        }
    }

    public void purgeFichiersgw(OMContext ctx) {
        try {
            Ressource ressource = new Ressource();
            ressource.setCtx(ctx);
            ressource.init();
            Media media = new Media();
            media.setCtx(ctx);
            media.init();
            int nbFichiersNonAssocies = 0;
            if (ressource.select("WHERE ETAT='0' OR ETAT='2' OR CODE_PARENT=''") > 0) {
                while (ressource.nextItem()) {
                    this.logger.info("Suppression de la ressource d'id " + ressource.getIdRessource() + " ayant pour fichier source " + ressource.getSource());
                    ressource.delete();
                    ++nbFichiersNonAssocies;
                }
            }
            this.logger.info(nbFichiersNonAssocies + " tuple(s) fichiergw supprim\u00e9(s) ");
            this.logger.info("***** Purge des fichiers techniques non r\u00e9f\u00e9renc\u00e9s *****");
            TreeSet<String> tree = new TreeSet<String>();
            if (media.select("") > 0) {
                while (media.nextItem()) {
                    tree.add(media.getUrl());
                    if (media.getUrlVignette().length() <= 0) continue;
                    tree.add(media.getUrlVignette());
                }
            }
            int nbFichiersNonReferences = 0;
            File dir = new File(RessourceUtil.getAbsolutePath());
            nbFichiersNonReferences = this.nettoyerRepertoire(dir, tree);
            this.logger.info((nbFichiersNonReferences += this.nettoyerMediatheque(tree)) + " fichier(s) techniques supprim\u00e9s ");
        }
        catch (Exception e) {
            this.logger.error("Exception pendant la purge des fichiers : methode purgeFichiersgw()", (Throwable)e);
        }
    }

    public int nettoyerRepertoire(File repertoire, Set<String> fichiersReferences) {
        File[] list;
        int nbFichiersNonReferences = 0;
        if (repertoire.isDirectory() && (list = repertoire.listFiles()) != null) {
            for (File fichierASupprimer : list) {
                if (fichierASupprimer.isDirectory()) {
                    nbFichiersNonReferences += this.nettoyerRepertoire(fichierASupprimer, fichiersReferences);
                    continue;
                }
                if (fichiersReferences.contains(fichierASupprimer.getName())) continue;
                if (fichierASupprimer.delete()) {
                    this.logger.info("Suppression fichier " + repertoire.getAbsolutePath() + File.separator + fichierASupprimer.getName());
                } else {
                    this.logger.error("Erreur de suppression du fichier " + repertoire.getAbsolutePath() + File.separator + fichierASupprimer.getName());
                }
                ++nbFichiersNonReferences;
            }
        }
        return nbFichiersNonReferences;
    }

    @Deprecated
    public void genererAlerte(OMContext ctx, String codeObjet, FicheUniv ficheUniv, JSBMailbox mailbox) {
        this.genererAlerte(codeObjet, ficheUniv);
    }

    private void genererAlerte(String codeObjet, FicheUniv ficheUniv) {
        try {
            String mail;
            if (Formateur.estSaisie(ficheUniv.getDateAlerte()) && ficheUniv.getDateAlerte().compareTo(new Date(System.currentTimeMillis())) <= 0 && (mail = Utilisateur.getAdresseMail(ficheUniv.getCodeRedacteur())).length() > 0) {
                String libelle = ReferentielObjets.getLibelleObjet(codeObjet);
                String url_site = URLResolver.getAbsoluteBoUrl("/adminsite/", Site.getSitePrincipal());
                StringBuilder message = new StringBuilder();
                message.append("Fiche concern\u00e9e : fiche ").append(libelle).append(" intitul\u00e9e ").append(ficheUniv.getLibelleAffichable()).append(" (code : ").append(ficheUniv.getCode()).append(").\n\n");
                message.append("Message de l'alerte : \n");
                message.append(ficheUniv.getMessageAlerte()).append("\n\n");
                message.append("Pour ne plus recevoir cette alerte, supprimez ou modifiez la date d'alerte de la fiche \n");
                message.append("dans le module d'administration du site web (").append(url_site).append(")\n\n");
                message.append("Cordialement.");
                JSBMailbox mailbox = new JSBMailbox(false);
                mailbox.sendSystemMsg(mail, "Alerte site web", message.toString());
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception pendant g\u00e9n\u00e9ration alerte objet : %s code : %s langue : %s", codeObjet, ficheUniv.getCode(), ficheUniv.getLangue()), (Throwable)e);
        }
    }

    public void rubriquerFiches(OMContext ctx) {
        Rubrique rubrique = new Rubrique();
        rubrique.init();
        rubrique.setCtx(ctx);
        Rubriquepublication rubPub = new Rubriquepublication();
        rubPub.init();
        rubPub.setCtx(ctx);
        Metatag meta = new Metatag();
        meta.init();
        meta.setCtx(ctx);
        TreeSet<InfosFicheReferencee> listeFichesAIndexer = new TreeSet<InfosFicheReferencee>(new InfosFicheComparator());
        try {
            if (rubrique.select("WHERE REQUETES_RUBRIQUE_PUBLICATION != ''") > 0) {
                while (rubrique.nextItem()) {
                    boolean rubriqueModifiee = false;
                    String messageInvalide = "";
                    Vector<String> vRequete = Chaine.getVecteurAccolades(rubrique.getRequetesRubriquePublication());
                    Iterator<String> it = vRequete.iterator();
                    String codeObjet = "";
                    while (it.hasNext()) {
                        String codeRubrique;
                        String codeStructure;
                        String requete = it.next();
                        this.logger.debug("requete de multi-publication : " + requete);
                        String[] item = requete.split("/", -2);
                        boolean requeteValide = true;
                        boolean rechercheRubriqueRecursive = false;
                        boolean rechercheStructureRecursive = false;
                        if (item[0].length() > 0 && "".equals(codeObjet = ReferentielObjets.getCodeObjet(item[0]))) {
                            messageInvalide = "requete invalide : objet non trouve " + item[0];
                            requeteValide = false;
                        }
                        if ((codeStructure = item[1]).length() > 0) {
                            String[] temp = codeStructure.split(";", -2);
                            if (!Structure.renvoyerItemStructure(codeStructure = temp[0]).getCode().equals(codeStructure)) {
                                messageInvalide = "requete invalide : structure non trouvee " + codeStructure;
                                requeteValide = false;
                            } else if ("1".equals(temp[1])) {
                                rechercheStructureRecursive = true;
                            }
                        }
                        if ((codeRubrique = item[2]).length() > 0) {
                            String[] temp = codeRubrique.split(";", -2);
                            codeRubrique = temp[0];
                            if (!Rubrique.renvoyerItemRubrique(temp[0]).getCode().equals(codeRubrique)) {
                                messageInvalide = "requete invalide : rubrique non trouvee " + codeRubrique;
                                requeteValide = false;
                            } else if ("1".equals(temp[1])) {
                                rechercheRubriqueRecursive = true;
                            }
                        }
                        String langue = "";
                        if (item.length > 4 && LangueUtil.getLocale(langue = item[3]) == null) {
                            messageInvalide = "requete invalide : langue non trouvee " + langue;
                            requeteValide = false;
                        }
                        if (requeteValide) {
                            TreeSet<InfosFicheReferencee> listeFicheAvantSynchro = Rubriquepublication.supprimerRubriquePublicationAutomatique(ctx, rubrique.getCode(), requete, false);
                            this.logger.debug("nb de fiches avant la synchro : " + listeFicheAvantSynchro.size());
                            ClauseWhere whereFiche = new ClauseWhere();
                            if (codeObjet.length() > 0) {
                                whereFiche.setPremiereCondition(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
                            }
                            if (codeStructure.length() > 0) {
                                if (rechercheStructureRecursive) {
                                    ConditionList conditionsStructure = new ConditionList(ConditionHelper.getConditionStructure("META_CODE_RATTACHEMENT", codeStructure));
                                    conditionsStructure.or(ConditionHelper.getConditionStructureMultiple("META_CODE_RATTACHEMENT_AUTRES", codeStructure));
                                    whereFiche.and(conditionsStructure);
                                } else {
                                    ConditionList conditionsStructure = new ConditionList(ConditionHelper.egalVarchar("META_CODE_RATTACHEMENT", codeStructure));
                                    conditionsStructure.or(ConditionHelper.like("META_CODE_RATTACHEMENT_AUTRES", codeStructure, "%[", "]%"));
                                    whereFiche.and(conditionsStructure);
                                }
                            }
                            if (codeRubrique.length() > 0) {
                                if (rechercheRubriqueRecursive) {
                                    whereFiche.and(ConditionHelper.getConditionRubrique("META_CODE_RUBRIQUE", codeRubrique));
                                } else {
                                    whereFiche.and(ConditionHelper.egalVarchar("META_CODE_RUBRIQUE", codeRubrique));
                                }
                            }
                            if (langue.length() > 0) {
                                whereFiche.and(ConditionHelper.egalVarchar("META_LANGUE", langue));
                            }
                            whereFiche.and(ConditionHelper.egalVarchar("META_ETAT_OBJET", EtatFiche.EN_LIGNE.getEtat()));
                            int count = meta.select(whereFiche.formaterSQL());
                            this.logger.debug("nb de fiches correspondant \u00e0 la requ\u00eate :" + count);
                            if (count > 0) {
                                while (meta.nextItem()) {
                                    InfosFicheReferencee infosFiche = new InfosFicheReferencee();
                                    infosFiche.setCode(meta.getMetaCode());
                                    infosFiche.setLangue(meta.getMetaLangue());
                                    infosFiche.setType(meta.getMetaCodeObjet());
                                    infosFiche.setRequete(requete);
                                    if (!listeFicheAvantSynchro.contains(infosFiche)) {
                                        this.logger.debug("ajout \u00e0 indexer de :" + infosFiche.getCode() + " " + infosFiche.getType());
                                        Rubriquepublication rubP = new Rubriquepublication();
                                        rubP.init();
                                        rubP.setCtx(ctx);
                                        rubP.setTypeFicheOrig(infosFiche.getType());
                                        rubP.setCodeFicheOrig(infosFiche.getCode());
                                        rubP.setLangueFicheOrig(infosFiche.getLangue());
                                        rubP.setRubriqueDest(rubrique.getCode());
                                        rubP.setSourceRequete(requete);
                                        rubP.add();
                                        listeFichesAIndexer.add(infosFiche);
                                        continue;
                                    }
                                    listeFicheAvantSynchro.remove(infosFiche);
                                }
                            }
                            if (listeFicheAvantSynchro.size() > 0) {
                                for (InfosFicheReferencee infosFiche : listeFicheAvantSynchro) {
                                    Rubriquepublication.supprimerRubriquePublicationFiche(ctx, infosFiche, true);
                                    this.logger.debug("suite \u00e0 suppression, ajout \u00e0 indexer de :" + infosFiche.getCode() + " " + infosFiche.getType());
                                    listeFichesAIndexer.add(infosFiche);
                                }
                            }
                        } else {
                            listeFichesAIndexer.addAll(Rubriquepublication.supprimerRubriquePublicationAutomatique(ctx, rubrique.getCode(), requete, true));
                            this.logger.warn("Probleme sur une requete automatique definie pour la rubrique " + rubrique.getIntitule() + " : " + messageInvalide + ", la requete est ignoree");
                            rubriqueModifiee = true;
                        }
                        this.logger.debug("nb de fiches \u00e0 indexer : " + listeFichesAIndexer.size());
                    }
                    if (!rubriqueModifiee) continue;
                    rubrique.update();
                }
                this.logger.info("re-indexation des nouvelles fiches rubriqu\u00e9es, nb de fiches \u00e0 r\u00e9-indexer : " + listeFichesAIndexer.size());
                for (InfosFicheReferencee infosFiche : listeFichesAIndexer) {
                    FicheUniv ficheAreindexee = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(infosFiche.getType()));
                    ficheAreindexee.init();
                    ficheAreindexee.setCtx(ctx);
                    if (ficheAreindexee.selectCodeLangueEtat(infosFiche.getCode(), infosFiche.getLangue(), "0003") <= 0) continue;
                    ficheAreindexee.nextItem();
                    ficheAreindexee.setDateProposition(new Date(System.currentTimeMillis()));
                    ficheAreindexee.update();
                    meta = FicheUnivMgr.lireMeta(ficheAreindexee);
                    meta.setMetaDateProposition(ficheAreindexee.getDateProposition());
                    FicheUnivMgr.enregistrerMeta(meta);
                    PluginFicheHelper.synchroniserObjets(ficheAreindexee, meta, null);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception pendant le r\u00e9f\u00e9rencement des fiches : methode rubriquerFiches()", (Throwable)e);
        }
    }

    protected boolean remove(File toRemove) {
        boolean result = true;
        if (toRemove.isDirectory()) {
            String[] list;
            for (String element : list = toRemove.list()) {
                File file = new File(toRemove, element);
                if (file.isDirectory()) {
                    result = this.remove(file);
                    continue;
                }
                if (file.delete()) continue;
                result = false;
            }
        }
        return result;
    }

    @Override
    public void perform() {
        this.run();
    }

    public int nettoyerMediatheque(Set<String> listeNomsFichersAGarder) {
        File dossierMedias = new File(MediathequeHelper.getAbsolutePath());
        if (dossierMedias.exists() && dossierMedias.isDirectory()) {
            File[] listeDossiersTypeMedia = dossierMedias.listFiles();
            int nbFichiersSupprimes = 0;
            for (File enCours : listeDossiersTypeMedia) {
                if (enCours.isDirectory()) {
                    File[] listeMediasTypes;
                    for (File listeMediasType : listeMediasTypes = enCours.listFiles()) {
                        File mediaType = listeMediasType;
                        if (mediaType.isDirectory() || listeNomsFichersAGarder.contains(mediaType.getName())) continue;
                        mediaType.delete();
                        this.logger.info("Suppression fichier " + mediaType.getAbsolutePath());
                        ++nbFichiersSupprimes;
                    }
                    continue;
                }
                if (listeNomsFichersAGarder.contains(enCours.getName())) continue;
                enCours.delete();
                this.logger.info("Suppression fichier " + enCours.getAbsolutePath());
                ++nbFichiersSupprimes;
            }
            return nbFichiersSupprimes;
        }
        return 0;
    }

    private void removeContenuDossier(File dossierTemporaire) {
        if (dossierTemporaire.exists() && dossierTemporaire.isDirectory()) {
            File[] listeFichiersASuppr;
            for (File element : listeFichiersASuppr = dossierTemporaire.listFiles()) {
                File fichierASuppr = element;
                if (fichierASuppr.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)fichierASuppr);
                    }
                    catch (Exception e) {
                        this.logger.error("Erreur lors de la suppression du dossier : " + fichierASuppr.getAbsolutePath(), (Throwable)e);
                    }
                    continue;
                }
                fichierASuppr.delete();
            }
        }
    }
}

