/*
 * Decompiled with CFR 0.152.
 */
package com.univ.batch.process;

import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosRequeteGroupe;
import com.univ.objetspartages.om.RequeteGroupeDynamique;
import com.univ.objetspartages.om.RequeteGroupeDynamiqueSynchronisable;
import com.univ.objetspartages.om.SynchronisationGroupeDynamiqueEtat;
import com.univ.utils.RequeteGroupeUtil;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.slf4j.Logger;

public class SynchroniserGroupesDynamique
extends LogReportJob
implements Runnable {
    public static void main(String[] args) {
        SynchroniserGroupesDynamique synchroniserGroupesDynamique = new SynchroniserGroupesDynamique();
        Thread thread = new Thread(synchroniserGroupesDynamique);
        thread.start();
    }

    @Override
    public void run() {
        Hashtable<String, String> groups = Groupedsi.getListeRequetesGroupesPourAffichage();
        for (String key : groups.keySet()) {
            InfosRequeteGroupe infosRequete = Groupedsi.renvoyerItemRequeteGroupe(key);
            RequeteGroupeDynamique dynGroupe = RequeteGroupeUtil.instancierRequete(infosRequete);
            if (dynGroupe == null || !(dynGroupe instanceof RequeteGroupeDynamiqueSynchronisable) || !((RequeteGroupeDynamiqueSynchronisable)dynGroupe).isAutoSynchronise()) continue;
            this.logger.info("   --- DEBUT de la synchronisation de la requete : " + key);
            SynchronisationGroupeDynamiqueEtat etatSync = ((RequeteGroupeDynamiqueSynchronisable)dynGroupe).synchronize();
            if (etatSync.isValide()) {
                this.displayLogSynchronisation(etatSync, this.logger);
            } else {
                this.logger.info("          Erreur durant la synchronisation ");
            }
            this.logger.info("   --- FIN de la synchronisation de la requete : " + key);
        }
    }

    public void displayLogSynchronisation(SynchronisationGroupeDynamiqueEtat etatSync, Logger logger) {
        Collection<String> tmGroupesAjoutes = etatSync.getLibellesGroupeSynchroAjoutes();
        String groupesAjoutes = "";
        if (!tmGroupesAjoutes.isEmpty()) {
            Iterator<String> itGroupesAjoutes = tmGroupesAjoutes.iterator();
            while (itGroupesAjoutes.hasNext()) {
                if (!groupesAjoutes.equals("")) {
                    groupesAjoutes = groupesAjoutes + ", ";
                }
                groupesAjoutes = groupesAjoutes + itGroupesAjoutes.next();
            }
        }
        Collection<String> tmGroupesSupprimes = etatSync.getLibellesGroupeSynchroSupprimes();
        String groupesSupprimes = "";
        if (!tmGroupesSupprimes.isEmpty()) {
            Iterator<String> itGroupesSupprimes = tmGroupesSupprimes.iterator();
            while (itGroupesSupprimes.hasNext()) {
                if (!groupesSupprimes.equals("")) {
                    groupesSupprimes = groupesSupprimes + ", ";
                }
                groupesSupprimes = groupesSupprimes + itGroupesSupprimes.next();
            }
        }
        Collection<String> tmGroupesModifies = etatSync.getLibellesGroupeSynchroModifies();
        String groupesModifies = "";
        if (!tmGroupesModifies.isEmpty()) {
            Iterator<String> itGroupesModifies = tmGroupesModifies.iterator();
            while (itGroupesModifies.hasNext()) {
                if (!groupesModifies.equals("")) {
                    groupesModifies = groupesModifies + ", ";
                }
                groupesModifies = groupesModifies + itGroupesModifies.next();
            }
        }
        logger.info("          nombre de groupes dynamiques ajout\u00e9s : " + etatSync.getNbGroupesAjoutes());
        if (!groupesAjoutes.equals("")) {
            logger.info("          liste des groupes dynamiques ajout\u00e9s : " + groupesAjoutes);
        }
        logger.info("          nombre de groupes dynamiques modifi\u00e9s : " + etatSync.getNbGroupesModifies());
        if (!groupesModifies.equals("")) {
            logger.info("          liste des groupes dynamiques modifi\u00e9s : " + groupesModifies);
        }
        logger.info("          nombre de groupes dynamiques supprim\u00e9s : " + etatSync.getNbGroupesSupprimes());
        if (!groupesSupprimes.equals("")) {
            logger.info("          liste des groupes dynamiques supprim\u00e9s : " + groupesSupprimes);
        }
    }

    @Override
    public void perform() {
        this.run();
    }
}

