/*
 * Decompiled with CFR 0.152.
 */
package com.univ.collaboratif.dao.impl;

import com.jsbsoft.jtf.datasource.dao.impl.mysql.AbstractCommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.univ.collaboratif.bean.UserRolesCollaboratifBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserRolesCollaboratifDao
extends AbstractCommonDAO<UserRolesCollaboratifBean> {
    public UserRolesCollaboratifDao() {
        this.tableName = "USER_ROLES_COLLABORATIF";
    }

    @Override
    protected UserRolesCollaboratifBean fill(ResultSet rs) throws DataSourceException {
        try {
            UserRolesCollaboratifBean userRolesCollaboratifBean = new UserRolesCollaboratifBean();
            userRolesCollaboratifBean.setId(rs.getLong("ID_USER_ROLES_COLLABORATIF"));
            userRolesCollaboratifBean.setIdCollaboratif(rs.getLong("ID_COLLABORATIF"));
            userRolesCollaboratifBean.setCodeUser(rs.getString("CODE_USER"));
            userRolesCollaboratifBean.setCodeRole(rs.getString("CODE_ROLE"));
            return userRolesCollaboratifBean;
        }
        catch (SQLException e) {
            throw new DataSourceException("Une erreur est survenue lors de la r\u00e9cup\u00e9ration du bean UserRolesCollaboratifBean", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserRolesCollaboratifBean add(UserRolesCollaboratifBean userRolesCollaboratifBean) throws AddToDataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement("INSERT INTO `USER_ROLES_COLLABORATIF` (`CODE_USER`, `CODE_ROLE`, `ID_COLLABORATIF`) VALUES (?, ?, ?)", 1);){
                stmt.setString(1, userRolesCollaboratifBean.getCodeUser());
                stmt.setString(2, userRolesCollaboratifBean.getCodeRole());
                stmt.setLong(3, userRolesCollaboratifBean.getIdCollaboratif());
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"USER_ROLES_COLLABORATIF\" : %d row(s) affected", userRolesCollaboratifBean.toString(), rowsAffected));
                }
                rs = stmt.getGeneratedKeys();
                rs.next();
                userRolesCollaboratifBean.setId(rs.getLong(1));
            }
            if (rs == null) return userRolesCollaboratifBean;
        }
        catch (Exception e) {
            try {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"USER_ROLES_COLLABORATIF\"", userRolesCollaboratifBean.toString()), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occurred closing Resultset during add() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return userRolesCollaboratifBean;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occurred closing Resultset during add() on table %s", this.tableName), (Throwable)e);
            return userRolesCollaboratifBean;
        }
    }

    @Override
    public UserRolesCollaboratifBean update(UserRolesCollaboratifBean userRolesCollaboratifBean) throws UpdateToDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("UPDATE `USER_ROLES_COLLABORATIF` SET `CODE_USER` = ?, `CODE_ROLE` = ?, `ID_COLLABORATIF` = ? WHERE ID_USER_ROLES_COLLABORATIF = ?");){
            stmt.setString(1, userRolesCollaboratifBean.getCodeUser());
            stmt.setString(2, userRolesCollaboratifBean.getCodeRole());
            stmt.setLong(3, userRolesCollaboratifBean.getIdCollaboratif());
            stmt.setLong(4, userRolesCollaboratifBean.getId());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"USER_ROLES_COLLABORATIF\"", userRolesCollaboratifBean.toString()), e);
        }
        return userRolesCollaboratifBean;
    }

    public List<UserRolesCollaboratifBean> getByIdCollaboratif(Long id) {
        ArrayList<UserRolesCollaboratifBean> results = new ArrayList<UserRolesCollaboratifBean>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE ID_COLLABORATIF = ?", this.tableName));){
            stmt.setLong(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(this.fill(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
        return results;
    }

    public List<UserRolesCollaboratifBean> getByCodeUser(String code) {
        ArrayList<UserRolesCollaboratifBean> results = new ArrayList<UserRolesCollaboratifBean>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE CODE_USER = ?", this.tableName));){
            stmt.setString(1, code);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(this.fill(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
        return results;
    }

    public List<UserRolesCollaboratifBean> getByCodeRoleAndIdCollab(String codeRole, long idEspacecollaboratif) {
        ArrayList<UserRolesCollaboratifBean> results = new ArrayList<UserRolesCollaboratifBean>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE CODE_ROLE = ? AND ID_COLLABORATIF = ?", this.tableName));){
            stmt.setString(1, codeRole);
            stmt.setLong(2, idEspacecollaboratif);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(this.fill(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
        return results;
    }

    public void deleteByIdCollaboratif(Long idEspacecollaboratif) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("DELETE FROM `%s` WHERE ID_COLLABORATIF = ?", this.tableName));){
            stmt.setLong(1, idEspacecollaboratif);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
    }

    public UserRolesCollaboratifBean getByCodeUserAndIdCollab(String codeUser, Long idEspacecollaboratif) {
        UserRolesCollaboratifBean bean = null;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE CODE_USER = ? AND ID_COLLABORATIF = ?", this.tableName));){
            stmt.setString(1, codeUser);
            stmt.setLong(2, idEspacecollaboratif);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    bean = this.fill(rs);
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
        return bean;
    }

    public void deleteByCodeUserAndIdCollab(String codeMembre, Long idEspacecollaboratif) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("DELETE FROM `%s` WHERE CODE_USER = ? AND ID_COLLABORATIF = ?", this.tableName));){
            stmt.setString(1, codeMembre);
            stmt.setLong(2, idEspacecollaboratif);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
    }

    public void deleteByCodeUser(String codeMembre) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("DELETE FROM `%s` WHERE CODE_USER = ?", this.tableName));){
            stmt.setString(1, codeMembre);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
        }
    }
}

