/*
 * Decompiled with CFR 0.152.
 */
package com.univ.collaboratif.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.datasource.manager.impl.BasicDataSourceDAOManager;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.univ.collaboratif.bean.UserRolesCollaboratifBean;
import com.univ.collaboratif.dao.impl.UserRolesCollaboratifDao;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.collaboratif.service.CacheEspaceManager;
import com.univ.collaboratif.sgbd.EspacecollaboratifDB;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.EscapeString;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Espacecollaboratif
extends EspacecollaboratifDB
implements Cloneable {
    public static final String ID_EXTENSION = "collaboratif";
    public static final PermissionBean PERMISSION_GESTIONNAIRE = new PermissionBean("TECH", "ges", "");
    public static final String ERREUR_ESPACE_INEXISTANT = "ST_COLLABORATIF_ERREUR_ESPACE_INEXISTANT";
    public static final String ERREUR_AJOUT_MEMBRE = "ST_COLLABORATIF_ERREUR_AJOUT_MEMBRE";
    public static final String ERREUR_AJOUT_RESPONSABLE = "ST_COLLABORATIF_ERREUR_AJOUT_RESPONSABLE";
    public static final String ERREUR_AUCUN_ROLE_RESPONSABLE = "ST_COLLABORATIF_ERREUR_AUCUN_ROLE_RESPONSABLE";
    public static final String ERREUR_SUPPRESSION_RESPONSABLE = "ST_COLLABORATIF_ERREUR_SUPPRESSION_RESPONSABLE";
    public static final String ERREUR_SUPPRESSION_MEMBRE_NON_INSCRIT = "ST_COLLABORATIF_ERREUR_SUPPRESSION_MEMBRE_NON_INSCRIT";
    public static final String ERREUR_INSCRIPTION_EN_COURS = "ST_COLLABORATIF_ERREUR_INSCRIPTION_EN_COURS";
    public static final String ERREUR_INSCRIPTION_DEJA_INSCRIT = "ST_COLLABORATIF_ERREUR_INSCRIPTION_DEJA_INSCRIT";
    public static final String ERREUR_MAIL_SELECTION_UTILISATEUR = "ST_COLLABORATIF_ERREUR_MAIL_SELECTION_UTILISATEUR";
    public static final String CONFIRMATION_MAIL_ENVOI = "ST_COLLABORATIF_CONFIRMATION_MAIL_ENVOI";
    public static final String ERREUR_MAIL_FICHIER = "ST_COLLABORATIF_ERREUR_MAIL_FICHIER";
    public static final String CONFIRMATION_DOCUMENTGW_VERROU_ON = "ST_COLLABORATIF_CONFIRMATION_DOCUMENTGW_VERROU_ON";
    public static final String CONFIRMATION_DOCUMENTGW_VERROU_OFF = "ST_COLLABORATIF_CONFIRMATION_DOCUMENTGW_VERROU_OFF";
    public static final String ERREUR_MEMBRE_CRITERE = "ST_COLLABORATIF_ERREUR_MEMBRE_CRITERE";
    public static final String ERREUR_MEMBRE_AFFINER_CRITERE = "ST_COLLABORATIF_ERREUR_MEMBRE_AFFINER_CRITERE";
    public static final String CONFIRMATION_MEMBRE_AJOUT = "ST_COLLABORATIF_CONFIRMATION_MEMBRE_AJOUT";
    public static final String CONFIRMATION_MEMBRE_SUPPRESSION = "ST_COLLABORATIF_CONFIRMATION_MEMBRE_SUPPRESSION";
    public static final String CONFIRMATION_DEMANDE_MEMBRE_SUPPRESSION = "ST_COLLABORATIF_CONFIRMATION_DEMANDE_MEMBRE_SUPPRESSION";
    public static final String CONFIRMATION_MEMBRE_MODIFICATION = "ST_COLLABORATIF_CONFIRMATION_MEMBRE_MODIFICATION";
    public static final String ERREUR_MEMBRE_DROITS = "ST_COLLABORATIF_ERREUR_MEMBRE_DROITS";
    public static final String CONFIRMATION_NEWSLETTER_MODIFICATION = "ST_COLLABORATIF_CONFIRMATION_NEWSLETTER_MODIFICATION";
    public static final String CONFIRMATION_NEWSLETTER_DESACTIVEE = "ST_COLLABORATIF_CONFIRMATION_NEWSLETTER_DESACTIVEE";
    public static final String CONFIRMATION_NEWSLETTER_ENVOI = "ST_COLLABORATIF_CONFIRMATION_NEWSLETTER_ENVOI";
    public static final String ALERTE_DESINSCRIPTION = "ST_COLLABORATIF_ALERTE_DESINSCRIPTION";
    public static final String RETOUR_INSCRIPTION = "ST_COLLABORATIF_RETOUR_INSCRIPTION";
    public static final String CONFIRMATION_DEMANDE_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_DEMANDE_INSCRIPTION";
    public static final String CONFIRMATION_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_INSCRIPTION";
    public static final String ERREUR_INSCRIPTION_DROITS = "ST_COLLABORATIF_ERREUR_INSCRIPTION_DROITS";
    public static final String CONFIRMATION_VALIDATION_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_VALIDATION_INSCRIPTION";
    public static final String CONFIRMATION_REFUS_INSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_REFUS_INSCRIPTION";
    public static final String CONFIRMATION_DESINSCRIPTION = "ST_COLLABORATIF_CONFIRMATION_DESINSCRIPTION";
    public static final String ERREUR_INSCRIPTION_TRAITEE = "ST_COLLABORATIF_ERREUR_INSCRIPTION_TRAITEE";
    public static final String MAIL_OBJET_DEMANDE_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_DEMANDE_INSCRIPTION";
    public static final String MAIL_MESSAGE_DEMANDE_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_DEMANDE_INSCRIPTION";
    public static final String MAIL_OBJET_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_INSCRIPTION";
    public static final String MAIL_MESSAGE_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_INSCRIPTION";
    public static final String MAIL_OBJET_DESINSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_DESINSCRIPTION";
    public static final String MAIL_MESSAGE_DESINSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_DESINSCRIPTION";
    public static final String MAIL_OBJET_VALIDATION_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_VALIDATION_INSCRIPTION";
    public static final String MAIL_MESSAGE_VALIDATION_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_VALIDATION_INSCRIPTION";
    public static final String MAIL_OBJET_REFUS_INSCRIPTION = "ST_COLLABORATIF_MAIL_OBJET_REFUS_INSCRIPTION";
    public static final String MAIL_MESSAGE_REFUS_INSCRIPTION = "ST_COLLABORATIF_MAIL_MESSAGE_REFUS_INSCRIPTION";
    public static final String MAIL_OBJET_NOTIFICATION = "ST_COLLABORATIF_MAIL_OBJET_NOTIFICATION";
    public static final String MAIL_MESSAGE_NOTIFICATION = "ST_COLLABORATIF_MAIL_MESSAGE_NOTIFICATION";
    public static final String ERREUR_ACCES_MESSAGE = "ST_COLLABORATIF_ERREUR_ACCES_MESSAGE";
    public static final String ERREUR_ACCES_INSCRIPTION = "ST_COLLABORATIF_ACCES_INSCRIPTION";
    private static final Logger LOG = LoggerFactory.getLogger(Espacecollaboratif.class);
    private final UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao)ApplicationContextManager.getCoreContextBean("daoManager", BasicDataSourceDAOManager.class).getDao(UserRolesCollaboratifBean.class);

    public static boolean isExtensionActivated() {
        IExtension extension = ExtensionHelper.getExtension(ID_EXTENSION);
        if (extension != null) {
            return extension.getEtat() == 1;
        }
        return false;
    }

    public static Vector<String> renvoyerRolesTousLesMembres(String codeEspace) {
        Vector<String> res = new Vector<String>();
        InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(codeEspace);
        Vector<String> listeRolesMembres = Chaine.getVecteurAccolades(infosEspace.getRolesMembre());
        for (String codeRole : listeRolesMembres) {
            res.add(codeRole);
        }
        return res;
    }

    @Deprecated
    public static Espacecollaboratif getEspace(OMContext ctx, String code) throws Exception {
        return Espacecollaboratif.getEspace(code);
    }

    public static Espacecollaboratif getEspace(String code) throws Exception {
        Espacecollaboratif res = null;
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            Espacecollaboratif espace = new Espacecollaboratif();
            try (ContexteDao ctx = new ContexteDao();){
                espace.setCtx(ctx);
                espace.init();
                ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("CODE", code));
                int count = espace.select(whereCode.formaterSQL());
                if (count == 1 && espace.nextItem()) {
                    res = espace;
                }
            }
        }
        return res;
    }

    @Deprecated
    public static Hashtable<String, String> getListeEspacesCollaboratifs(OMContext ctx) throws Exception {
        return Espacecollaboratif.getListeEspacesCollaboratifs(ctx, false);
    }

    @Deprecated
    public static Hashtable<String, String> getListeEspacesCollaboratifs(OMContext ctx, boolean avecTheme) throws Exception {
        Hashtable<String, String> res = new Hashtable<String, String>();
        for (InfosEspaceCollaboratif espace : Espacecollaboratif.getListeEspaces()) {
            if (avecTheme) {
                String libelleTheme = Espacecollaboratif.getTheme(ctx, espace.getCodeTheme());
                res.put(espace.getCode(), libelleTheme + " - " + espace.getIntitule());
                if (res.containsValue("T#" + espace.getCodeTheme())) continue;
                res.put("T#" + espace.getCodeTheme(), libelleTheme + " - *");
                continue;
            }
            res.put(espace.getCode(), espace.getIntitule());
        }
        return res;
    }

    public static InfosEspaceCollaboratif renvoyerItemEspace(String code) {
        InfosEspaceCollaboratif res = CacheEspaceManager.getInstance().getItem(code);
        if (res == null) {
            res = new InfosEspaceCollaboratif();
        }
        return res;
    }

    @Deprecated
    public static String getIntitule(OMContext ctx, String code) throws Exception {
        return Espacecollaboratif.getIntitule(code);
    }

    public static String getIntitule(String code) throws Exception {
        String res = MessageHelper.getCoreMessage("BO_ESPACE_COLLAB_INEXISTANT");
        if (StringUtils.isEmpty((CharSequence)code)) {
            return res;
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)Espacecollaboratif.renvoyerItemEspace(code).getIntitule(), (CharSequence)MessageHelper.getCoreMessage("BO_ESPACE_COLLAB_INEXISTANT"));
    }

    @Deprecated
    public static String getChaineResponsable(OMContext ctx, String code) throws Exception {
        return Espacecollaboratif.getChaineResponsable(code);
    }

    public static String getChaineResponsable(String code) throws Exception {
        String res = "";
        Collection<String> gestionnaires = Espacecollaboratif.renvoyerUtilisateursGestionnaire(code);
        for (String codeGestionnaire : gestionnaires) {
            Utilisateur user = Utilisateur.getUtilisateur(codeGestionnaire);
            if (user == null) continue;
            if (res.length() > 0) {
                res = res + " / ";
            }
            res = res + user.getLibelle();
        }
        return res;
    }

    public static String getTheme(OMContext ctx, String codeTheme) throws Exception {
        return Libelle.getLibelle("0110", codeTheme, ctx.getLocale());
    }

    public static Collection<InfosEspaceCollaboratif> getListeEspaces() {
        ArrayList<InfosEspaceCollaboratif> listeEspaces = new ArrayList<InfosEspaceCollaboratif>();
        Espacecollaboratif espace = new Espacecollaboratif();
        try (ContexteDao ctx = new ContexteDao();){
            espace.setCtx(ctx);
            espace.init();
            espace.select("");
            while (espace.nextItem()) {
                if (!espace.getActif().equals("1")) continue;
                InfosEspaceCollaboratif infosEspace = new InfosEspaceCollaboratif(espace.getIdEspacecollaboratif(), espace.getCode(), espace.getIntitule(), espace.getGroupesMembres(), espace.getGroupesConsultation(), espace.getGroupesInscription(), espace.getInscriptionFront(), espace.getRolesMembre(), espace.getTheme(), espace.getDescription(), espace.getCodeRubrique(), espace.getLangue(), "1".equals(espace.getActif()), new ArrayList<String>(Chaine.getVecteurPointsVirgules(espace.getServices())));
                listeEspaces.add(infosEspace);
            }
        }
        catch (Exception e) {
            LOG.error("Probl\u00e8me d'initialisation du cache des espaces", (Throwable)e);
        }
        return listeEspaces;
    }

    @Deprecated
    public static Hashtable<String, InfosEspaceCollaboratif> getListeEspacesCollaboratifs() {
        Hashtable<String, InfosEspaceCollaboratif> hListe = new Hashtable<String, InfosEspaceCollaboratif>();
        for (InfosEspaceCollaboratif infosEspace : Espacecollaboratif.getListeEspaces()) {
            hListe.put(infosEspace.getCode(), infosEspace);
        }
        return hListe;
    }

    @Deprecated
    public static void controlerRestriction(ContexteUniv ctx, HttpServletResponse response) throws Exception {
        if (ctx.getAutorisation() == null) {
            UnivWebFmt.redirigerVersLogin(ctx, response, "");
        } else {
            InfosEspaceCollaboratif espaceCourant = ctx.getInfosEspace();
            if (!Espacecollaboratif.estMembreEspace(ctx, espaceCourant) && !Espacecollaboratif.estVisiteurEspace(ctx, espaceCourant)) {
                ctx.getRequeteHTTP().setAttribute("EXCLUSION_ESPACE", (Object)"true");
                String message = MessageHelper.getCoreMessage("ST_PAS_DROITS_ACCES");
                Espacecollaboratif espace = Espacecollaboratif.getEspace(espaceCourant.getCode());
                if (espace != null) {
                    message = MessageHelper.getCoreMessage(ERREUR_ACCES_MESSAGE);
                    if ((message = StringUtils.replace((String)message, (String)"[espace]", (String)espaceCourant.getIntitule())).length() == 0) {
                        message = "Vous ne disposez pas des droits d'acc\u00e8s \u00e0 l'espace collaboratif : " + espaceCourant.getIntitule();
                    }
                    Vector<String> vGroupesInscription = Chaine.getVecteurPointsVirgules(espace.getGroupesInscription());
                    boolean inscription = false;
                    if (vGroupesInscription.size() > 0) {
                        for (String groupeDsi : ctx.getGroupesDsi()) {
                            if (!vGroupesInscription.contains(groupeDsi)) continue;
                            inscription = true;
                            break;
                        }
                    } else {
                        inscription = true;
                    }
                    if (inscription && espace.getActif().equals("1") && (espace.getInscriptionFront().equals("1") || espace.getInscriptionFront().equals("2"))) {
                        String lien = MessageHelper.getCoreMessage(ERREUR_ACCES_INSCRIPTION);
                        if (lien.length() == 0) {
                            lien = "Cliquez ici pour vous inscrire";
                        }
                        message = message + "<br />";
                        message = message + "<a href=\"" + URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlRelative(ctx, "/servlet/com.jsbsoft.jtf.core.SG?ACTION=INSCRIPTION&amp;PROC=INSCRIPTION_ESPACE&amp;CODE_ESPACE=" + espace.getCode() + "&amp;INSCRIPTION_DIRECT=true"), ctx) + "&amp;RH=" + EscapeString.escapeURL(ctx.getCodeRubriquePageCourante()) + "\">" + lien + "</a>";
                    }
                }
                throw new ErreurApplicative(message);
            }
        }
    }

    @Deprecated
    public static Collection<String> renvoyerCodesUtilisateursParEspaceParGroupe(String codeEspace) throws Exception {
        TreeSet<String> membres = new TreeSet<String>();
        InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(codeEspace);
        Vector<String> membresGroupes = Chaine.getVecteurAccolades(infosEspace.getGroupesMembres());
        for (String codeGroupe : membresGroupes) {
            membres.addAll(Groupeutilisateur.getVecteurUtilisateurs(codeGroupe));
        }
        return membres;
    }

    public static Collection<String> renvoyerUtilisateursGestionnaire(String codeEspace) throws Exception {
        return Espacecollaboratif.getListeUtilisateursPossedantPermissionPourUnEspace(PERMISSION_GESTIONNAIRE, codeEspace, false);
    }

    public static TreeSet<String> getListeUtilisateursPossedantPermissionPourUnEspace(PermissionBean permission, String codeEspaceCollaboratif, boolean renvoyerMails) throws Exception {
        TreeSet<String> listeUtilisateurs = new TreeSet<String>();
        InfosEspaceCollaboratif infosEspace = Espacecollaboratif.renvoyerItemEspace(codeEspaceCollaboratif);
        String roleEspaceParDefaut = infosEspace.getRolesMembre();
        Hashtable<String, String> rolesCollab = Role.getListeRolesEspaceCollaboratif();
        for (String codeRole : rolesCollab.keySet()) {
            boolean roleOk = false;
            InfosRole infosRole = Role.renvoyerItemRole(codeRole);
            Vector<PermissionBean> permissions = infosRole.getVecteurPermissions();
            for (PermissionBean permissionRole : permissions) {
                if (!permissionRole.getChaineSerialisee().equals(permission.getChaineSerialisee())) continue;
                roleOk = true;
                break;
            }
            if (!roleOk) continue;
            UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao)ApplicationContextManager.getCoreContextBean("daoManager", BasicDataSourceDAOManager.class).getDao(UserRolesCollaboratifBean.class);
            List<UserRolesCollaboratifBean> userRoles = userRolesCollaboratifDao.getByCodeRoleAndIdCollab(codeRole, infosEspace.getId());
            for (UserRolesCollaboratifBean currentUserRoles : userRoles) {
                listeUtilisateurs.add(currentUserRoles.getCodeUser());
            }
            if (!codeRole.equals(roleEspaceParDefaut)) continue;
            Vector<String> groupesMembres = Chaine.getVecteurAccolades(infosEspace.getGroupesMembres());
            for (String codeGroupe : groupesMembres) {
                listeUtilisateurs.addAll(Groupeutilisateur.getVecteurUtilisateurs(codeGroupe));
            }
        }
        TreeSet<String> res = new TreeSet<String>();
        if (renvoyerMails) {
            for (String codeUtilisateur : listeUtilisateurs) {
                Utilisateur utilisateur = Utilisateur.getUtilisateur(codeUtilisateur);
                res.add(utilisateur.getAdresseMail() + ";" + utilisateur.getLibelle() + ";" + codeUtilisateur);
            }
        }
        return renvoyerMails ? res : listeUtilisateurs;
    }

    public static Collection<String> renvoyerCodesUtilisateursParEspace(String codeEspace) throws Exception {
        TreeSet<String> listeMembres = new TreeSet<String>();
        UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao)ApplicationContextManager.getCoreContextBean("daoManager", BasicDataSourceDAOManager.class).getDao(UserRolesCollaboratifBean.class);
        Espacecollaboratif espace = Espacecollaboratif.getEspace(codeEspace);
        for (UserRolesCollaboratifBean currentUser : userRolesCollaboratifDao.getByIdCollaboratif(espace.getIdEspacecollaboratif())) {
            listeMembres.add(currentUser.getCodeUser());
        }
        Vector<String> groupesMembres = Chaine.getVecteurAccolades(espace.getGroupesMembres());
        for (String codeGroupe : groupesMembres) {
            listeMembres.addAll(Groupeutilisateur.getVecteurUtilisateurs(codeGroupe));
        }
        return listeMembres;
    }

    @Deprecated
    public static void supprimerUtilisateur(OMContext _ctx, String _codeMembre) throws Exception {
        Espacecollaboratif.supprimerUtilisateur(_codeMembre);
    }

    public static void supprimerUtilisateur(String codeMembre) throws Exception {
        UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao)ApplicationContextManager.getCoreContextBean("daoManager", BasicDataSourceDAOManager.class).getDao(UserRolesCollaboratifBean.class);
        userRolesCollaboratifDao.deleteByCodeUser(codeMembre);
    }

    public static Map<String, UserRolesCollaboratifBean> getRolesEspacesForUserAndGroup(String userCode, Vector<String> groupCodes) throws Exception {
        HashMap<String, UserRolesCollaboratifBean> results = new HashMap<String, UserRolesCollaboratifBean>();
        UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao)ApplicationContextManager.getCoreContextBean("daoManager", BasicDataSourceDAOManager.class).getDao(UserRolesCollaboratifBean.class);
        List<UserRolesCollaboratifBean> userRoles = userRolesCollaboratifDao.getByCodeUser(userCode);
        for (UserRolesCollaboratifBean currentUserRoles : userRoles) {
            ContexteDao ctx = new ContexteDao();
            Throwable throwable = null;
            try {
                Espacecollaboratif espace = new Espacecollaboratif();
                espace.setCtx(ctx);
                espace.setIdEspacecollaboratif(currentUserRoles.getIdCollaboratif());
                espace.retrieve();
                results.put(espace.getCode(), currentUserRoles);
            }
            catch (Throwable espace) {
                throwable = espace;
                throw espace;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable espace) {
                        throwable.addSuppressed(espace);
                    }
                    continue;
                }
                ctx.close();
            }
        }
        for (InfosEspaceCollaboratif espace : Espacecollaboratif.getListeEspaces()) {
            for (String codeGroupe : groupCodes) {
                Vector<String> groupesMembres = Chaine.getVecteurAccolades(espace.getGroupesMembres());
                if (!groupesMembres.contains(codeGroupe)) continue;
                UserRolesCollaboratifBean currentRoleEspace = new UserRolesCollaboratifBean();
                currentRoleEspace.setCodeUser(userCode);
                currentRoleEspace.setIdCollaboratif(espace.getId());
                currentRoleEspace.setCodeRole(espace.getRolesMembre());
                if (results.get(espace.getCode()) != null) continue;
                results.put(espace.getCode(), currentRoleEspace);
            }
        }
        return results;
    }

    public static boolean estVisiteurEspace(ContexteUniv ctx, InfosEspaceCollaboratif infosEspace) {
        boolean isVisitor = false;
        TreeSet<String> groupesUtilisateur = ctx.getGroupesDsiAvecAscendants();
        Vector<String> groupesConsultationEspace = Chaine.getVecteurAccolades(infosEspace.getGroupesConsultation());
        for (String groupeUtilisateur : groupesUtilisateur) {
            if (!groupesConsultationEspace.contains(groupeUtilisateur)) continue;
            isVisitor = true;
            break;
        }
        return isVisitor;
    }

    public static boolean estMembreEspace(ContexteUniv ctx, InfosEspaceCollaboratif infosEspace) {
        boolean isMembre = false;
        UserRolesCollaboratifDao userRolesCollaboratifDao = (UserRolesCollaboratifDao)ApplicationContextManager.getCoreContextBean("daoManager", BasicDataSourceDAOManager.class).getDao(UserRolesCollaboratifBean.class);
        try {
            Espacecollaboratif espace = Espacecollaboratif.getEspace(infosEspace.getCode());
            UserRolesCollaboratifBean membre = userRolesCollaboratifDao.getByCodeUserAndIdCollab(ctx.getCode(), espace.getIdEspacecollaboratif());
            if (membre != null) {
                isMembre = true;
            }
        }
        catch (Exception espace) {
            // empty catch block
        }
        if (!isMembre) {
            TreeSet<String> groupesUtilisateur = ctx.getGroupesDsiAvecAscendants();
            for (String groupeUtilisateur : groupesUtilisateur) {
                if (!infosEspace.getGroupesMembres().contains(groupeUtilisateur)) continue;
                isMembre = true;
                break;
            }
        }
        return isMembre;
    }

    public void init() {
        this.setIdEspacecollaboratif(0L);
        this.setCode("");
        this.setActif("1");
        this.setInscriptionFront("1");
        this.setTheme("");
        this.setIntitule("");
        this.setCodeRubrique("");
        this.setCodeStructure("");
        this.setGroupesMembres("");
        this.setRolesMembre("");
        this.setDescription("");
        this.setInscriptionsEnCours("");
        this.setServices("");
        this.setDateCreation(new Date(System.currentTimeMillis()));
        this.setPeriodiciteNewsletter("0");
        this.setContenuNewsletter("");
        this.setDateDernierEnvoiNewsletter(new Date(0L));
        this.setDateEnvoiNewsletter(new Date(0L));
        this.setGroupesInscription("");
        this.setGroupesConsultation("");
        this.setLangue("0");
        this.setEnteteEspace("");
        this.setPiedEspace("");
    }

    public int selectByCode(String codeEspace) throws Exception {
        ClauseWhere wherePourInscription = new ClauseWhere();
        if (StringUtils.isNotEmpty((CharSequence)codeEspace)) {
            wherePourInscription.and(ConditionHelper.egalVarchar("CODE", codeEspace));
        }
        return this.select(wherePourInscription.formaterSQL());
    }

    public String getLibelleTheme(Locale locale) throws Exception {
        return Libelle.getLibelle("0110", this.getTheme(), locale);
    }

    public boolean isActif() {
        return "1".equals(this.getActif());
    }

    public Espacecollaboratif clone() throws CloneNotSupportedException {
        return (Espacecollaboratif)super.clone();
    }
}

