/*
 * Decompiled with CFR 0.152.
 */
package com.univ.collaboratif.service;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.CacheUtil;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.InfosEspaceCollaboratif;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEspaceManager {
    public static final String ID_BEAN = "cacheEspaceManager";
    public static final String CACHE_NAME = "CacheEspaceManager.cacheEspaces";
    private static final Logger LOG = LoggerFactory.getLogger(CacheEspaceManager.class);

    public static CacheEspaceManager getInstance() {
        return (CacheEspaceManager)ApplicationContextManager.getBean("collaboratif", ID_BEAN);
    }

    public InfosEspaceCollaboratif getItem(String code) {
        InfosEspaceCollaboratif infosEspace = (InfosEspaceCollaboratif)CacheUtil.getObjectValue(CACHE_NAME, code);
        if (infosEspace == null) {
            Espacecollaboratif espacecollaboratif = new Espacecollaboratif();
            try (ContexteDao ctx = new ContexteDao();){
                espacecollaboratif.setCtx(ctx);
                espacecollaboratif.init();
                espacecollaboratif.selectByCode(code);
                if (espacecollaboratif.nextItem()) {
                    infosEspace = new InfosEspaceCollaboratif(espacecollaboratif.getIdEspacecollaboratif(), espacecollaboratif.getCode(), espacecollaboratif.getIntitule(), espacecollaboratif.getGroupesMembres(), espacecollaboratif.getGroupesConsultation(), espacecollaboratif.getGroupesInscription(), espacecollaboratif.getInscriptionFront(), espacecollaboratif.getRolesMembre(), espacecollaboratif.getTheme(), espacecollaboratif.getDescription(), espacecollaboratif.getCodeRubrique(), espacecollaboratif.getLangue(), "1".equals(espacecollaboratif.getActif()), new ArrayList<String>(Chaine.getVecteurPointsVirgules(espacecollaboratif.getServices())));
                    CacheUtil.updateObjectValue(CACHE_NAME, code, infosEspace);
                }
            }
            catch (Exception e) {
                LOG.error("Probl\u00e8me de r\u00e9cup\u00e9ration de l'espace " + code, (Throwable)e);
            }
        }
        return infosEspace;
    }

    public void flushItem(String code) {
        CacheUtil.flush(CACHE_NAME, code);
    }
}

