/*
 * Decompiled with CFR 0.152.
 */
package com.univ.collaboratif.utils;

import com.jsbsoft.jtf.database.RequeteMgr;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kportal.core.config.MessageHelper;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LectureFichiergw
extends HttpServlet {
    private static final long serialVersionUID = 8923414367463884140L;
    private static final long DEFAULT_EXPIRE_TIME = 604800000L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final String CHARSET = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(LectureFichiergw.class);
    public static final String[] extraType = new String[]{"LOGO_ESPACE", "NEWSLETTER"};
    boolean isApercu = Boolean.FALSE;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setApercu(request);
        String uri = request.getRequestURI();
        Pattern compile = Pattern.compile(StringUtils.replace((String)System.getProperty("media.url-pattern"), (String)"/*", (String)"(/.*)"));
        Matcher matcher = compile.matcher(uri);
        Media media = null;
        if (StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)MediathequeHelper.getUrlTempPath())) {
            this.traiterFluxFileTmp(request, response);
        } else {
            media = matcher.find() ? this.getMediaByUrl(request) : this.getMediaByParameter(request);
        }
        this.performFichiergw(request, response, media);
    }

    private Media getMediaByParameter(HttpServletRequest request) {
        String idFichier = request.getParameter("ID_FICHIER");
        Long lidFichier = null;
        try {
            lidFichier = Long.parseLong(idFichier);
        }
        catch (NumberFormatException e) {
            LOG.debug("unable to parse the file's id", (Throwable)e);
        }
        return Media.getMedia(lidFichier);
    }

    private Media getMediaByUrl(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String sMedia = StringUtils.substringAfterLast((String)uri, (String)"/");
        if (StringUtils.isNotBlank((CharSequence)sMedia)) {
            try {
                sMedia = URLDecoder.decode(sMedia, CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Erreur lors du d\u00e9codage de l'URL du m\u00e9dia '{}'", (Object)sMedia, (Object)e);
            }
            return Media.getMediaParUrlOuUrlVignette(ContexteUtil.getContexteUniv(), sMedia);
        }
        return null;
    }

    private void setApercu(HttpServletRequest request) {
        String uri = request.getRequestURI();
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)request.getSession().getAttribute("session");
        if (sessionUtilisateur != null) {
            Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
            if (infosSession != null && infosSession.get(uri) != null) {
                this.isApercu = Boolean.TRUE;
                infosSession.remove(uri);
            } else {
                this.isApercu = Boolean.FALSE;
            }
        }
    }

    private void performFichiergw(HttpServletRequest request, HttpServletResponse response, Media media) {
        try {
            boolean ok;
            int status;
            ContexteUniv ctx;
            block17: {
                block18: {
                    block19: {
                        long idFiche;
                        ctx = ContexteUtil.getContexteUniv();
                        status = 404;
                        long l = idFiche = request.getParameter("ID_FICHE") == null ? 0L : Long.valueOf(request.getParameter("ID_FICHE"));
                        if (media == null || StringUtils.isBlank((CharSequence)media.getSource())) {
                            this.traiterFluxError(ctx, request, response, status);
                            return;
                        }
                        ok = Boolean.TRUE;
                        boolean controleApercu = Boolean.FALSE;
                        if (this.isApercu) break block17;
                        if (media.isPublic()) break block18;
                        ok = Boolean.FALSE;
                        Ressource ressource = new Ressource();
                        ressource.init();
                        ressource.setCtx(ctx);
                        RequeteSQL requeteSelect = new RequeteSQL();
                        ClauseOrderBy orderBy = new ClauseOrderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
                        ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("ID_MEDIA", String.valueOf(media.getIdMedia())));
                        if (idFiche != 0L) {
                            where.and(ConditionHelper.like("CODE_PARENT", String.valueOf(idFiche), "", ",%"));
                            controleApercu = Boolean.TRUE;
                        }
                        where.and(ConditionHelper.notEgal("ETAT", "0", TypeOperande.VARCHAR));
                        requeteSelect.where(where).orderBy(orderBy);
                        if (idFiche != 0L && ressource.select(requeteSelect.formaterRequete()) <= 0) {
                            requeteSelect = new RequeteSQL();
                            orderBy = new ClauseOrderBy("ID_RESSOURCE", ClauseOrderBy.SensDeTri.DESC);
                            where = new ClauseWhere(ConditionHelper.egalVarchar("ID_MEDIA", String.valueOf(media.getIdMedia())));
                            where.and(ConditionHelper.notEgal("ETAT", "0", TypeOperande.VARCHAR));
                            requeteSelect.where(where).orderBy(orderBy);
                        }
                        if (ressource.select(requeteSelect.formaterRequete()) <= 0) break block19;
                        while (ressource.nextItem()) {
                            block20: {
                                String codeParent;
                                block21: {
                                    String typeObjet;
                                    FicheUniv ficheUniv;
                                    codeParent = ressource.getCodeParent();
                                    if (!StringUtils.isNotEmpty((CharSequence)codeParent) || codeParent.startsWith("TYPE") || !"1".equals(ressource.getEtat()) && (!controleApercu || !"2".equals(ressource.getEtat()))) break block20;
                                    if (idFiche == 0L) {
                                        String idFicheString = codeParent.substring(0, codeParent.indexOf(","));
                                        idFiche = Long.valueOf(idFicheString);
                                    }
                                    if ((ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(typeObjet = this.getTypeObjet(codeParent)))) == null) break block21;
                                    ficheUniv.setCtx(ctx);
                                    ficheUniv.init();
                                    ficheUniv.setIdFiche(idFiche);
                                    try {
                                        ficheUniv.retrieve();
                                    }
                                    catch (Exception e) {
                                        if ("2".equals(ressource.getEtat()) && controleApercu) {
                                            ok = Boolean.TRUE;
                                            break block17;
                                        }
                                        idFiche = 0L;
                                        continue;
                                    }
                                    if ("0001".equals(ficheUniv.getEtatObjet())) {
                                        status = 403;
                                    } else if ("0007".equals(ficheUniv.getEtatObjet())) {
                                        status = 410;
                                    }
                                    if (!EtatFiche.EN_LIGNE.getEtat().equals(ficheUniv.getEtatObjet()) && !EtatFiche.SAUVEGARDE_AUTO.getEtat().equals(ficheUniv.getEtatObjet()) && !EtatFiche.APERCU.getEtat().equals(ficheUniv.getEtatObjet())) break block20;
                                    if (FicheUnivMgr.controlerRestriction(ficheUniv, ctx)) {
                                        ok = Boolean.TRUE;
                                        break block17;
                                    }
                                    status = 403;
                                    break block20;
                                }
                                for (String type : extraType) {
                                    if (!codeParent.contains("TYPE=" + type)) continue;
                                    ok = Boolean.TRUE;
                                    break;
                                }
                            }
                            idFiche = 0L;
                        }
                        break block17;
                    }
                    ok = Rubrique.controlerRestrictionRubrique(ctx, media.getCodeRubrique());
                    break block17;
                }
                ok = Rubrique.controlerRestrictionRubrique(ctx, media.getCodeRubrique());
            }
            if (ok) {
                this.traiterFluxMedia(ctx, request, response, media);
            } else {
                this.traiterFluxError(ctx, request, response, status);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getTypeObjet(String codeParent) {
        String typeObjet = "";
        if (StringUtils.isNotBlank((CharSequence)codeParent) && StringUtils.isNotBlank((CharSequence)(typeObjet = codeParent.substring(codeParent.indexOf("TYPE=") + 5))) && typeObjet.length() > 4) {
            if (typeObjet.contains("_")) {
                typeObjet = typeObjet.substring(typeObjet.indexOf("_") + 1, typeObjet.indexOf("_") + 5);
            }
            if (typeObjet.contains(",")) {
                typeObjet = typeObjet.substring(0, typeObjet.indexOf(","));
            }
        }
        return typeObjet;
    }

    public void traiterFluxMedia(ContexteUniv ctx, HttpServletRequest request, HttpServletResponse response, Media media) throws IOException {
        String pathFichier = media.getPathAbsolu();
        String contentType = "";
        String source = "";
        if (StringUtils.isNotEmpty((CharSequence)media.getUrlVignette()) && request.getRequestURI().endsWith(media.getUrlVignette())) {
            pathFichier = media.getPathVignetteAbsolu();
        } else {
            contentType = media.getFormat();
            source = media.getSource();
        }
        String typeDisposition = "inline";
        if ("FALSE".equals(request.getParameter("INLINE"))) {
            typeDisposition = "attachment";
        }
        this.traiterFluxFile(ctx, request, response, pathFichier, contentType, source, typeDisposition);
    }

    private void traiterFluxFileTmp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String pathFichierTmp = request.getRequestURI();
        String path = Media.getPathAbsoluFichierTmp(pathFichierTmp);
        String typeDisposition = "inline";
        if ("FALSE".equals(request.getParameter("INLINE"))) {
            typeDisposition = "attachment";
        }
        this.traiterFluxFile(ctx, request, response, path, "", "", typeDisposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traiterFluxFile(ContexteUniv ctx, HttpServletRequest request, HttpServletResponse response, String pathFichier, String contentType, String source, String typeDisposition) throws IOException {
        ServletOutputStream writer = response.getOutputStream();
        FileInputStream fis = null;
        boolean noAcces = false;
        File f = new File(pathFichier);
        try {
            fis = new FileInputStream(f);
        }
        catch (Exception fnfe) {
            LOG.warn(fnfe.getMessage());
            response.setStatus(404);
            String s = MessageHelper.getCoreMessage(ctx.getLocale(), "ST_DOCUMENT_INEXISTANT");
            byte[] msg = s.getBytes(CHARSET);
            writer.write(msg);
            writer.close();
            noAcces = true;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        RequeteMgr.terminerRequete(ctx.getIdRequete());
        if (!noAcces) {
            String fileName = f.getName();
            long fsize = f.length();
            long lastModified = f.lastModified();
            String eTag = fileName + "_" + fsize + "_" + lastModified;
            long expires = System.currentTimeMillis() + 604800000L;
            String ifNoneMatch = request.getHeader("If-None-Match");
            boolean processDone = this.processIfNoneMatch(response, ifNoneMatch, eTag, expires);
            if (!processDone) {
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                processDone = this.processIfModifiedSince(response, ifNoneMatch, ifModifiedSince, eTag, expires, lastModified);
            }
            if (!processDone) {
                String ifMatch = request.getHeader("If-Match");
                processDone = this.processIfMatch(response, ifMatch, eTag);
            }
            if (!processDone) {
                long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
                processDone = this.processIfUnmodifiedSince(response, ifUnmodifiedSince, lastModified);
            }
            if (!processDone) {
                Range full = new Range(0L, fsize - 1L, fsize);
                ArrayList<Range> ranges = new ArrayList<Range>();
                String range = request.getHeader("Range");
                String ifRange = request.getHeader("If-Range");
                processDone = this.processRange(response, request, full, ifRange, ranges, range, fsize, eTag, lastModified);
                if (!processDone) {
                    response.setBufferSize(4096);
                    response.setHeader("Content-Disposition", "" + typeDisposition + ";filename=\"" + source + "\"");
                    response.setHeader("Content-Length", String.valueOf(fsize));
                    response.setContentType(contentType);
                    response.setHeader("Accept-Ranges", "bytes");
                    response.setHeader("ETag", eTag);
                    response.setDateHeader("Last-Modified", lastModified);
                    response.setDateHeader("Expires", expires);
                    this.writeFileOnResponse(f, response, writer, full, ranges, contentType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileOnResponse(File file, HttpServletResponse response, ServletOutputStream writer, Range full, List<Range> ranges, String contentType) throws IOException {
        RandomAccessFile input = null;
        try {
            input = new RandomAccessFile(file, "r");
            if (ranges.isEmpty() || ranges.get(0) == full) {
                Range r = full;
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                response.setHeader("Content-Length", String.valueOf(r.length));
                LectureFichiergw.copy(input, (OutputStream)writer, r.start, r.length);
            } else if (ranges.size() == 1) {
                Range r = ranges.get(0);
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                response.setHeader("Content-Length", String.valueOf(r.length));
                response.setStatus(206);
                LectureFichiergw.copy(input, (OutputStream)writer, r.start, r.length);
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                response.setStatus(206);
                for (Range r : ranges) {
                    writer.println();
                    writer.println("--MULTIPART_BYTERANGES");
                    writer.println("Content-Type: " + contentType);
                    writer.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                    LectureFichiergw.copy(input, (OutputStream)writer, r.start, r.length);
                    writer.println();
                    writer.println("--MULTIPART_BYTERANGES--");
                }
            }
        }
        finally {
            LectureFichiergw.close((Closeable)writer);
            LectureFichiergw.close(input);
        }
    }

    private boolean processIfNoneMatch(HttpServletResponse response, String ifNoneMatch, String eTag, long expires) {
        boolean result = false;
        if (ifNoneMatch != null && LectureFichiergw.matches(ifNoneMatch, eTag)) {
            response.setStatus(304);
            response.setHeader("ETag", eTag);
            response.setDateHeader("Expires", expires);
            result = true;
        }
        return result;
    }

    private boolean processIfModifiedSince(HttpServletResponse response, String ifNoneMatch, long ifModifiedSince, String eTag, long expires, long lastModified) {
        boolean result = false;
        if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
            response.setStatus(304);
            response.setHeader("ETag", eTag);
            response.setDateHeader("Expires", expires);
            result = true;
        }
        return result;
    }

    private boolean processIfMatch(HttpServletResponse response, String ifMatch, String eTag) throws IOException {
        boolean result = false;
        if (ifMatch != null && !LectureFichiergw.matches(ifMatch, eTag)) {
            response.sendError(412);
            result = true;
        }
        return result;
    }

    private boolean processIfUnmodifiedSince(HttpServletResponse response, long ifUnmodifiedSince, long lastModified) throws IOException {
        boolean result = false;
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            response.sendError(412);
            result = true;
        }
        return result;
    }

    private boolean processRange(HttpServletResponse response, HttpServletRequest request, Range full, String ifRange, List<Range> ranges, String range, long length, String eTag, long lastModified) throws IOException {
        boolean result = false;
        if (range != null) {
            if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                response.setHeader("Content-Range", "bytes */" + length);
                response.sendError(416);
                result = true;
            } else {
                if (ifRange != null && !ifRange.equals(eTag)) {
                    try {
                        long ifRangeTime = request.getDateHeader("If-Range");
                        if (ifRangeTime != -1L && ifRangeTime + 1000L < lastModified) {
                            ranges.add(full);
                        }
                    }
                    catch (IllegalArgumentException ignore) {
                        ranges.add(full);
                    }
                }
                if (ranges.isEmpty()) {
                    for (String part : range.substring(6).split(",")) {
                        long start = LectureFichiergw.sublong(part, 0, part.indexOf("-"));
                        long end = LectureFichiergw.sublong(part, part.indexOf("-") + 1, part.length());
                        if (start == -1L) {
                            start = length - end;
                            end = length - 1L;
                        } else if (end == -1L || end > length - 1L) {
                            end = length - 1L;
                        }
                        if (start > end) {
                            response.setHeader("Content-Range", "bytes */" + length);
                            response.sendError(416);
                            result = true;
                            continue;
                        }
                        ranges.add(new Range(start, end, length));
                    }
                }
            }
        }
        return result;
    }

    public void traiterFluxError(ContexteUniv ctx, HttpServletRequest request, HttpServletResponse response, int status) throws Exception {
        response.setStatus(status);
        String pageErreur = "";
        if (status == 404 || status == 410) {
            pageErreur = ctx.getInfosSite().getJspFo() + "/error/404.jsp";
        } else if (ctx.getCode().length() > 0) {
            pageErreur = ctx.getInfosSite().getJspFo() + "/error/403.jsp";
        } else {
            String url = URLResolver.getAbsoluteUrl(request.getRequestURI() + "?" + request.getQueryString(), ctx);
            UnivWebFmt.redirigerVersLogin(ctx, response, url);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageErreur)) {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(pageErreur);
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private static void copy(RandomAccessFile input, OutputStream writer, long start, long length) throws IOException {
        byte[] buffer = new byte[4096];
        if (input.length() == length) {
            int read;
            while ((read = input.read(buffer)) > 0) {
                writer.write(buffer, 0, read);
            }
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    writer.write(buffer, 0, read);
                    continue;
                }
                writer.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

