/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.univ.datagrid.bean.CriteresDatagrid;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.processus.ServiceDatagrid;
import com.univ.utils.ContexteUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractServiceDatagrid
implements ServiceDatagrid {
    @Override
    public void traiterAction(HttpServletRequest req) {
    }

    @Override
    public List<ResultatDatagrid> filtrerResultats(List<ResultatDatagrid> resultats, CriteresDatagrid criteres) {
        if (StringUtils.isNotBlank((CharSequence)criteres.getRecherche())) {
            resultats = (List)CollectionUtils.select(resultats, (Predicate)this.retrouvePredicate(criteres.getRecherche()));
        }
        return resultats;
    }

    protected Predicate retrouvePredicate(final String critereRecherche) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && object instanceof ResultatDatagrid && StringUtils.containsIgnoreCase((CharSequence)((ResultatDatagrid)object).getLibelle(), (CharSequence)critereRecherche);
            }
        };
    }

    @Override
    public void trierResultats(List<ResultatDatagrid> resultats, CriteresDatagrid criteres) {
        if (StringUtils.isNotBlank((CharSequence)criteres.getNomColonneATrier()) && !resultats.isEmpty()) {
            CompareGenerique comparaison = new CompareGenerique(criteres.getNomColonneATrier());
            Collections.sort(resultats, comparaison);
            if ("DESC".equalsIgnoreCase(criteres.getSensDuTri())) {
                Collections.reverse(resultats);
            }
        }
    }

    @Override
    public List<ResultatDatagrid> postTraitementResultat(List<ResultatDatagrid> resultats) {
        return resultats;
    }

    protected static class CompareGenerique
    implements Comparator<ResultatDatagrid> {
        private final String nomChamp;

        CompareGenerique(String nomChamp) {
            this.nomChamp = nomChamp;
        }

        @Override
        public int compare(ResultatDatagrid resultatA, ResultatDatagrid resultatB) {
            int retour = 0;
            Collator localeCollator = Collator.getInstance(ContexteUtil.getContexteUniv().getLocale());
            localeCollator.setStrength(1);
            try {
                Object fieldValueA = PropertyUtils.getProperty((Object)resultatA, (String)this.nomChamp);
                Object fieldValueB = PropertyUtils.getProperty((Object)resultatB, (String)this.nomChamp);
                retour = fieldValueA == null && fieldValueB == null ? 0 : (fieldValueA == null ? -1 : (fieldValueB == null ? 1 : (fieldValueA instanceof Date ? ((Date)fieldValueA).compareTo((Date)fieldValueB) : (fieldValueA instanceof Collection && !((Collection)fieldValueA).isEmpty() && !((Collection)fieldValueA).isEmpty() ? ((Comparable)((Collection)fieldValueA).iterator().next()).compareTo(((Collection)fieldValueB).iterator().next()) : (fieldValueA instanceof String ? localeCollator.compare(fieldValueA, fieldValueB) : (fieldValueA instanceof Comparable ? ((Comparable)fieldValueA).compareTo(fieldValueB) : 0))))));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return 0;
            }
            return retour;
        }
    }
}

