/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.core.config.MessageHelper;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.filtre.FiltreFicheUniv;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.processus.FicheUnivDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.FicheUnivHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FicheToolboxDatagrid
extends AbstractServiceDatagrid {
    private static final Logger LOG = LoggerFactory.getLogger(FicheUnivDatagrid.class);
    public static final String ID_BEAN = "ficheToolboxDatagrid";
    private static String PARAM_OBJET = "OBJET";

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        String codeFiche = req.getParameter(PARAM_OBJET);
        List<ResultatDatagrid> resultats = null;
        FicheUniv fiche = FicheUnivHelper.instancierFiche(codeFiche);
        if (fiche != null) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            fiche.setCtx(ctx);
            try {
                String requete = req.getQueryString() + "&NOMBRE=" + DatagridUtils.getNombreMaxDatagrid();
                fiche.traiterRequete(EscapeString.unescapeURL(requete));
                resultats = FicheToolboxDatagrid.mapperResultatRechercheDepuisFicheUniv(fiche);
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cuperer les resultats de la recherche", (Throwable)e);
            }
        }
        if (resultats == null) {
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisFicheUniv(FicheUniv fiche) throws Exception {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        while (fiche.nextItem()) {
            ResultatFicheDatagrid res = new ResultatFicheDatagrid();
            res.setId(fiche.getIdFiche());
            res.setTypeObjet(ReferentielObjets.getCodeObjet(fiche));
            res.setLangue(LangueUtil.getLocale(fiche.getLangue()).getLanguage());
            res.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(fiche.getLangue()));
            res.setLibelle(fiche.getLibelleAffichable());
            res.setCodeFiche(fiche.getCode());
            res.setEtatFiche(MessageHelper.getCoreMessage("ETATFICHE_" + fiche.getEtatObjet()));
            String codeObjet = ReferentielObjets.getCodeObjet(fiche);
            StringBuilder lienToolbox = new StringBuilder("/servlet/com.kportal.servlet.LienPopupServlet").append("?");
            lienToolbox.append("CODE").append("=").append(fiche.getCode()).append("&amp;");
            lienToolbox.append("OBJET").append("=").append(ReferentielObjets.getNomObjet(codeObjet)).append("&amp;");
            lienToolbox.append("LANGUE").append("=").append(fiche.getLangue()).append("&amp;");
            lienToolbox.append("LIBELLE").append("=").append(EscapeString.escapeURL(fiche.getLibelleAffichable()));
            InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(fiche.getCodeRubrique());
            res.setRubrique(rubrique.getIntitule());
            res.setFilAriane(Rubrique.getFilAriane(rubrique.getCode(), ">"));
            try {
                Method m = fiche.getClass().getMethod("getUrl", new Class[0]);
                String url = (String)m.invoke((Object)fiche, new Object[0]);
                lienToolbox.append("&amp;").append("URL").append("=").append(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
            res.setUrl(lienToolbox.toString());
            resultats.add(res);
        }
        return resultats;
    }

    @Override
    protected Predicate retrouvePredicate(String critereRecherche) {
        return new FiltreFicheUniv(critereRecherche);
    }
}

