/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.config.PropertyHelper;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.filtre.FiltreFicheUniv;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.UrlManager;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FicheUnivDatagrid
extends AbstractServiceDatagrid {
    private static final Logger LOG = LoggerFactory.getLogger(FicheUnivDatagrid.class);
    public static final String ID_BEAN = "ficheUnivDatagrid";
    private static final String PARAM_OBJET = "OBJET";

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        String codeFiche = req.getParameter(PARAM_OBJET);
        List<ResultatDatagrid> resultats = null;
        FicheUniv fiche = FicheUnivHelper.instancierFiche(codeFiche);
        if (fiche != null) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            fiche.setCtx(ctx);
            try {
                this.initialiserControleBo(fiche, ctx);
                String requete = req.getQueryString() + "&NOMBRE=" + DatagridUtils.getNombreMaxDatagrid();
                fiche.traiterRequete(EscapeString.unescapeURL(requete));
                this.supprimerControleBO(ctx);
                resultats = FicheUnivDatagrid.mapperResultatRechercheDepuisFicheUniv(fiche);
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cuperer les resultats de la recherche", (Throwable)e);
            }
        }
        if (resultats == null) {
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    private void initialiserControleBo(FicheUniv fiche, ContexteUniv ctx) {
        String idExtension = ReferentielObjets.getExtension(fiche);
        String nomObjet = ReferentielObjets.getNomObjet(fiche);
        String controleBO = PropertyHelper.getProperty(idExtension, "fiche." + nomObjet.toUpperCase() + ".recherche_anonyme");
        ctx.getDatas().put("CONTROLE_PERIMETRE_BO", StringUtils.defaultIfBlank((CharSequence)controleBO, (CharSequence)"1"));
        ctx.getDatas().put("AUTORISATIONS", ctx.getAutorisation());
    }

    private void supprimerControleBO(ContexteUniv ctx) {
        ctx.getDatas().remove("CONTROLE_PERIMETRE_BO");
        ctx.getDatas().remove("AUTORISATIONS");
    }

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisFicheUniv(FicheUniv fiche) throws Exception {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        Map<String, String> libellesParEtat = ReferentielObjets.getEtatsObjet();
        Map<String, String> classParEtat = FicheUnivHelper.getClassEtatsObjet();
        Map<String, String> languageParCodeLangue = DatagridUtils.getLanguageParCodeLangue();
        while (fiche.nextItem()) {
            ResultatFicheDatagrid res = new ResultatFicheDatagrid();
            res.setTypeObjet(codeObjet);
            res.setLibelle(fiche.getLibelleAffichable());
            res.setEtatFiche(libellesParEtat.get(fiche.getEtatObjet()));
            res.setClassEtatFiche(classParEtat.get(fiche.getEtatObjet()));
            res.setId(fiche.getIdFiche());
            res.setCodeFiche(fiche.getCode());
            res.setFilAriane(Rubrique.getFilAriane(fiche.getCodeRubrique(), ">"));
            res.setDateModification(new Date(fiche.getDateModification().getTime()));
            res.setLangue(languageParCodeLangue.get(fiche.getLangue()));
            res.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(fiche.getLangue()));
            res.setRubrique(Rubrique.renvoyerItemRubrique(fiche.getCodeRubrique()).getLibelleAffichable());
            resultats.add(res);
        }
        return resultats;
    }

    @Override
    public void traiterAction(HttpServletRequest req) {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        AutorisationBean autorisations = ctx.getAutorisation();
        Object[] idsFiches = req.getParameterValues("idsFiches");
        String action = req.getParameter("ACTION");
        String typeObjet = req.getParameter(PARAM_OBJET);
        if (idsFiches != null && idsFiches.length > 0 && StringUtils.isNotBlank((CharSequence)action) && StringUtils.isNotBlank((CharSequence)typeObjet)) {
            Metatag metasDesFiches = new Metatag();
            metasDesFiches.init();
            metasDesFiches.setCtx(ctx);
            try {
                int nbFiches = metasDesFiches.selectParCodeIds(ReferentielObjets.getCodeObjet(typeObjet), Arrays.asList(idsFiches));
                if (nbFiches != idsFiches.length) {
                    throw new ErreurAsyncException("impossible de supprimer les fiches selectionn\u00e9es");
                }
                ArrayList<Long> idsMetasATraiter = new ArrayList<Long>();
                while (metasDesFiches.nextItem()) {
                    idsMetasATraiter.add(metasDesFiches.getIdMetatag());
                }
                if ("SUPPRIMER".equals(action)) {
                    FicheUnivHelper.supprimerListeFichesParIdsMeta(idsMetasATraiter, autorisations);
                } else if ("ARCHIVER".equals(action)) {
                    FicheUnivHelper.archiverListeFichesParIdsMeta(idsMetasATraiter, autorisations);
                } else if ("EN_LIGNE".equals(action)) {
                    FicheUnivHelper.mettreEnLigneListeFichesParIdsMeta(idsMetasATraiter, autorisations);
                }
            }
            catch (ErreurAsyncException e) {
                LOG.error("Pas le meme nombre de fiches \u00e0 supprimer que de meta retrouv\u00e9s", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("impossible de traiter l'action : " + action + " sur les Ids metas : " + StringUtils.join((Object[])idsFiches, (String)" ,") + " pour l'utilisateur : " + ctx.getCode(), (Throwable)e);
                throw new ErreurAsyncException(e.getMessage());
            }
        }
    }

    @Override
    protected Predicate retrouvePredicate(String critereRecherche) {
        return new FiltreFicheUniv(critereRecherche);
    }

    @Override
    public List<ResultatDatagrid> postTraitementResultat(List<ResultatDatagrid> resultats) {
        if (CollectionUtils.isNotEmpty(resultats)) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            ResultatDatagrid premierResultat = resultats.get(0);
            String codeObjet = premierResultat.getTypeObjet();
            AutorisationBean autorisations = ctx.getAutorisation();
            Map<String, Objetpartage> objetPartageParCode = ReferentielObjets.getReferentiel().getObjetsByCode();
            Map<String, ResultatFicheDatagrid> resultatsParId = this.getResultatParIDFiche(resultats);
            Metatag leMeta = new Metatag();
            leMeta.setCtx(ctx);
            ClauseWhere whereIdFicheEtCodeObjet = new ClauseWhere(ConditionHelper.in("META_ID_FICHE", resultatsParId.keySet()));
            whereIdFicheEtCodeObjet.and(ConditionHelper.egalVarchar("META_CODE_OBJET", codeObjet));
            try {
                leMeta.select(whereIdFicheEtCodeObjet.formaterSQL());
                while (leMeta.nextItem()) {
                    ResultatFicheDatagrid resultat = resultatsParId.get(String.valueOf(leMeta.getMetaIdFiche()));
                    this.modifUrlEnLigneResultat(leMeta, resultat);
                    this.modifUrlsContributionsResultat(autorisations, objetPartageParCode, leMeta, resultat);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultats;
    }

    private Map<String, ResultatFicheDatagrid> getResultatParIDFiche(List<ResultatDatagrid> resultats) {
        HashMap<String, ResultatFicheDatagrid> resultatsParId = new HashMap<String, ResultatFicheDatagrid>();
        for (ResultatDatagrid resultatDatagrid : resultats) {
            resultatsParId.put(String.valueOf(resultatDatagrid.getId()), (ResultatFicheDatagrid)resultatDatagrid);
        }
        return resultatsParId;
    }

    private void modifUrlsContributionsResultat(AutorisationBean autorisations, Map<String, Objetpartage> objetPartageParCode, Metatag leMeta, ResultatFicheDatagrid resultat) {
        FicheUniv fiche = FicheUnivDatagrid.instacierFicheUniv(leMeta, objetPartageParCode);
        if (autorisations != null && autorisations.estAutoriseAModifierLaFiche(fiche)) {
            resultat.setUrlModification(DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "MODIFIER"));
        }
        if (autorisations != null && autorisations.estAutoriseASupprimerLaFiche(fiche) && !EtatFiche.A_SUPPRIMER.getEtat().equals(leMeta.getMetaEtatObjet())) {
            resultat.setUrlSuppression(DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "SUPPRIMER"));
        }
    }

    private void modifUrlEnLigneResultat(Metatag leMeta, ResultatFicheDatagrid resultat) {
        if (EtatFiche.EN_LIGNE.getEtat().equals(leMeta.getMetaEtatObjet())) {
            InfosSite siteFiche = Site.determinerSiteRubrique(leMeta.getMetaCodeRubrique());
            resultat.setUrl(URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(leMeta), siteFiche, 0));
        }
    }

    private static FicheUniv instacierFicheUniv(Metatag meta, Map<String, Objetpartage> objetPartageParCode) {
        FicheUniv ficheUniv;
        Objetpartage objetCourant = objetPartageParCode.get(meta.getMetaCodeObjet());
        if (objetCourant != null) {
            try {
                ficheUniv = (FicheUniv)Class.forName(objetCourant.getNomClasse()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                return null;
            }
        } else {
            return null;
        }
        ficheUniv.setCodeRattachement(meta.getMetaCodeRattachement());
        ficheUniv.setCodeRubrique(meta.getMetaCodeRubrique());
        if (ficheUniv instanceof FicheRattachementsSecondaires) {
            ((FicheRattachementsSecondaires)((Object)ficheUniv)).setCodeRattachementAutres(Chaine.convertirPointsVirgulesEnAccolades(meta.getMetaCodeRattachementAutres()));
        }
        ficheUniv.setCodeRedacteur(meta.getMetaCodeRedacteur());
        ficheUniv.setCodeValidation(meta.getMetaCodeValidation());
        ficheUniv.setCode(meta.getMetaCode());
        ficheUniv.setLangue(meta.getMetaLangue());
        ficheUniv.setEtatObjet(meta.getMetaEtatObjet());
        if (ficheUniv instanceof DiffusionSelective) {
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicVise(meta.getMetaDiffusionPublicVise());
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionModeRestriction(meta.getMetaDiffusionModeRestriction());
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicViseRestriction(meta.getMetaDiffusionPublicViseRestriction());
        }
        return ficheUniv;
    }
}

