/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.kportal.extension.module.composant.ComposantGroupe;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatGroupeDSI;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupeDSIDatagrid
extends AbstractServiceDatagrid {
    private static final Logger LOG = LoggerFactory.getLogger(GroupeDSIDatagrid.class);
    public static final String ID_BEAN = "groupeDSIDatagrid";

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (this.isPermissionNonValide(autorisations)) {
            return Collections.emptyList();
        }
        List<ResultatDatagrid> resultats = null;
        Groupedsi groupedsi = new Groupedsi();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        groupedsi.setCtx(ctx);
        try {
            groupedsi.select(req.getParameter("CODE"), req.getParameter("TYPE"), req.getParameter("LIBELLE"), req.getParameter("CODE_STRUCTURE"), "");
            resultats = this.mapperResultatRechercheDepuisRubrique(groupedsi);
        }
        catch (Exception e) {
            LOG.error("impossible de r\u00e9cuperer les resultats de la recherche", (Throwable)e);
        }
        if (resultats == null) {
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    private boolean isPermissionNonValide(AutorisationBean autorisations) {
        return autorisations == null || !autorisations.isWebMaster() && !autorisations.possedePermission(ComposantGroupe.getPermissionGestion());
    }

    private List<ResultatDatagrid> mapperResultatRechercheDepuisRubrique(Groupedsi groupedsi) throws Exception {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        ctx.getAutorisation();
        while (groupedsi.nextItem()) {
            ResultatGroupeDSI res = new ResultatGroupeDSI();
            res.setLibelle(groupedsi.getLibelle());
            res.setTypeGroupe(Libelle.getLibelle("11", groupedsi.getType(), ctx.getLocale()));
            res.setStructure(Structure.getLibelleAffichable(groupedsi.getCodeStructure(), ctx.getLangue()));
            res.setUrlModification(DatagridUtils.getUrlActionGroupeDSI(String.valueOf(groupedsi.getIdGroupedsi()), "MODIFIERPARID"));
            res.setUrlSuppression(DatagridUtils.getUrlActionGroupeDSI(String.valueOf(groupedsi.getIdGroupedsi()), "SUPPRIMERPARID"));
            resultats.add(res);
        }
        return resultats;
    }

    @Override
    protected Predicate retrouvePredicate(final String critereRecherche) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                boolean isARetourner = Boolean.FALSE;
                if (object instanceof ResultatGroupeDSI) {
                    ResultatGroupeDSI groupes = (ResultatGroupeDSI)object;
                    isARetourner = StringUtils.containsIgnoreCase((CharSequence)groupes.getLibelle(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)groupes.getTypeGroupe(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)groupes.getStructure(), (CharSequence)critereRecherche);
                }
                return isARetourner;
            }
        };
    }
}

