/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.extension.module.composant.ComposantLibelle;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatLibelle;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.cache.CacheLibelleManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Libelle;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibelleDatagrid
extends AbstractServiceDatagrid {
    public static final String ID_BEAN = "libelleDatagrid";
    private static final Logger LOG = LoggerFactory.getLogger(LibelleDatagrid.class);
    private final CacheLibelleManager cache = (CacheLibelleManager)ApplicationContextManager.getCoreContextBean("cacheLibelleManager");

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (this.isPermissionNonValide(autorisations)) {
            return Collections.emptyList();
        }
        List<ResultatDatagrid> resultats = null;
        RequeteSQL requete = this.constuireRequete(req);
        Libelle libelleCourant = new Libelle();
        libelleCourant.init();
        libelleCourant.setCtx(ContexteUtil.getContexteUniv());
        try {
            libelleCourant.selectNoCount(requete.formaterRequete());
            resultats = this.mapperResultatRechercheDepuisLibelle(libelleCourant);
        }
        catch (Exception e) {
            LOG.error("erreur de traitement de datagrid", (Throwable)e);
        }
        return resultats;
    }

    private RequeteSQL constuireRequete(HttpServletRequest req) {
        String langue;
        String type;
        String code;
        RequeteSQL requete = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        String libelle = req.getParameter("LIBELLE");
        if (StringUtils.isNotBlank((CharSequence)libelle)) {
            where.setPremiereCondition(ConditionHelper.egalVarchar("LIBELLE", libelle));
        }
        if (StringUtils.isNotBlank((CharSequence)(code = req.getParameter("CODE")))) {
            where.and(ConditionHelper.egalVarchar("CODE", code));
        }
        if (StringUtils.isNotBlank((CharSequence)(type = req.getParameter("TYPE"))) && !"0000".equals(type)) {
            where.and(ConditionHelper.egalVarchar("TYPE", type));
        }
        if (StringUtils.isNotBlank((CharSequence)(langue = req.getParameter("LANGUE"))) && !"0000".equals(langue)) {
            where.and(ConditionHelper.egalVarchar("LANGUE", langue));
        }
        ClauseOrderBy orderBy = new ClauseOrderBy();
        orderBy.orderBy("TYPE", ClauseOrderBy.SensDeTri.ASC).orderBy("LANGUE", ClauseOrderBy.SensDeTri.ASC).orderBy("LIBELLE", ClauseOrderBy.SensDeTri.ASC);
        requete.where(where);
        requete.orderBy(orderBy);
        return requete;
    }

    private List<ResultatDatagrid> mapperResultatRechercheDepuisLibelle(Libelle libelle) throws Exception {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        HashMap<String, ResultatLibelle> libellesParTypeCode = new HashMap<String, ResultatLibelle>();
        while (libelle.nextItem()) {
            ResultatLibelle lib = new ResultatLibelle();
            lib.setCode(libelle.getCode());
            lib.setType(this.cache.getListeTypesLibelles().get(libelle.getType()));
            lib.setUrlModification(DatagridUtils.getUrlActionLibelle(String.valueOf(libelle.getIdLibelle()), "MODIFIERPARID"));
            if (libelle.isLibelleSupprimable()) {
                lib.setUrlSuppression(DatagridUtils.getUrlActionLibelle(String.valueOf(libelle.getIdLibelle()), "SUPPRIMERPARID"));
            }
            if (!libellesParTypeCode.containsKey(libelle.getType() + libelle.getCode())) {
                lib.addLibelleParLangue(libelle.getLangue(), libelle.getLibelle());
                libellesParTypeCode.put(libelle.getType() + libelle.getCode(), lib);
                continue;
            }
            ResultatLibelle libelleCourant = (ResultatLibelle)libellesParTypeCode.get(libelle.getType() + libelle.getCode());
            libelleCourant.addLibelleParLangue(libelle.getLangue(), libelle.getLibelle());
        }
        resultats.addAll(libellesParTypeCode.values());
        return resultats;
    }

    private boolean isPermissionNonValide(AutorisationBean autorisations) {
        return autorisations == null || !autorisations.isWebMaster() && !autorisations.possedePermission(ComposantLibelle.getPermissionGestion());
    }

    @Override
    protected Predicate retrouvePredicate(final String critereRecherche) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                boolean isARetourner;
                block2: {
                    isARetourner = Boolean.FALSE;
                    if (!(object instanceof ResultatLibelle)) break block2;
                    ResultatLibelle libelle = (ResultatLibelle)object;
                    boolean bl = isARetourner = StringUtils.containsIgnoreCase((CharSequence)libelle.getType(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)libelle.getCode(), (CharSequence)critereRecherche);
                    if (!isARetourner) {
                        ResultatLibelle.LibelleParLangue libParLangue;
                        Iterator<ResultatLibelle.LibelleParLangue> iterator = libelle.getLibelleParLangue().iterator();
                        while (iterator.hasNext() && !(isARetourner = StringUtils.containsIgnoreCase((CharSequence)(libParLangue = iterator.next()).getLibelle(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)libParLangue.getLangue(), (CharSequence)critereRecherche))) {
                        }
                    }
                }
                return isARetourner;
            }
        };
    }
}

