/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.filtre.FiltreFicheUniv;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.UrlManager;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.DateUtil;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.SessionUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.recherche.RechercheMultificheHelper;
import com.univ.utils.recherche.ResultatRechercheMultifiche;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFicheDatagrid
extends AbstractServiceDatagrid {
    public static final String ID_BEAN = "multiFicheDatagrid";
    private static Logger LOG = LoggerFactory.getLogger(MultiFicheDatagrid.class);

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (autorisations == null) {
            return Collections.emptyList();
        }
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String libelle = req.getParameter("TITRE");
        String codeObjet = req.getParameter("CODE_OBJET");
        String codeFiche = req.getParameter("CODE_FICHE");
        String codeRubrique = req.getParameter("CODE_RUBRIQUE_RECHERCHE");
        String codeRattachement = req.getParameter("CODE_RATTACHEMENT");
        String codeRedacteur = req.getParameter("CODE_REDACTEUR");
        String idMeta = req.getParameter("ID_META");
        String urlFiche = req.getParameter("URL_FICHE");
        String langue = req.getParameter("LANGUE");
        String etatObjet = req.getParameter("ETAT_OBJET");
        Date dateDebutCreation = this.recupererAttributDate(req, "DATE_CREATION_DEBUT");
        Date dateFinCreation = this.recupererAttributDate(req, "DATE_CREATION_FIN");
        Date dateDebutModification = this.recupererAttributDate(req, "DATE_MODIFICATION_DEBUT");
        Date dateFinModification = this.recupererAttributDate(req, "DATE_MODIFICATION_FIN");
        Date dateDebutMiseEnLigne = this.recupererAttributDate(req, "DATE_MISE_EN_LIGNE_DEBUT");
        Date dateFinMiseEnLigne = this.recupererAttributDate(req, "DATE_MISE_EN_LIGNE_FIN");
        ResultatRechercheMultifiche resultatRechercheMultifiche = null;
        List<ResultatDatagrid> resultats = null;
        try {
            resultatRechercheMultifiche = RechercheMultificheHelper.rerchercherParmisToutesLesFiches(ctx, autorisations, libelle, codeObjet, codeFiche, codeRubrique, codeRattachement, codeRedacteur, idMeta, urlFiche, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne, langue, etatObjet, String.valueOf(DatagridUtils.getNombreMaxDatagrid()));
            resultats = MultiFicheDatagrid.mapperResultatRechercheDepuisMeta(resultatRechercheMultifiche.getResultats());
        }
        catch (Exception e) {
            LOG.error("impossible d'executer la recherche", (Throwable)e);
            return Collections.emptyList();
        }
        return resultats;
    }

    private Date recupererAttributDate(HttpServletRequest req, String nomAttribut) {
        Date dateDepuisRequete = null;
        try {
            dateDepuisRequete = DateUtil.parseDate(req.getParameter(nomAttribut));
            if (!Formateur.estSaisie(dateDepuisRequete)) {
                dateDepuisRequete = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateDepuisRequete;
    }

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisMeta(Collection<Metatag> metatags) {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        Map<String, String> libellesParEtat = ReferentielObjets.getEtatsObjet();
        Map<String, String> classParEtat = FicheUnivHelper.getClassEtatsObjet();
        for (Metatag leMeta : metatags) {
            ResultatFicheDatagrid resultat = new ResultatFicheDatagrid();
            resultat.setFilAriane(Rubrique.getFilAriane(leMeta.getMetaCodeRubrique(), ">"));
            resultat.setId(leMeta.getIdMetatag());
            resultat.setRubrique(Rubrique.getIntitule(leMeta.getMetaCodeRubrique()));
            resultat.setLibelle(leMeta.getMetaLibelleFiche());
            resultat.setEtatFiche(libellesParEtat.get(leMeta.getMetaEtatObjet()));
            resultat.setClassEtatFiche(classParEtat.get(leMeta.getMetaEtatObjet()));
            resultat.setLangue(LangueUtil.getLocale(leMeta.getMetaLangue()).getLanguage());
            resultat.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(leMeta.getMetaLangue()));
            resultat.setTypeObjet(ReferentielObjets.getLibelleObjet(leMeta.getMetaCodeObjet()));
            resultat.setDateModification(new java.util.Date(leMeta.getMetaDateModification().getTime()));
            resultats.add(resultat);
        }
        return resultats;
    }

    @Override
    public void traiterAction(HttpServletRequest req) {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        AutorisationBean autorisations = ctx.getAutorisation();
        Object[] idsMetas = req.getParameterValues("idsMetas");
        String action = req.getParameter("ACTION");
        if (idsMetas != null && idsMetas.length > 0 && StringUtils.isNotBlank((CharSequence)action)) {
            Collection idsMetasATraiter = CollectionUtils.collect(Arrays.asList(idsMetas), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return Long.valueOf((String)input);
                }
            });
            try {
                if ("SUPPRIMER".equals(action)) {
                    FicheUnivHelper.supprimerListeFichesParIdsMeta(idsMetasATraiter, autorisations);
                } else if ("ARCHIVER".equals(action)) {
                    FicheUnivHelper.archiverListeFichesParIdsMeta(idsMetasATraiter, autorisations);
                } else if ("EN_LIGNE".equals(action)) {
                    FicheUnivHelper.mettreEnLigneListeFichesParIdsMeta(idsMetasATraiter, autorisations);
                }
            }
            catch (Exception e) {
                LOG.error("impossible de traiter l'action : " + action + " sur les Ids metas : " + StringUtils.join((Object[])idsMetas, (String)" ,") + " pour l'utilisateur : " + ctx.getCode(), (Throwable)e);
            }
        }
    }

    @Override
    protected Predicate retrouvePredicate(String critereRecherche) {
        return new FiltreFicheUniv(critereRecherche);
    }

    @Override
    public List<ResultatDatagrid> postTraitementResultat(List<ResultatDatagrid> resultats) {
        if (CollectionUtils.isNotEmpty(resultats)) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            Map<String, ResultatFicheDatagrid> resultatsParId = this.getResultatParIDMetatag(resultats);
            AutorisationBean autorisations = ctx.getAutorisation();
            Map<String, Objetpartage> objetPartageParCode = ReferentielObjets.getReferentiel().getObjetsByCode();
            Metatag leMeta = new Metatag();
            leMeta.setCtx(ctx);
            ClauseWhere whereIdMeta = new ClauseWhere(ConditionHelper.in("ID_METATAG", resultatsParId.keySet()));
            try {
                leMeta.select(whereIdMeta.formaterSQL());
                while (leMeta.nextItem()) {
                    ResultatFicheDatagrid resultat = resultatsParId.get(String.valueOf(leMeta.getIdMetatag()));
                    this.modifUrlEnLigneResultat(leMeta, resultat);
                    this.modifUrlsContributionsResultat(autorisations, objetPartageParCode, leMeta, resultat);
                }
            }
            catch (Exception e1) {
                LOG.error("erreur dans la requete ou le parcours des resultats", (Throwable)e1);
            }
        }
        return resultats;
    }

    private void modifUrlsContributionsResultat(AutorisationBean autorisations, Map<String, Objetpartage> objetPartageParCode, Metatag leMeta, ResultatFicheDatagrid resultat) {
        FicheUniv fiche = MultiFicheDatagrid.instacierFicheUniv(leMeta, objetPartageParCode);
        if (autorisations != null && autorisations.estAutoriseAModifierLaFiche(fiche)) {
            resultat.setUrlModification(DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "MODIFIER"));
        }
        if (autorisations != null && autorisations.estAutoriseASupprimerLaFiche(fiche) && !EtatFiche.A_SUPPRIMER.getEtat().equals(leMeta.getMetaEtatObjet())) {
            resultat.setUrlSuppression(DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "SUPPRIMER"));
        }
    }

    private static FicheUniv instacierFicheUniv(Metatag meta, Map<String, Objetpartage> objetPartageParCode) {
        Objetpartage objetCourant = objetPartageParCode.get(meta.getMetaCodeObjet());
        FicheUniv ficheUniv = null;
        if (objetCourant != null) {
            try {
                ficheUniv = (FicheUniv)Class.forName(objetCourant.getNomClasse()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                return null;
            }
        } else {
            return null;
        }
        ficheUniv.setCodeRattachement(meta.getMetaCodeRattachement());
        ficheUniv.setCodeRubrique(meta.getMetaCodeRubrique());
        if (ficheUniv instanceof FicheRattachementsSecondaires) {
            ((FicheRattachementsSecondaires)((Object)ficheUniv)).setCodeRattachementAutres(Chaine.convertirPointsVirgulesEnAccolades(meta.getMetaCodeRattachementAutres()));
        }
        ficheUniv.setCodeRedacteur(meta.getMetaCodeRedacteur());
        ficheUniv.setCodeValidation(meta.getMetaCodeValidation());
        ficheUniv.setCode(meta.getMetaCode());
        ficheUniv.setLangue(meta.getMetaLangue());
        ficheUniv.setEtatObjet(meta.getMetaEtatObjet());
        if (ficheUniv instanceof DiffusionSelective) {
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicVise(meta.getMetaDiffusionPublicVise());
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionModeRestriction(meta.getMetaDiffusionModeRestriction());
            ((DiffusionSelective)((Object)ficheUniv)).setDiffusionPublicViseRestriction(meta.getMetaDiffusionPublicViseRestriction());
        }
        return ficheUniv;
    }

    private void modifUrlEnLigneResultat(Metatag leMeta, ResultatFicheDatagrid resultat) {
        if (EtatFiche.EN_LIGNE.getEtat().equals(leMeta.getMetaEtatObjet())) {
            InfosSite siteFiche = Site.determinerSiteRubrique(leMeta.getMetaCodeRubrique());
            resultat.setUrl(URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(leMeta), siteFiche, 0));
        }
    }

    private Map<String, ResultatFicheDatagrid> getResultatParIDMetatag(List<ResultatDatagrid> resultats) {
        HashMap<String, ResultatFicheDatagrid> resultatsParId = new HashMap<String, ResultatFicheDatagrid>();
        for (ResultatDatagrid resultatDatagrid : resultats) {
            resultatsParId.put(String.valueOf(resultatDatagrid.getId()), (ResultatFicheDatagrid)resultatDatagrid);
        }
        return resultatsParId;
    }
}

