/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.filtre.FiltreFicheUniv;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.DateUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.SessionUtil;
import com.univ.utils.recherche.RechercheMultificheHelper;
import com.univ.utils.recherche.ResultatRechercheMultifiche;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFicheToolboxDatagrid
extends AbstractServiceDatagrid {
    public static final String ID_BEAN = "multiFicheToolboxDatagrid";
    private static Logger LOG = LoggerFactory.getLogger(MultiFicheToolboxDatagrid.class);

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (autorisations == null) {
            return Collections.emptyList();
        }
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String libelle = req.getParameter("TITRE");
        String codeObjet = req.getParameter("CODE_OBJET");
        String codeRubrique = req.getParameter("CODE_RUBRIQUE_RECHERCHE");
        String codeRattachement = req.getParameter("CODE_RATTACHEMENT");
        String codeRedacteur = req.getParameter("CODE_REDACTEUR");
        String idMeta = req.getParameter("ID_META");
        String urlFiche = req.getParameter("URL_FICHE");
        String langue = req.getParameter("LANGUE");
        String etatObjet = EtatFiche.EN_LIGNE.getEtat();
        Date dateDebutCreation = this.recupererAttributDate(req, "DATE_CREATION_DEBUT");
        Date dateFinCreation = this.recupererAttributDate(req, "DATE_CREATION_FIN");
        Date dateDebutModification = this.recupererAttributDate(req, "DATE_MODIFICATION_DEBUT");
        Date dateFinModification = this.recupererAttributDate(req, "DATE_MODIFICATION_FIN");
        Date dateDebutMiseEnLigne = this.recupererAttributDate(req, "DATE_MISE_EN_LIGNE_DEBUT");
        Date dateFinMiseEnLigne = this.recupererAttributDate(req, "DATE_MISE_EN_LIGNE_FIN");
        ResultatRechercheMultifiche resultatRechercheMultifiche = null;
        List<ResultatDatagrid> resultats = null;
        try {
            resultatRechercheMultifiche = RechercheMultificheHelper.rerchercherParmisToutesLesFiches(ctx, autorisations, libelle, codeObjet, "", codeRubrique, codeRattachement, codeRedacteur, idMeta, urlFiche, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne, langue, etatObjet, String.valueOf(DatagridUtils.getNombreMaxDatagrid()));
            resultats = MultiFicheToolboxDatagrid.mapperResultatRechercheDepuisMeta(resultatRechercheMultifiche.getResultats());
        }
        catch (Exception e) {
            LOG.error("impossible d'executer la recherche", (Throwable)e);
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    private Date recupererAttributDate(HttpServletRequest req, String nomAttribut) {
        Date dateDepuisRequete = null;
        try {
            dateDepuisRequete = DateUtil.parseDate(req.getParameter(nomAttribut));
            if (!Formateur.estSaisie(dateDepuisRequete)) {
                dateDepuisRequete = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateDepuisRequete;
    }

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisMeta(Collection<Metatag> metatags) {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        for (Metatag leMeta : metatags) {
            ResultatFicheDatagrid resultat = new ResultatFicheDatagrid();
            resultat.setLibelle(leMeta.getMetaLibelleFiche());
            try {
                resultat.setRubrique(Rubrique.getIntitule(leMeta.getMetaCodeRubrique()));
            }
            catch (Exception e) {
                LOG.error("impossible de calculer l'intitule de rubrique", (Throwable)e);
            }
            resultat.setLangue(LangueUtil.getLocale(leMeta.getMetaLangue()).getLanguage());
            resultat.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(leMeta.getMetaLangue()));
            resultat.setTypeObjet(ReferentielObjets.getLibelleObjet(leMeta.getMetaCodeObjet()));
            StringBuilder lienToolbox = new StringBuilder("/servlet/com.kportal.servlet.LienPopupServlet").append("?");
            lienToolbox.append("CODE").append("=").append(leMeta.getMetaCode()).append("&amp;");
            lienToolbox.append("OBJET").append("=").append(ReferentielObjets.getNomObjet(leMeta.getMetaCodeObjet())).append("&amp;");
            lienToolbox.append("LANGUE").append("=").append(leMeta.getMetaLangue()).append("&amp;");
            lienToolbox.append("LIBELLE").append("=").append(EscapeString.escapeURL(leMeta.getMetaLibelleFiche()));
            resultat.setUrl(lienToolbox.toString());
            resultats.add(resultat);
        }
        return resultats;
    }

    @Override
    protected Predicate retrouvePredicate(String critereRecherche) {
        return new FiltreFicheUniv(critereRecherche);
    }
}

