/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatFicheDatagrid;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.multisites.InfosSite;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.url.UrlManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.SessionUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RattachementPrincipalDatagrid
extends AbstractServiceDatagrid {
    private static final Logger LOG = LoggerFactory.getLogger(RattachementPrincipalDatagrid.class);

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisMeta(Metatag leMeta) throws Exception {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        InfosSite siteCourant = ContexteUtil.getContexteUniv().getInfosSite();
        Map<String, String> libellesParEtat = ReferentielObjets.getEtatsObjet();
        Map<String, String> classParEtat = FicheUnivHelper.getClassEtatsObjet();
        while (leMeta.nextItem()) {
            String url;
            ResultatFicheDatagrid resultat = new ResultatFicheDatagrid();
            resultat.setFilAriane(Rubrique.getFilAriane(leMeta.getMetaCodeRubrique(), ">"));
            resultat.setRubrique(Rubrique.getIntitule(leMeta.getMetaCodeRubrique()));
            FicheUniv fiche = FicheUnivMgr.init(leMeta);
            if (fiche == null) continue;
            resultat.setId(leMeta.getIdMetatag());
            AutorisationBean autorisations = ContexteUtil.getContexteUniv().getAutorisation();
            if (autorisations != null && autorisations.estAutoriseAModifierLaFiche(fiche)) {
                url = DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "MODIFIER");
                resultat.setUrlModification(URLResolver.getAbsoluteBoUrl(url, siteCourant));
            }
            if (autorisations != null && autorisations.estAutoriseASupprimerLaFiche(fiche) && !EtatFiche.A_SUPPRIMER.getEtat().equals(leMeta.getMetaEtatObjet())) {
                url = DatagridUtils.getUrlActionFiche(leMeta.getMetaCodeObjet(), leMeta.getMetaIdFiche(), "SUPPRIMER");
                resultat.setUrlSuppression(URLResolver.getAbsoluteBoUrl(url, siteCourant));
            }
            resultat.setLibelle(leMeta.getMetaLibelleFiche());
            resultat.setEtatFiche(libellesParEtat.get(leMeta.getMetaEtatObjet()));
            resultat.setClassEtatFiche(classParEtat.get(leMeta.getMetaEtatObjet()));
            resultat.setLangue(LangueUtil.getLocale(leMeta.getMetaLangue()).getLanguage());
            resultat.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(leMeta.getMetaLangue()));
            resultat.setTypeObjet(ReferentielObjets.getLibelleObjet(leMeta.getMetaCodeObjet()));
            resultat.setDateModification(new Date(leMeta.getMetaDateModification().getTime()));
            if (EtatFiche.EN_LIGNE.getEtat().equals(leMeta.getMetaEtatObjet())) {
                resultat.setUrl(URLResolver.getAbsoluteBoUrl(UrlManager.calculerUrlFiche(leMeta), siteCourant));
            }
            resultats.add(resultat);
        }
        return resultats;
    }

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (autorisations == null || !autorisations.isAdministrateurRubrique()) {
            return Collections.emptyList();
        }
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String codeRubrique = StringUtils.defaultString((String)req.getParameter("CODE_RUBRIQUE"));
        List<ResultatDatagrid> resultats = null;
        try {
            RequeteSQL requeteSelect = new RequeteSQL();
            ClauseWhere where = new ClauseWhere();
            where.and(ConditionHelper.egalVarchar("T1.META_CODE_RUBRIQUE", codeRubrique));
            requeteSelect.where(where);
            requeteSelect.limit(LimitHelper.ajouterCriteresLimitesEtOptimisation(ctx, 0, DatagridUtils.getNombreMaxDatagrid()));
            Metatag meta = new Metatag();
            meta.init();
            meta.setCtx(ctx);
            meta.select(requeteSelect.formaterRequete());
            resultats = RattachementPrincipalDatagrid.mapperResultatRechercheDepuisMeta(meta);
        }
        catch (Exception e) {
            LOG.error("impossible d'executer la recherche", (Throwable)e);
            resultats = Collections.emptyList();
        }
        return resultats;
    }
}

