/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatRubrique;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriqueDatagrid
extends AbstractServiceDatagrid {
    private static final Logger LOG = LoggerFactory.getLogger(RubriqueDatagrid.class);
    public static final String ID_BEAN = "rubriqueDatagrid";

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        List<ResultatDatagrid> resultats = null;
        Rubrique rubriquePourRequete = new Rubrique();
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        rubriquePourRequete.setCtx(ctx);
        try {
            rubriquePourRequete.select(req.getParameter("CODE"), req.getParameter("LANGUE"), req.getParameter("INTITULE"), req.getParameter("CODE_SAISI"));
            resultats = RubriqueDatagrid.mapperResultatRechercheDepuisRubrique(rubriquePourRequete);
        }
        catch (Exception e) {
            LOG.error("impossible de r\u00e9cuperer les resultats de la recherche", (Throwable)e);
        }
        if (resultats == null) {
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    public static List<ResultatDatagrid> mapperResultatRechercheDepuisRubrique(Rubrique rubriquePourRequete) throws Exception {
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        AutorisationBean autorisations = ContexteUtil.getContexteUniv().getAutorisation();
        Map<String, String> languageParCodeLangue = DatagridUtils.getLanguageParCodeLangue();
        PermissionBean permissionSuppressionRubrique = new PermissionBean("TECH", "rub", "S");
        PermissionBean permissionModificationRubrique = new PermissionBean("TECH", "rub", "M");
        while (rubriquePourRequete.nextItem()) {
            Perimetre perimetreRubriqueCourante = new Perimetre("*", rubriquePourRequete.getCode(), "*", "*", "");
            if (autorisations == null || !autorisations.possedePermission(permissionModificationRubrique, perimetreRubriqueCourante) && !autorisations.possedePermission(permissionSuppressionRubrique, perimetreRubriqueCourante)) continue;
            ResultatRubrique res = new ResultatRubrique();
            res.setLibelle(rubriquePourRequete.getIntitule());
            res.setRubriqueMere(Rubrique.getIntituleComplet(rubriquePourRequete.getCode(), Boolean.FALSE));
            res.setCode(rubriquePourRequete.getCode());
            res.setLangue(languageParCodeLangue.get(rubriquePourRequete.getLangue()));
            res.setUrlDrapeauLangue(LangueUtil.getPathImageDrapeau(rubriquePourRequete.getLangue()));
            if (autorisations.possedePermission(permissionModificationRubrique, perimetreRubriqueCourante)) {
                res.setUrlModification(DatagridUtils.getUrlActionRubrique(rubriquePourRequete.getCode(), "MODIFIERRUBRIQUEPARCODE"));
            }
            if (autorisations.possedePermission(permissionSuppressionRubrique, perimetreRubriqueCourante)) {
                res.setUrlSuppression(DatagridUtils.getUrlActionRubrique(rubriquePourRequete.getCode(), "SUPPRIMERRUBRIQUEPARCODE"));
            }
            resultats.add(res);
        }
        return resultats;
    }

    @Override
    protected Predicate retrouvePredicate(final String critereRecherche) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                boolean isARetourner = Boolean.FALSE;
                if (object instanceof ResultatRubrique) {
                    ResultatRubrique rubrique = (ResultatRubrique)object;
                    isARetourner = StringUtils.containsIgnoreCase((CharSequence)rubrique.getLibelle(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)rubrique.getRubriqueMere(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)rubrique.getLangue(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)rubrique.getCode(), (CharSequence)critereRecherche);
                }
                return isARetourner;
            }
        };
    }
}

