/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.processus;

import com.kportal.extension.module.composant.ComposantUtilisateur;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.bean.ResultatUtilisateur;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridUtils;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilisateurDatagrid
extends AbstractServiceDatagrid {
    private static final Logger LOG = LoggerFactory.getLogger(UtilisateurDatagrid.class);
    public static final String ID_BEAN = "utilisateurDatagrid";

    @Override
    public List<ResultatDatagrid> traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        if (this.isPermissionNonValide(autorisations)) {
            return Collections.emptyList();
        }
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        String code = req.getParameter("CODE");
        String nom = req.getParameter("NOM");
        String prenom = req.getParameter("PRENOM");
        String profil = req.getParameter("PROFIL_DSI");
        String groupe = req.getParameter("GROUPE_DSI");
        String codeRattachement = req.getParameter("CODE_RATTACHEMENT");
        String adresseMail = req.getParameter("ADRESSE_MAIL");
        Utilisateur utilisateurPourRecherche = new Utilisateur();
        utilisateurPourRecherche.init();
        utilisateurPourRecherche.setCtx(ctx);
        List<ResultatDatagrid> resultats = null;
        try {
            utilisateurPourRecherche.select(code, nom, prenom, "", profil, groupe, codeRattachement, adresseMail);
            resultats = this.mapperResultatRecherche(utilisateurPourRecherche, groupe, ctx.getLangue(), autorisations);
        }
        catch (Exception e) {
            LOG.error("impossible d'executer la recherche", (Throwable)e);
            resultats = Collections.emptyList();
        }
        return resultats;
    }

    private boolean isPermissionNonValide(AutorisationBean autorisations) {
        return autorisations == null || !autorisations.isWebMaster() && !autorisations.possedePermission(ComposantUtilisateur.getPermissionConsultation());
    }

    private List<ResultatDatagrid> mapperResultatRecherche(Utilisateur utilisateurPourRecherche, String groupe, String langue, AutorisationBean autorisations) throws Exception {
        boolean isUtilisateurGestion;
        ArrayList<ResultatDatagrid> resultats = new ArrayList<ResultatDatagrid>();
        boolean bl = isUtilisateurGestion = autorisations.possedePermission(ComposantUtilisateur.getPermissionGestion()) || autorisations.isWebMaster();
        for (int nbUtilisateur = 0; utilisateurPourRecherche.nextItem() && nbUtilisateur < DatagridUtils.getNombreMaxDatagrid(); ++nbUtilisateur) {
            ResultatUtilisateur res = new ResultatUtilisateur();
            res.setId(utilisateurPourRecherche.getIdUtilisateur());
            res.setCode(utilisateurPourRecherche.getCode());
            res.setCivilite(utilisateurPourRecherche.getCivilite());
            res.setNom(utilisateurPourRecherche.getNom());
            res.setMail(utilisateurPourRecherche.getAdresseMail());
            res.setLibelle(utilisateurPourRecherche.getNom() + " " + utilisateurPourRecherche.getPrenom());
            res.setPrenom(utilisateurPourRecherche.getPrenom());
            res.setArboStructure(Structure.getFilAriane(utilisateurPourRecherche.getCodeRattachement(), langue));
            InfosStructure info = Structure.renvoyerItemStructure(utilisateurPourRecherche.getCodeRattachement(), langue);
            res.setStructure(info.getLibelleAffichable());
            if (isUtilisateurGestion) {
                StringBuilder baseUrlAction = new StringBuilder("/servlet/com.jsbsoft.jtf.core.SG?EXT=core&PROC=SAISIE_UTILISATEUR&ID=");
                baseUrlAction.append(String.valueOf(utilisateurPourRecherche.getIdUtilisateur()));
                baseUrlAction.append("&ACTION=");
                res.setUrlModification(baseUrlAction.toString() + "MODIFIERPARID");
                res.setUrlSuppression(baseUrlAction.toString() + "SUPPRIMERPARID");
                res.setUrlSuppressionGroupe("/servlet/com.jsbsoft.jtf.core.SG?EXT=core&PROC=SAISIE_GROUPEDSI&ACTION=SUPPRIMERDUGROUPE&GROUPE_DSI=" + groupe + "&UTILISATEUR=" + utilisateurPourRecherche.getIdUtilisateur());
            }
            resultats.add(res);
        }
        return resultats;
    }

    @Override
    public void traiterAction(HttpServletRequest req) {
        AutorisationBean autorisation;
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        Object[] idsUtilisateur = req.getParameterValues("idsUtilisateur");
        String action = req.getParameter("ACTION");
        if (this.isActionValide(action, autorisation = ctx.getAutorisation(), (String[])idsUtilisateur)) {
            Collection idsMetasATraiter = CollectionUtils.collect(Arrays.asList(idsUtilisateur), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return Long.valueOf((String)input);
                }
            });
            try {
                if ("SUPPRIMER".equals(action)) {
                    for (Long idUser : idsMetasATraiter) {
                        Utilisateur utilisateur = new Utilisateur();
                        utilisateur.init();
                        utilisateur.setCtx(ctx);
                        utilisateur.setIdUtilisateur(idUser);
                        utilisateur.retrieve();
                        Espacecollaboratif.supprimerUtilisateur(utilisateur.getCode());
                        Groupeutilisateur.deleteParUtilisateur(ctx, utilisateur.getCode());
                        utilisateur.delete();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("impossible de traiter : " + action + " sur les Ids metas : " + StringUtils.join((Object[])idsUtilisateur, (String)" ,") + " pour l'utilisateur : " + ctx.getCode(), (Throwable)e);
            }
        }
    }

    private boolean isActionValide(String action, AutorisationBean autorisation, String[] idsUtilisateur) {
        boolean isAutorise = autorisation != null && (autorisation.possedePermission(ComposantUtilisateur.getPermissionGestion()) || autorisation.isWebMaster());
        boolean isUtilisateursValide = idsUtilisateur != null && idsUtilisateur.length > 0;
        return isAutorise && isUtilisateursValide && StringUtils.isNotBlank((CharSequence)action);
    }

    @Override
    protected Predicate retrouvePredicate(final String critereRecherche) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                boolean isARetourner = Boolean.FALSE;
                if (object instanceof ResultatUtilisateur) {
                    ResultatUtilisateur groupes = (ResultatUtilisateur)object;
                    isARetourner = StringUtils.containsIgnoreCase((CharSequence)groupes.getLibelle(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)groupes.getMail(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)groupes.getStructure(), (CharSequence)critereRecherche) || StringUtils.containsIgnoreCase((CharSequence)groupes.getCode(), (CharSequence)critereRecherche);
                }
                return isARetourner;
            }
        };
    }
}

