/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.servlet;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.univ.datagrid.bean.CriteresDatagrid;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.datagrid.cache.CacheDatagridManager;
import com.univ.datagrid.processus.AbstractServiceDatagrid;
import com.univ.datagrid.utils.DatagridManager;
import com.univ.datagrid.utils.DatagridUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class DatagridServlet
extends HttpServlet {
    private static final long serialVersionUID = -5619243850749934120L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AbstractServiceDatagrid gestionDatagrid = DatagridManager.getGestionDatagrid(req.getParameter("BEAN_RECHERCHE"));
        String idRequete = req.getParameter("ID_REQUETE");
        List<ResultatDatagrid> resultats = Collections.emptyList();
        int total = 0;
        int totalAAfficher = 0;
        CriteresDatagrid criteres = CriteresDatagrid.getCritereDepuisRequete(req);
        if (gestionDatagrid != null) {
            String action = req.getParameter("ACTION");
            CacheDatagridManager cacheDatagridManager = (CacheDatagridManager)ApplicationContextManager.getCoreContextBean("cacheDatagridManager");
            if (StringUtils.isNotBlank((CharSequence)action)) {
                cacheDatagridManager.flush(idRequete);
                gestionDatagrid.traiterAction(req);
            } else {
                resultats = cacheDatagridManager.traiterRecherche(idRequete, gestionDatagrid, req);
                gestionDatagrid.trierResultats(resultats, criteres);
                total = resultats.size();
                resultats = gestionDatagrid.filtrerResultats(resultats, criteres);
                totalAAfficher = resultats.size();
                resultats = DatagridUtils.paginerResultats(resultats, criteres);
                resultats = gestionDatagrid.postTraitementResultat(resultats);
            }
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().write(DatagridUtils.mapperResultatEnJSON(resultats, total, totalAAfficher, criteres));
    }
}

