/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.servlet;

import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.FicheUnivMgr;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LienPopupServlet
extends HttpServlet {
    public static final String LIEN_SERVLET = "/servlet/com.kportal.servlet.LienPopupServlet";
    private static final long serialVersionUID = -7317972252389032829L;
    public static final String CODE_OBJET = "CODE";
    public static final String TYPE_OBJET = "OBJET";
    public static final String LANGUE = "LANGUE";
    public static final String LIBELLE = "LIBELLE";
    public static final String TYPE_TOOLBOX = "TOOLBOX";
    public static final String TYPE_LISTE = "LISTE";
    public static final String URL = "URL";
    private static final Logger LOG = LoggerFactory.getLogger(LienPopupServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String typeToolbox = req.getParameter(TYPE_TOOLBOX);
        String typeListe = req.getParameter(TYPE_LISTE);
        String url = req.getParameter(URL);
        String codeObjet = StringUtils.defaultString((String)req.getParameter(CODE_OBJET));
        String typeObjet = StringUtils.defaultString((String)req.getParameter(TYPE_OBJET));
        String langue = StringUtils.defaultString((String)req.getParameter(LANGUE));
        String reponse = "";
        if ("MAILTO".equals(typeToolbox)) {
            reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_mailto.jsp";
        } else if (StringUtils.isNotBlank((CharSequence)url) && !"LIEN_INTERNE_JOINTURE".equals(typeToolbox) && !"LIEN_INTERNE_PAGE_TETE".equals(typeToolbox)) {
            reponse = "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_lien.jsp";
        } else if ("PARCOURS".equals(typeListe)) {
            reponse = "/servlet/com.jsbsoft.jtf.core.SG?EXT=offreformation&PROC=TRAITEMENT_PARCOURS&ACTION=AJOUTER&CODE_UEUP=" + codeObjet + ",LANGUE=" + langue + "&TOOLBOX=true";
        } else if ("RESPONSABLE".equals(typeListe)) {
            reponse = "/servlet/com.jsbsoft.jtf.core.SG?EXT=offreformation&PROC=TRAITEMENT_RESPONSABLE&ACTION=AJOUTER&CODE_RESPONSABLE=" + codeObjet + ",LANGUE=" + langue;
        } else if ("DIPLOME".equals(typeListe) || "FORMATION".equals(typeListe)) {
            reponse = "/servlet/com.jsbsoft.jtf.core.SG?EXT=offreformation&PROC=TRAITEMENT_DIPLOME&ACTION=AJOUTER&CODE_FORMATION=" + codeObjet + ",LANGUE=" + langue + "&&LISTE=" + typeListe;
        } else {
            FicheUniv fiche = null;
            Metatag meta = null;
            try {
                fiche = FicheUnivHelper.getFiche(typeObjet, codeObjet, langue);
                meta = FicheUnivMgr.lireMeta(fiche);
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cuperer la fiche", (Throwable)e);
            }
            reponse = this.isChoixRubriqueForcage(fiche, typeToolbox) ? "/adminsite/toolbox/choix_rubrique_forcage.jsp" : ("LIEN_INTERNE".equals(typeToolbox) ? "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_interne.jsp" : ("LIEN_INTRANET".equals(typeToolbox) ? "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_intranet.jsp" : ("LIEN_RECHERCHE".equals(typeToolbox) ? "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_recherche.jsp" : ("LIEN_INTERNE_PLUGIN".equals(typeToolbox) ? "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_generique.jsp?CODE=" + meta.getIdMetatag() : "/adminsite/fcktoolbox/kosmos/plugins/k_link/choix_lien_generique.jsp?CODE=" + codeObjet + ",LANGUE=" + langue + (typeToolbox.endsWith("PAGE_TETE") ? ",TYPE=" + typeObjet : "")))));
        }
        this.getServletContext().getRequestDispatcher(reponse).forward((ServletRequest)req, (ServletResponse)res);
    }

    private boolean isChoixRubriqueForcage(FicheUniv fiche, String typeToolbox) {
        Vector<String> rubriquesPublication = null;
        try {
            rubriquesPublication = Rubriquepublication.getListeRubriquesPublication(ContexteUtil.getContexteUniv(), fiche);
        }
        catch (Exception e) {
            LOG.error("impossible de r\u00e9cuperer les rubriques de publication de la fiche", (Throwable)e);
        }
        return CollectionUtils.isNotEmpty(rubriquesPublication) && !"LIEN_INTERNE_PAGE_TETE".equals(typeToolbox) && !"LIEN_INTERNE_JOINTURE".equals(typeToolbox);
    }
}

