/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.servlet;

import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.Metatag;
import com.univ.url.UrlManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoirFicheEnLigneServlet
extends HttpServlet {
    private static final long serialVersionUID = -6232012835398251982L;
    private static final String PARAM_OBJET = "OBJET";
    private static final String PARAM_ID_FICHE = "ID_FICHE";
    private static final Logger LOG = LoggerFactory.getLogger(VoirFicheEnLigneServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String idFiche = req.getParameter(PARAM_ID_FICHE);
        String codeObjet = req.getParameter(PARAM_OBJET);
        if (StringUtils.isNotBlank((CharSequence)idFiche) && StringUtils.isNumeric((CharSequence)idFiche) && StringUtils.isNotBlank((CharSequence)codeObjet)) {
            Metatag metaCourant = new Metatag();
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            metaCourant.setCtx(ctx);
            try {
                metaCourant.select(codeObjet, Long.valueOf(idFiche));
                metaCourant.nextItem();
                if (EtatFiche.EN_LIGNE.getEtat().equals(metaCourant.getMetaEtatObjet())) {
                    String url = URLResolver.getAbsoluteUrl(UrlManager.calculerUrlFiche(metaCourant), ctx);
                    resp.sendRedirect(url);
                }
            }
            catch (Exception e) {
                LOG.error("impossible de r\u00e9cup\u00e9rer l'url de la fiche d'id " + idFiche + " et de type " + codeObjet);
                throw new ServletException((Throwable)e);
            }
        }
    }
}

