/*
 * Decompiled with CFR 0.152.
 */
package com.univ.datagrid.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.datagrid.bean.CriteresDatagrid;
import com.univ.datagrid.bean.ResultatDatagrid;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.json.CodecJSon;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagridUtils {
    public static final String PARAM_INFOBEAN_URL = "URL_RECHERCHE";
    public static final String PARAM_BEAN_DATAGRID = "BEAN_RECHERCHE";
    public static final String PARAM_ID_REQUETE = "ID_REQUETE";
    public static final String BASE_URL_DATAGRID = "/servlet/com.univ.datagrid.servlet.DatagridServlet";
    public static final String RECHERCHE = "sSearch";
    public static final String DEBUT_AFFICHAGE = "iDisplayStart";
    public static final String NOMBRE_A_AFFICHER = "iDisplayLength";
    public static final String INDICE_COLONNE_A_TRIER = "iSortCol_0";
    public static final String IS_COLONNE_TRIABLE = "bSortable_";
    public static final String S_ECHO = "sEcho";
    public static final String NOM_COLONNE_A_TRIER = "mDataProp_";
    public static final String SENS_DU_TRI = "sSortDir_0";
    private static Logger LOG = LoggerFactory.getLogger(DatagridUtils.class);
    private static final int NOMBRE_MAX_RESULTAT_DEFAUT = 25000;

    public static int getNombreMaxDatagrid() {
        int nombreMaxResultat = 25000;
        String nombreMax = PropertyHelper.getCoreProperty("datagrid.nombremax");
        if (StringUtils.isNotBlank((CharSequence)nombreMax) && StringUtils.isNumeric((CharSequence)nombreMax)) {
            nombreMaxResultat = Integer.parseInt(nombreMax);
        }
        return nombreMaxResultat;
    }

    public static String mapperResultatEnJSON(List<ResultatDatagrid> resultats, int total, int totalAAfficher, CriteresDatagrid criteres) {
        String json = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
            json = CodecJSon.encodeObjectToJSonInString(resultats, format);
        }
        catch (Exception e) {
            LOG.info("impossible de s\u00e9rialiser en JSON les donn\u00e9es", (Throwable)e);
        }
        StringBuilder reponse = new StringBuilder("{\"aaData\": ").append(json);
        reponse.append(",\"iTotalRecords\" : ").append(total);
        if (criteres.getsEcho() != 0) {
            reponse.append(",\"sEcho\" : ").append(criteres.getsEcho());
        }
        reponse.append(",\"iTotalDisplayRecords\" : ").append(totalAAfficher);
        int nombreMax = DatagridUtils.getNombreMaxDatagrid();
        if (total == nombreMax) {
            Locale locale = ContexteUtil.getContexteUniv().getLocale();
            String avertissement = MessageHelper.getCoreMessage(locale, "AVERTISSEMENT_DATAGRID");
            avertissement = String.format(avertissement, nombreMax);
            reponse.append(",\"sAlerte\" : \"").append(avertissement).append("\"");
        }
        reponse.append("}");
        return reponse.toString();
    }

    public static String getUrlTraitementDatagrid(String paramDatagrid) {
        StringBuilder url = new StringBuilder(BASE_URL_DATAGRID).append("?");
        if (StringUtils.isNotEmpty((CharSequence)paramDatagrid)) {
            url.append(paramDatagrid);
            url.append("&");
        }
        url.append(PARAM_ID_REQUETE).append("=").append(UUID.randomUUID());
        return url.toString();
    }

    public static String getUrlTraitementDatagrid(InfoBean infoBean) {
        Object critereDansInfoBean = infoBean.get("CRITERE_REQUETE");
        String requeteDansInfoBean = infoBean.getString("REQUETE");
        StringBuilder url = new StringBuilder();
        if (critereDansInfoBean != null && critereDansInfoBean instanceof List) {
            url.append(BASE_URL_DATAGRID).append("?");
            List criteres = (List)critereDansInfoBean;
            for (CritereRecherche critere : criteres) {
                url.append(critere.getNomChamp()).append("=").append(EscapeString.escapeURL(critere.getValeurARechercher()));
                url.append("&");
            }
            url.append(PARAM_ID_REQUETE).append("=").append(UUID.randomUUID());
        } else if (StringUtils.isNotBlank((CharSequence)requeteDansInfoBean)) {
            url.append(DatagridUtils.getUrlTraitementDatagrid(requeteDansInfoBean));
        }
        return url.toString();
    }

    public static String getUrlActionFiche(String codeObjet, Long idFiche, String action) {
        String extension = ReferentielObjets.getExtension(codeObjet);
        String processus = ReferentielObjets.getProcessus(codeObjet);
        return ProcessusHelper.getUrlProcessAction(null, extension, processus, action, new String[][]{{"ID_FICHE", String.valueOf(idFiche)}});
    }

    public static String getUrlActionRubrique(String codeRubrique, String action) {
        InfoBean infoBean = new InfoBean();
        return ProcessusHelper.getUrlProcessAction(infoBean, "core", "SAISIE_RUBRIQUE", action, new String[][]{{"CODE_RUBRIQUE", codeRubrique}});
    }

    public static String getUrlActionGroupeDSI(String idGroupeDSI, String action) {
        InfoBean infoBean = new InfoBean();
        return ProcessusHelper.getUrlProcessAction(infoBean, "core", "SAISIE_GROUPEDSI", action, new String[][]{{"ID_GROUPE", idGroupeDSI}});
    }

    public static String getUrlActionLibelle(String idLibelle, String action) {
        InfoBean infoBean = new InfoBean();
        return ProcessusHelper.getUrlProcessAction(infoBean, "core", "SAISIE_LIBELLE", action, new String[][]{{"ID_LIBELLE", idLibelle}});
    }

    public static String getUrlActionSansIdFiche(String codeObjet, String action) {
        InfoBean infoBean = new InfoBean();
        String extension = ReferentielObjets.getExtension(codeObjet);
        String processus = ReferentielObjets.getProcessus(codeObjet);
        return ProcessusHelper.getUrlProcessAction(infoBean, extension, processus, action, new String[][]{new String[0]});
    }

    public static List<ResultatDatagrid> paginerResultats(List<ResultatDatagrid> resultats, CriteresDatagrid criteres) {
        ArrayList<ResultatDatagrid> resultatsARetourner = new ArrayList<ResultatDatagrid>();
        if (!resultats.isEmpty() && resultats.size() >= criteres.getDebutAffichage()) {
            for (int i = criteres.getDebutAffichage(); i < criteres.getDebutAffichage() + criteres.getNombreAAfficher() && i < resultats.size(); ++i) {
                resultatsARetourner.add(resultats.get(i));
            }
        } else {
            resultatsARetourner.addAll(resultats);
        }
        return resultatsARetourner;
    }

    public static Map<String, String> getLanguageParCodeLangue() {
        HashMap<String, String> languageLocale = new HashMap<String, String>();
        for (Locale localeCourante : LangueUtil.getLocales()) {
            String langueCourante = LangueUtil.getLangueLocale(localeCourante);
            languageLocale.put(langueCourante, localeCourante.getLanguage());
        }
        return languageLocale;
    }
}

