/*
 * Decompiled with CFR 0.152.
 */
package com.univ.identity.dao.impl;

import com.jsbsoft.jtf.datasource.dao.impl.mysql.AbstractCommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.univ.identity.bean.IdentityBean;
import com.univ.identity.om.Identity;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class IdentityDAO<I extends IdentityBean>
extends AbstractCommonDAO<I> {
    protected final ObjectMapper mapper = new ObjectMapper();

    public IdentityDAO() {
        this.tableName = "IDENTITY";
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public I add(I identityBean) throws AddToDataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement("insert into IDENTITY (CIVILITE, NOM, PRENOM, ADRESSE, CODE_POSTAL, VILLE, PAYS, TELEPHONE, EMAIL, JAVA_TYPE, DATA) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);){
                String datas = this.mapper.writeValueAsString(identityBean);
                stmt.setObject(1, (Object)((IdentityBean)identityBean).getCivilite(), 12);
                stmt.setObject(2, (Object)((IdentityBean)identityBean).getNom(), 12);
                stmt.setObject(3, (Object)((IdentityBean)identityBean).getPrenom(), 12);
                stmt.setObject(4, (Object)((IdentityBean)identityBean).getAdresse(), 12);
                stmt.setObject(5, (Object)((IdentityBean)identityBean).getCodePostal(), 12);
                stmt.setObject(6, (Object)((IdentityBean)identityBean).getVille(), 12);
                stmt.setObject(7, (Object)((IdentityBean)identityBean).getPays(), 12);
                stmt.setObject(8, (Object)((IdentityBean)identityBean).getTelephone(), 12);
                stmt.setObject(9, (Object)((IdentityBean)identityBean).getEmail(), 12);
                stmt.setObject(10, (Object)identityBean.getClass().getName(), 2004);
                stmt.setObject(11, (Object)datas, 12);
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\" : %d row(s) affected", identityBean.toString(), this.tableName, rowsAffected));
                }
                rs = stmt.getGeneratedKeys();
                rs.next();
                ((IdentityBean)identityBean).setIdIdentity(rs.getLong(1));
            }
            if (rs == null) return identityBean;
        }
        catch (Exception e) {
            try {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\"", identityBean.toString(), this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return identityBean;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e);
            return identityBean;
        }
    }

    @Override
    public I update(I identityBean) throws UpdateToDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("update IDENTITY set CIVILITE = ?, NOM = ?, PRENOM = ?, ADRESSE = ?, CODE_POSTAL = ?, VILLE = ?, PAYS = ?, TELEPHONE = ?, EMAIL = ?, JAVA_TYPE = ?, DATA = ? where ID_IDENTITY = ?");){
            String datas = this.mapper.writeValueAsString(identityBean);
            stmt.setObject(1, (Object)((IdentityBean)identityBean).getCivilite(), 12);
            stmt.setObject(2, (Object)((IdentityBean)identityBean).getNom(), 12);
            stmt.setObject(3, (Object)((IdentityBean)identityBean).getPrenom(), 12);
            stmt.setObject(4, (Object)((IdentityBean)identityBean).getAdresse(), 12);
            stmt.setObject(5, (Object)((IdentityBean)identityBean).getCodePostal(), 12);
            stmt.setObject(6, (Object)((IdentityBean)identityBean).getVille(), 12);
            stmt.setObject(7, (Object)((IdentityBean)identityBean).getPays(), 12);
            stmt.setObject(8, (Object)((IdentityBean)identityBean).getTelephone(), 12);
            stmt.setObject(9, (Object)((IdentityBean)identityBean).getEmail(), 12);
            stmt.setObject(10, (Object)identityBean.getClass().getName(), 2004);
            stmt.setObject(11, (Object)datas, 12);
            stmt.setObject(12, (Object)((IdentityBean)identityBean).getIdIdentity(), -5);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"%s\"", identityBean.toString(), this.tableName), e);
        }
        return identityBean;
    }

    @Override
    protected I fill(ResultSet rs) throws DataSourceException {
        IdentityBean identityBean;
        try {
            Class<?> className = Class.forName(rs.getString("JAVA_TYPE"));
            identityBean = (IdentityBean)this.mapper.readValue(rs.getString("DATA"), className);
            identityBean.setIdIdentity(rs.getLong("ID_IDENTITY"));
            identityBean.setCivilite(rs.getString("CIVILITE"));
            identityBean.setNom(rs.getString("NOM"));
            identityBean.setPrenom(rs.getString("PRENOM"));
            identityBean.setAdresse(rs.getString("ADRESSE"));
            identityBean.setCodePostal(rs.getString("CODE_POSTAL"));
            identityBean.setVille(rs.getString("VILLE"));
            identityBean.setPays(rs.getString("PAYS"));
            identityBean.setTelephone(rs.getString("TELEPHONE"));
            identityBean.setEmail(rs.getString("EMAIL"));
            identityBean.setData(rs.getString("DATA"));
        }
        catch (Exception e) {
            throw new DataSourceException("An error occured trying to map resultset to object", e);
        }
        return (I)identityBean;
    }

    public List<I> select(Identity<I> identity, String civilite, String nom, String prenom, String adresse, String codePostal, String ville, String pays, String telephone, String email, String nombre) throws DataSourceException {
        try (ContexteDao ctx = new ContexteDao();){
            RequeteSQL requeteSelect = new RequeteSQL();
            ClauseWhere where = new ClauseWhere();
            if (identity != null && identity.getIdIdentity() != null) {
                where.and(ConditionHelper.egal("ID_IDENTITY", identity.getIdIdentity(), TypeOperande.LONG));
            }
            if (StringUtils.isNotEmpty((CharSequence)civilite)) {
                where.and(ConditionHelper.egalVarchar("CIVILITE", civilite));
            }
            if (StringUtils.isNotEmpty((CharSequence)nom)) {
                where.and(ConditionHelper.egalVarchar("NOM", nom));
            }
            if (StringUtils.isNotEmpty((CharSequence)prenom)) {
                where.and(ConditionHelper.egalVarchar("PRENOM", prenom));
            }
            if (StringUtils.isNotEmpty((CharSequence)adresse)) {
                where.and(ConditionHelper.egalVarchar("ADRESSE", adresse));
            }
            if (StringUtils.isNotEmpty((CharSequence)codePostal)) {
                where.and(ConditionHelper.egalVarchar("CODE_POSTAL", codePostal));
            }
            if (StringUtils.isNotEmpty((CharSequence)ville)) {
                where.and(ConditionHelper.egalVarchar("VILLE", ville));
            }
            if (StringUtils.isNotEmpty((CharSequence)pays)) {
                where.and(ConditionHelper.egalVarchar("PAYS", pays));
            }
            if (StringUtils.isNotEmpty((CharSequence)telephone)) {
                where.and(ConditionHelper.egalVarchar("TELEPHONE", telephone));
            }
            if (StringUtils.isNotEmpty((CharSequence)email)) {
                where.and(ConditionHelper.egalVarchar("EMAIL", email));
            }
            requeteSelect.where(where);
            ClauseOrderBy orderBy = new ClauseOrderBy();
            orderBy.orderBy("T1.ID_IDENTITY", ClauseOrderBy.SensDeTri.ASC);
            requeteSelect.orderBy(orderBy);
            ClauseLimit limite = LimitHelper.ajouterCriteresLimitesEtOptimisation(ctx, nombre);
            requeteSelect.limit(limite);
            List list = this.select(requeteSelect.formaterRequete());
            return list;
        }
    }
}

