/*
 * Decompiled with CFR 0.152.
 */
package com.univ.identity.om;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.dao.CommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DeleteFromDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.jsbsoft.jtf.datasource.manager.DataSourceDAOManager;
import com.univ.identity.bean.IdentityBean;
import com.univ.identity.dao.impl.IdentityDAO;
import com.univ.utils.RequeteUtil;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Identity<I extends IdentityBean> {
    protected I identity;
    protected IdentityDAO<I> identityDao;
    protected List<I> currentSelect;
    protected Iterator<I> currentSelectIt;

    public Identity() {
        DataSourceDAOManager manager = (DataSourceDAOManager)ApplicationContextManager.getCoreContextBean("daoManager");
        CommonDAO<I> dummy = manager.getDao(this.getGenericType());
        this.identityDao = (IdentityDAO)dummy;
        try {
            this.identity = (IdentityBean)this.getGenericType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private Class<I> getGenericType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public void init() {
        this.setCivilite("");
        this.setNom("");
        this.setPrenom("");
        this.setAdresse("");
        this.setCodePostal("");
        this.setVille("");
        this.setPays("");
        this.setTelephone("");
        this.setEmail("");
        this.setData("");
    }

    @JsonIgnore
    public String getLibelleAffichable() {
        return "Identity " + this.getIdIdentity();
    }

    @JsonIgnore
    public String getFullTextString() throws Exception {
        String s = this.getCivilite() + " " + this.getNom() + " " + this.getPrenom() + " " + this.getAdresse() + " " + this.getCodePostal() + " " + this.getVille() + " " + this.getPays() + " " + this.getTelephone() + " " + this.getEmail() + " " + this.getData();
        return s;
    }

    public int traiterRequete(String requete) throws Exception {
        String civilite = RequeteUtil.renvoyerParametre(requete, "CIVILITE");
        String nom = RequeteUtil.renvoyerParametre(requete, "NOM");
        String prenom = RequeteUtil.renvoyerParametre(requete, "PRENOM");
        String adresse = RequeteUtil.renvoyerParametre(requete, "ADRESSE");
        String codePostal = RequeteUtil.renvoyerParametre(requete, "CODE_POSTAL");
        String ville = RequeteUtil.renvoyerParametre(requete, "VILLE");
        String pays = RequeteUtil.renvoyerParametre(requete, "PAYS");
        String telephone = RequeteUtil.renvoyerParametre(requete, "TELEPHONE");
        String email = RequeteUtil.renvoyerParametre(requete, "EMAIL");
        String nombre = RequeteUtil.renvoyerParametre(requete, "NOMBRE");
        return this.select(civilite, nom, prenom, adresse, codePostal, ville, pays, telephone, email, nombre);
    }

    public int select(String civilite, String nom, String prenom, String adresse, String codePostal, String ville, String pays, String telephone, String email, String nombre) throws Exception {
        this.currentSelect = this.identityDao.select(this, civilite, nom, prenom, adresse, codePostal, ville, pays, telephone, email, nombre);
        this.currentSelectIt = this.currentSelect.iterator();
        return this.currentSelect.size();
    }

    public void retrieve() throws DataSourceException {
        this.identity = (IdentityBean)this.identityDao.getById(((IdentityBean)this.identity).getIdIdentity());
    }

    public void add() throws AddToDataSourceException {
        this.identityDao.add(this.identity);
    }

    public void delete() throws DeleteFromDataSourceException {
        this.identityDao.delete(((IdentityBean)this.identity).getIdIdentity());
    }

    public void update() throws UpdateToDataSourceException {
        this.identityDao.update(this.identity);
    }

    public Long getIdIdentity() {
        return ((IdentityBean)this.identity).getIdIdentity();
    }

    public void setIdIdentity(Long idParticipation) {
        ((IdentityBean)this.identity).setIdIdentity(idParticipation);
    }

    public String getCivilite() {
        return ((IdentityBean)this.identity).getCivilite();
    }

    public void setCivilite(String civilite) {
        ((IdentityBean)this.identity).setCivilite(civilite);
    }

    public String getNom() {
        return ((IdentityBean)this.identity).getNom();
    }

    public void setNom(String nom) {
        ((IdentityBean)this.identity).setNom(nom);
    }

    public String getPrenom() {
        return ((IdentityBean)this.identity).getPrenom();
    }

    public void setPrenom(String prenom) {
        ((IdentityBean)this.identity).setPrenom(prenom);
    }

    public String getAdresse() {
        return ((IdentityBean)this.identity).getAdresse();
    }

    public void setAdresse(String adresse) {
        ((IdentityBean)this.identity).setAdresse(adresse);
    }

    public String getCodePostal() {
        return ((IdentityBean)this.identity).getCodePostal();
    }

    public void setCodePostal(String codePostal) {
        ((IdentityBean)this.identity).setCodePostal(codePostal);
    }

    public String getVille() {
        return ((IdentityBean)this.identity).getVille();
    }

    public void setVille(String ville) {
        ((IdentityBean)this.identity).setVille(ville);
    }

    public String getPays() {
        return ((IdentityBean)this.identity).getPays();
    }

    public void setPays(String pays) {
        ((IdentityBean)this.identity).setPays(pays);
    }

    public String getTelephone() {
        return ((IdentityBean)this.identity).getTelephone();
    }

    public void setTelephone(String telephone) {
        ((IdentityBean)this.identity).setTelephone(telephone);
    }

    public String getEmail() {
        return ((IdentityBean)this.identity).getEmail();
    }

    public void setEmail(String email) {
        ((IdentityBean)this.identity).setEmail(email);
    }

    public String getData() {
        return ((IdentityBean)this.identity).getData();
    }

    public void setData(String data) {
        ((IdentityBean)this.identity).setData(data);
    }

    public String getJspComplementFragment() {
        return ((IdentityBean)this.identity).getJspComplementFragment();
    }

    public void setJspComplementFragment(String complementFragment) {
        ((IdentityBean)this.identity).setJspComplementFragment(complementFragment);
    }
}

