/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.cache.AbstractCacheManager;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteDao;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheMediaManager
extends AbstractCacheManager {
    public static final String ID_BEAN = "cacheMediaManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheMediaManager.class);
    public static final String KEY_CACHE = "CacheMediaManager.cacheRubriqueBySource";

    public static CacheMediaManager getInstance() {
        return (CacheMediaManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    private HashMap<String, String> getRubriqueBySource() throws Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        try (ContexteDao ctx = new ContexteDao();){
            Media media = new Media();
            media.init();
            media.setCtx(ctx);
            media.select("WHERE CODE_RUBRIQUE!=''");
            while (media.nextItem()) {
                if (!media.isLocal()) continue;
                res.put(media.getUrl(), media.getCodeRubrique());
            }
        }
        catch (Exception e) {
            throw new Exception("Erreur de chargement des m\u00e9dias rubriqu\u00e9s", e);
        }
        LOGGER.info("Chargement de " + res.size() + " m\u00e9dias rubriqu\u00e9s OK");
        return res;
    }

    public String getCodeRubrique(String sUrl) {
        Object object = this.call();
        if (object != null) {
            return (String)((HashMap)object).get(sUrl);
        }
        return null;
    }

    public void refresh(Media media, boolean async) {
        String old;
        String string = old = media != null ? this.getCodeRubrique(media.getUrl()) : null;
        if (media == null || (StringUtils.isNotEmpty((CharSequence)old) || StringUtils.isNotEmpty((CharSequence)media.getCodeRubrique())) && !media.getCodeRubrique().equals(old)) {
            if (async) {
                CacheMediaManager.getInstance().asyncRefresh();
            } else {
                CacheMediaManager.getInstance().refresh();
            }
        }
    }

    @Override
    public Object getObjectToCache() throws Exception {
        return this.getRubriqueBySource();
    }

    @Override
    public String getCacheName() {
        return KEY_CACHE;
    }

    @Override
    public Object getObjectKey() {
        return KEY_CACHE;
    }
}

