/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kdecole.cache.aspect.TempCacheGet;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.module.AbstractBeanManager;
import com.univ.mediatheque.CacheMediaManager;
import com.univ.mediatheque.SpecificUrl;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.utils.ContexteUniv;
import com.univ.utils.DateUtil;
import com.univ.utils.FileUtil;
import com.univ.utils.RequeteUtil;
import com.univ.utils.media.CodeTypeRessourceCodeTypeMedia;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.condition.ConditionList;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.LimitHelper;
import com.univ.utils.sql.operande.TypeOperande;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mediatheque
extends AbstractBeanManager {
    public static final String ID_BEAN = "mediatheque";
    public static final String MIME_TYPES_PATH = "/adminsite/utils/mediatheque/mime.types";
    public static final String ETAT_MUTUALISE = "0";
    public static final String ETAT_NON_MUTUALISE_PUBLIC = "1";
    public static final String ETAT_NON_MUTUALISE_NON_PUBLIC = "2";
    private static final Logger LOGGER = LoggerFactory.getLogger(Mediatheque.class);
    private Properties mimeTypes;
    public HashMap<String, String> styles;
    public HashMap<String, SpecificMedia> typesMedia;
    public Hashtable<String, String> typesRessourcesByExtensions;
    public HashMap<String, SpecificUrl> typesUrl;
    public String uploadPath = "";
    public String mimeTypesPath = "";
    public CacheMediaManager cacheMediaManager;

    public HashMap<String, SpecificMedia> getTypesMedia() {
        return this.typesMedia;
    }

    public void setTypesMedia(HashMap<String, SpecificMedia> types) {
        this.typesMedia = types;
    }

    public SpecificMedia getRessource(String type) {
        return this.typesMedia.get(type);
    }

    public SpecificMedia getRessourceByExtension(String extension) {
        if (this.typesRessourcesByExtensions.get(extension) != null) {
            return this.getRessource(this.typesRessourcesByExtensions.get(extension));
        }
        return this.getRessource("fichier");
    }

    @TempCacheGet(key="Mediatheque.getMediasByParam", contextual=false)
    public ArrayList<Media> getMediasByParam(String param, ContexteUniv _ctx) throws Exception {
        RequeteSQL requeteSelect = new RequeteSQL();
        ClauseWhere where = new ClauseWhere();
        ClauseOrderBy orderBy = null;
        ClauseLimit limite = new ClauseLimit(0);
        param = StringUtils.replace((String)param, (String)"%20", (String)" ");
        String typeMedia = RequeteUtil.renvoyerParametre(param, "TYPE_MEDIA");
        String libelle = RequeteUtil.renvoyerParametre(param, "TITRE");
        String legende = RequeteUtil.renvoyerParametre(param, "LEGENDE");
        String codeRedacteur = RequeteUtil.renvoyerParametre(param, "CODE_REDACTEUR");
        String codeRubrique = RequeteUtil.renvoyerParametre(param, "CODE_RUBRIQUE");
        String sDateDebut = RequeteUtil.renvoyerParametre(param, "DATE_DEBUT");
        String sDateFin = RequeteUtil.renvoyerParametre(param, "DATE_FIN");
        String codeStructure = RequeteUtil.renvoyerParametre(param, "CODE_RATTACHEMENT");
        String thematique = RequeteUtil.renvoyerParametre(param, "THEMATIQUE");
        String nbJours = RequeteUtil.renvoyerParametre(param, "JOUR");
        String selection = RequeteUtil.renvoyerParametre(param, "SELECTION");
        String tri = RequeteUtil.renvoyerParametre(param, "TRI_DATE");
        String nombre = RequeteUtil.renvoyerParametre(param, "NOMBRE");
        Date dateDebut = null;
        Date dateFin = null;
        if (selection.length() > 0) {
            Date today = new Date(System.currentTimeMillis());
            if (selection.equals("0005")) {
                dateDebut = DateUtil.getFirstDayOfWeek(today);
                dateFin = DateUtil.getLastDayOfWeek(today);
            } else if (selection.equals("0006")) {
                dateDebut = DateUtil.getFirstDayOfMonth(today);
                dateFin = DateUtil.getLastDayOfMonth(today);
            } else if (selection.equals("0007")) {
                orderBy = new ClauseOrderBy("DATE_CREATION", ClauseOrderBy.SensDeTri.DESC);
            }
        } else if (nbJours.length() > 0) {
            dateDebut = DateUtil.addDays(new Date(System.currentTimeMillis()), -Integer.parseInt(nbJours));
            dateFin = new Date(System.currentTimeMillis());
        } else {
            dateDebut = DateUtil.parseDate(sDateDebut);
            dateFin = DateUtil.parseDate(sDateFin);
        }
        if (orderBy == null) {
            orderBy = new ClauseOrderBy();
            if (tri.equals("DATE_ASC")) {
                orderBy = orderBy.orderBy("T1.DATE_CREATION", ClauseOrderBy.SensDeTri.ASC);
            } else if (tri.equals("DATE_DESC")) {
                orderBy = orderBy.orderBy("T1.DATE_CREATION", ClauseOrderBy.SensDeTri.DESC);
            }
        }
        where.setPremiereCondition(ConditionHelper.egal("IS_MUTUALISE", 0, TypeOperande.INTEGER));
        if (StringUtils.isNotEmpty((CharSequence)typeMedia)) {
            where.and(this.getConditionSurTypes(typeMedia));
        }
        if (StringUtils.isNotEmpty((CharSequence)libelle)) {
            where.and(ConditionHelper.rechercheMots("TITRE", libelle));
        }
        if (StringUtils.isNotEmpty((CharSequence)legende)) {
            where.and(ConditionHelper.rechercheMots("LEGENDE", legende));
        }
        if (StringUtils.isNotEmpty((CharSequence)thematique)) {
            where.and(ConditionHelper.egalVarchar("THEMATIQUE", thematique));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRedacteur)) {
            if (codeRedacteur.equals("DYNAMIK")) {
                codeRedacteur = _ctx.getCode();
            }
            where.and(ConditionHelper.egalVarchar("CODE_REDACTEUR", codeRedacteur));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeStructure)) {
            where.and(ConditionHelper.getConditionStructure("CODE_RATTACHEMENT", codeStructure));
        }
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            if (codeRubrique.startsWith("DYNAMIK")) {
                codeRubrique = codeRubrique.replaceAll("DYNAMIK", _ctx.getCodeRubriquePageCourante());
            }
            where.and(ConditionHelper.getConditionRubrique("CODE_RUBRIQUE", codeRubrique));
        }
        if (Formateur.estSaisie(dateDebut)) {
            where.and(ConditionHelper.greaterEquals("DATE_CREATION", dateDebut, TypeOperande.DATE));
        }
        if (Formateur.estSaisie(dateFin)) {
            where.and(ConditionHelper.critereDateFin("DATE_CREATION", dateFin));
        }
        where.and(Media.conditionPerimetreMedia(_ctx, "SELECTION"));
        orderBy.orderBy("T1.TITRE", ClauseOrderBy.SensDeTri.ASC);
        limite = LimitHelper.ajouterCriteresLimitesEtOptimisation(_ctx, nombre);
        requeteSelect.where(where).orderBy(orderBy).limit(limite);
        ArrayList<Media> medias = new ArrayList<Media>();
        Media media = new Media();
        media.setCtx(_ctx);
        if (media.select(requeteSelect.formaterRequete()) > 0) {
            while (media.nextItem()) {
                Media mediaAAjouter = media.clone();
                mediaAAjouter.setCtx(null);
                medias.add(mediaAAjouter);
            }
        }
        return medias;
    }

    private Condition getConditionSurTypes(String typeMedia) {
        String[] typesRessourcesTypesMedias = StringUtils.split((String)typeMedia, (String)",");
        ConditionList conditionsSurTypes = new ConditionList();
        for (String typesRessourcesTypesMedia : typesRessourcesTypesMedias) {
            CodeTypeRessourceCodeTypeMedia codeTypeRessourceCodeTypeMedia = CodeTypeRessourceCodeTypeMedia.fromString(typesRessourcesTypesMedia);
            if (!StringUtils.isNotBlank((CharSequence)codeTypeRessourceCodeTypeMedia.getCodeTypeRessource())) continue;
            List<String> codesTypeRessources = Arrays.asList(codeTypeRessourceCodeTypeMedia.getCodeTypeRessource().split("\\+"));
            ConditionList conditionTypeRessourceMedia = new ConditionList(ConditionHelper.in("TYPE_RESSOURCE", codesTypeRessources));
            String codeTypeMedia = codeTypeRessourceCodeTypeMedia.getCodeTypeMedia();
            if (StringUtils.isNotBlank((CharSequence)codeTypeMedia)) {
                List<String> codesTypeMedia = Arrays.asList(codeTypeRessourceCodeTypeMedia.getCodeTypeMedia().split("\\+"));
                conditionTypeRessourceMedia.and(ConditionHelper.in("TYPE_MEDIA", codesTypeMedia));
            }
            conditionsSurTypes.or(conditionTypeRessourceMedia);
        }
        return conditionsSurTypes;
    }

    public void uploadMediasByFolder(OMContext ctx, InfoBean infoBean, File folder, boolean searchDeep, String codeRedacteur) throws Exception {
        boolean autoUpload = infoBean.getString("AUTO_UPLOAD") != null;
        String typeRessource = "";
        if (infoBean.getString("TYPE_RESSOURCE") != null) {
            typeRessource = infoBean.getString("TYPE_RESSOURCE");
        }
        int nbUpload = 0;
        if (infoBean.get("NB_UPLOAD") != null) {
            nbUpload = infoBean.getInt("NB_UPLOAD");
        }
        int nbError = 0;
        if (infoBean.get("NB_ERROR") != null) {
            nbError = infoBean.getInt("NB_ERROR");
        }
        String message = "";
        if (infoBean.getString("MSG_ERROR") != null) {
            message = infoBean.getString("MSG_ERROR");
        }
        SpecificMedia specificMedia = null;
        File[] list = folder.listFiles();
        if (list != null) {
            for (File f : list) {
                specificMedia = null;
                if (f.isDirectory() && searchDeep) {
                    infoBean.set("NB_UPLOAD", nbUpload);
                    infoBean.set("NB_ERROR", nbError);
                    infoBean.set("MSG_ERROR", message);
                    this.uploadMediasByFolder(ctx, infoBean, f, true, codeRedacteur);
                    nbUpload = infoBean.getInt("NB_UPLOAD");
                    nbError = infoBean.getInt("NB_ERROR");
                    message = infoBean.getString("MSG_ERROR");
                    continue;
                }
                if (!searchDeep && f != null && f.exists() && System.currentTimeMillis() - f.lastModified() < 120000L) {
                    LOGGER.warn(f.getName() + " [le fichier a \u00e9t\u00e9 ignor\u00e9 car il est en cours de modification]");
                    if (message.length() > 0) {
                        message = message + (autoUpload ? "\n" : "<br />");
                    }
                    message = message + "WARNING - " + f.getName() + " [le fichier a \u00e9t\u00e9 ignor\u00e9 car il est en cours de modification]";
                    continue;
                }
                if (autoUpload && f.getName().equals("autoupload.properties") || (specificMedia = this.getRessourceByExtension(FileUtil.getExtension(f.getName()))) == null) continue;
                if (typeRessource.length() > 0 && !typeRessource.equalsIgnoreCase(specificMedia.getCode())) {
                    ++nbError;
                    if (message.length() > 0) {
                        message = message + (autoUpload ? "\nINFO - " : "<br />");
                    }
                    message = message + "IGNORE : " + f.getName();
                    continue;
                }
                try {
                    UploadedFile file = new UploadedFile(null, 0, f.getName(), f);
                    specificMedia.checkMedia(infoBean, file);
                    Media media = new Media();
                    media.setCtx(ctx);
                    media.init();
                    media.setSource(f.getName());
                    media.setDateCreation(new Date(System.currentTimeMillis()));
                    media.setCodeRedacteur(codeRedacteur);
                    try {
                        media.setPoids(new Integer(infoBean.getString("POIDS")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    media.setIsMutualise(ETAT_MUTUALISE);
                    media.setTypeRessource(specificMedia.getCode());
                    String title = f.getName();
                    int iDot = title.lastIndexOf(".");
                    if (iDot != -1) {
                        title = title.substring(0, iDot);
                    }
                    if (infoBean.getString("TITRE") != null) {
                        media.setTitre(infoBean.getString("TITRE").replaceAll("\\[file\\]", title));
                    } else {
                        media.setTitre(title);
                    }
                    if (infoBean.getString("LEGENDE") != null) {
                        media.setLegende(infoBean.getString("LEGENDE").replaceAll("\\[file\\]", title));
                    }
                    if (infoBean.getString("DESCRIPTION") != null) {
                        media.setDescription(infoBean.getString("DESCRIPTION").replaceAll("\\[file\\]", title));
                    }
                    if (infoBean.getString("FORMAT") != null) {
                        media.setFormat(infoBean.getString("FORMAT"));
                    }
                    if (infoBean.getString("AUTEUR") != null) {
                        media.setAuteur(infoBean.getString("AUTEUR"));
                    }
                    if (infoBean.getString("COPYRIGHT") != null) {
                        media.setCopyright(infoBean.getString("COPYRIGHT"));
                    }
                    if (infoBean.getString("META_KEYWORDS") != null) {
                        media.setMetaKeywords(infoBean.getString("META_KEYWORDS"));
                    }
                    if (infoBean.getString("THEMATIQUE") != null) {
                        media.setThematique(infoBean.getString("THEMATIQUE"));
                    }
                    if (infoBean.getString("CODE_RATTACHEMENT") != null) {
                        media.setCodeRattachement(infoBean.getString("CODE_RATTACHEMENT"));
                    }
                    if (infoBean.getString("CODE_RUBRIQUE") != null) {
                        media.setCodeRubrique(infoBean.getString("CODE_RUBRIQUE"));
                    }
                    infoBean.set("URL_RESSOURCE", f.getAbsolutePath());
                    String path = specificMedia.processMedia(infoBean, media);
                    String pathVignette = specificMedia.processVignette(infoBean, media);
                    media.save(ctx, path, pathVignette, media.generateName(FileUtil.getExtension(media.getSource()).toLowerCase()), "");
                    if (message.length() > 0) {
                        message = message + (autoUpload ? "\nINFO - " : "<br />");
                    }
                    message = message + "UPLOAD : " + f.getName();
                    ++nbUpload;
                }
                catch (Exception e) {
                    LOGGER.error(f.getName() + " [" + e.getMessage() + "]");
                    ++nbError;
                    if (message.length() > 0) {
                        message = message + (autoUpload ? "\n" : "<br />");
                    }
                    message = message + "ERROR - " + f.getName() + " [" + e.getMessage() + "]";
                }
            }
            infoBean.set("NB_UPLOAD", nbUpload);
            infoBean.set("NB_ERROR", nbError);
            infoBean.set("MSG_ERROR", message);
        }
    }

    public Hashtable<String, String> getTypesRessourcesAffichables() {
        Hashtable<String, String> res = new Hashtable<String, String>();
        for (SpecificMedia media : this.typesMedia.values()) {
            res.put(media.getCode(), media.getLibelleAffichable());
        }
        return res;
    }

    public HashMap<String, String> getStyles() {
        return this.styles;
    }

    public void setStyles(HashMap<String, String> styles) {
        this.styles = styles;
    }

    public HashMap<String, SpecificUrl> getTypesUrl() {
        return this.typesUrl;
    }

    public void setTypesUrl(HashMap<String, SpecificUrl> typesUrl) {
        this.typesUrl = typesUrl;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public void setUploadPath(String uploadPath) {
        this.uploadPath = uploadPath;
    }

    public Hashtable<String, String> getTypesRessourcesByExtensions() {
        return this.typesRessourcesByExtensions;
    }

    public SpecificUrl getSpecificUrl(String surl) {
        URL url = null;
        String host = "";
        try {
            url = new URL(surl);
            host = url.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (host.matches("^([^\\.]+)(\\.)([^\\.]+)(\\.)([^\\.]+)$")) {
            host = host.substring(host.indexOf(".") + 1, host.lastIndexOf("."));
        } else if (host.matches("^([^\\.]+)(\\.)([^\\.]+)$")) {
            host = host.substring(0, host.lastIndexOf("."));
        }
        return this.getTypesUrl().get(host);
    }

    public String getMimeTypesPath() {
        return this.mimeTypesPath;
    }

    public void setMimeTypesPath(String mimeTypesPath) {
        this.mimeTypesPath = mimeTypesPath;
    }

    public String getContentType(String extension) {
        if (extension.indexOf(".") != -1) {
            extension = FileUtil.getExtension(extension);
        }
        if (this.mimeTypes.get(extension = extension.toLowerCase()) != null) {
            return (String)this.mimeTypes.get(extension);
        }
        return "application/octet-stream";
    }

    public static Mediatheque getInstance() {
        return (Mediatheque)ApplicationContextManager.getCoreContextBean(ID_BEAN);
    }

    public Object getPlayList(String key) {
        return ApplicationContextManager.getCoreContextBean(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        this.typesMedia = new HashMap();
        Collection<SpecificMedia> specificMedias = this.moduleManager.getModules(SpecificMedia.class);
        for (SpecificMedia module : specificMedias) {
            this.typesMedia.put(module.getCode(), module);
        }
        Iterator<String> it = this.typesMedia.keySet().iterator();
        String sKeyType = "";
        Hashtable<String, String> hTypeRessourceByExtension = new Hashtable<String, String>();
        while (it.hasNext()) {
            sKeyType = it.next();
            SpecificMedia specificMedia = this.typesMedia.get(sKeyType);
            for (String extension : specificMedia.getExtensions()) {
                hTypeRessourceByExtension.put(extension, sKeyType);
            }
        }
        this.typesRessourcesByExtensions = hTypeRessourceByExtension;
        this.mimeTypes = new Properties();
        if (this.mimeTypesPath.length() == 0) {
            this.setMimeTypesPath(MIME_TYPES_PATH);
        }
        InputStream in = null;
        try {
            in = new FileInputStream(new File(WebAppUtil.getAbsolutePath() + this.mimeTypesPath));
            this.mimeTypes.load(in);
        }
        catch (Exception e) {
            LOGGER.error("Erreur de chargement du fichier mime.types");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.cacheMediaManager.refresh(null, false);
    }

    public CacheMediaManager getCacheMediaManager() {
        return this.cacheMediaManager;
    }

    public void setCacheMediaManager(CacheMediaManager cacheMediaManager) {
        this.cacheMediaManager = cacheMediaManager;
    }
}

