/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.galerie;

import com.univ.mediatheque.galerie.Galerie;
import com.univ.mediatheque.galerie.GalerieType;
import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.player.visionneuse.VisionneusePlayer;
import com.univ.mediatheque.playlist.MediaPlaylist;
import com.univ.mediatheque.playlist.visionneuse.VisionneusePlaylist;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GalerieDefaut
implements Galerie {
    protected static GalerieType TYPE = GalerieType.STANDARD;
    protected static String HTML_CSS_VISIONNEUSE = "galerie_defaut";
    protected static String HTML_CSS_PLAYER = "galerie_player";
    protected static String HTML_CSS_PLAYLIST = "galerie_playlist ";
    protected static String HTML_CSS_TITRE = "galerie_titre";
    private String name;
    private String titre;
    private VisionneusePlaylist visionneusePlaylist;

    public String getTitre() {
        return this.titre;
    }

    @Override
    public void afficherGalerieComplete(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception {
        mediaList.setCtx(ctx);
        mediaList.init();
        out.write("<div class=\"");
        out.write(HTML_CSS_VISIONNEUSE);
        out.write("\">");
        if (StringUtils.isNotEmpty((CharSequence)this.getTitre())) {
            out.write("<p class=\"");
            out.write(HTML_CSS_TITRE);
            out.write("\">");
            out.write(this.getTitre());
            out.write("</p>");
        }
        this.initialiserPlayer(ctx, out, mediaList);
        this.initialiserPlaylist(ctx, out, mediaList);
        out.write("</div>");
    }

    @Override
    public void initialiserPlayer(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception {
        StringWriter strWriter = new StringWriter();
        List<Media> medias = mediaList.getMediaList();
        int maxHeight = -1;
        int maxWidth = -1;
        if (medias != null && medias.size() > 0) {
            for (Media media : medias) {
                VisionneusePlayer vPlayer = mediaList.getVisionneusePlayer(media);
                MediaStyle mStyle = mediaList.getMediaStyle(media);
                MediaPlayer mPlayer = mediaList.getMediaPlayer(media);
                vPlayer.initialiserVisionneuse(ctx, strWriter, mPlayer);
                vPlayer.setLanceurMedia(ctx, media, mPlayer, mStyle);
                maxHeight = Math.max(maxHeight, vPlayer.getMaxHeight());
                maxWidth = Math.max(maxWidth, vPlayer.getMaxWidth());
            }
        }
        out.write("<div class=\"");
        out.write(HTML_CSS_PLAYER);
        if (maxHeight > -1 || maxWidth > -1) {
            out.write("\" style=\"");
            if (maxHeight > -1) {
                out.write("height:");
                out.write(String.valueOf(maxHeight));
                out.write("px;");
            }
            if (maxWidth > -1) {
                out.write("width:");
                out.write(String.valueOf(maxWidth));
                out.write("px;");
            }
        }
        out.write("\">");
        out.write(strWriter.toString());
        out.write("</div>");
    }

    @Override
    public void initialiserPlaylist(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception {
        out.write("<div class=\"");
        out.write(HTML_CSS_PLAYLIST);
        out.write(this.visionneusePlaylist.getName());
        out.write("\">");
        this.visionneusePlaylist.genererVionneusePlaylist(ctx, out, mediaList);
        out.write("</div>");
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GalerieType getType() {
        return TYPE;
    }

    @Override
    public void setTitre(String titre) {
        this.titre = titre;
    }

    @Override
    public void setVisionneusePlaylist(VisionneusePlaylist VisionneusePlaylist2) {
        this.visionneusePlaylist = VisionneusePlaylist2;
    }
}

