/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.galerie;

import com.kportal.core.config.MessageHelper;
import com.univ.mediatheque.container.ClassificationMedia;
import com.univ.mediatheque.container.ClassifieurMedia;
import com.univ.mediatheque.galerie.Galerie;
import com.univ.mediatheque.galerie.GalerieType;
import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.player.visionneuse.VisionneusePlayer;
import com.univ.mediatheque.playlist.MediaPlaylist;
import com.univ.mediatheque.playlist.visionneuse.VisionneusePlaylist;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.mediatheque.utils.HTMLUtils;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GalerieOnglet
implements Galerie {
    protected static GalerieType TYPE = GalerieType.ONGLET;
    protected static String HTML_CSS_VISIONNEUSE = "galerie_onglet";
    protected static String HTML_CSS_UL_OGLETS = "galerie_onglets";
    protected static String HTML_CSS_PLAYER = "galerie_player";
    protected static String HTML_CSS_PLAYLIST = "galerie_playlist";
    protected static String HTML_CSS_TITRE = "galerie_titre";
    protected static String HTML_CSS_ONGLET_CONTENU = "galerie_onglet_contenu";
    protected static String HTML_CSS_ONGLET_CONTENU_AUTRE_DEBUT = "galerie_onglet_contenu_";
    protected static String HTML_CSS_ONGLET_DEBUT = "galerie_onglet_";
    protected static String JS_ONGLET_MANAGER_DEBUT = "ongletManager";
    private ClassifieurMedia classifieur;
    private String name;
    private String titre;
    private VisionneusePlaylist visionneusePlaylist;

    @Override
    public void setVisionneusePlaylist(VisionneusePlaylist visionneusePlaylist) {
        this.visionneusePlaylist = visionneusePlaylist;
    }

    @Override
    public void setTitre(String titre) {
        this.titre = titre;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GalerieType getType() {
        return TYPE;
    }

    @Override
    public void afficherGalerieComplete(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception {
        mediaList.setCtx(ctx);
        mediaList.init();
        Collection<ClassificationMedia> classifications = this.classifieur.classifierMedias(mediaList.getMediaList());
        List<ClassificationMedia> ongletsActifs = this.getOngletsActifs(classifications);
        if (ongletsActifs.size() > 0) {
            out.write("<div class=\"");
            out.write(HTML_CSS_VISIONNEUSE);
            out.write("\">");
            if (StringUtils.isNotEmpty((CharSequence)this.titre)) {
                out.write("<p class=\"");
                out.write(HTML_CSS_TITRE);
                out.write("\">");
                out.write(this.titre);
                out.write("</p>");
            }
            if (ongletsActifs.size() > 1) {
                String key = String.valueOf(System.currentTimeMillis());
                out.write("<ul class=\"");
                out.write(HTML_CSS_UL_OGLETS);
                out.write("\">");
                for (int i = 0; i < ongletsActifs.size(); ++i) {
                    this.afficherOnglet(out, ongletsActifs.get(i).getCode(), ongletsActifs.get(i).getIntitule(), i, key);
                }
                out.write("</ul>");
                List<Media> medias = mediaList.getMediaList();
                int index = 0;
                for (ClassificationMedia ongletCourant : ongletsActifs) {
                    medias.clear();
                    medias.addAll(ongletCourant.getMedias());
                    out.write("<div id=\"");
                    out.write(this.genererIdContenuOnglet(ongletCourant.getCode()));
                    out.write("\" class=\"");
                    out.write(HTML_CSS_ONGLET_CONTENU);
                    out.write(" ");
                    out.write(HTML_CSS_ONGLET_CONTENU_AUTRE_DEBUT);
                    out.write(String.valueOf(index));
                    out.write("\">");
                    out.write("<h3>" + MessageHelper.getCoreMessage(ongletCourant.getIntitule()) + "</h3>");
                    this.initialiserPlayer(ctx, out, mediaList);
                    this.initialiserPlaylist(ctx, out, mediaList);
                    out.write("</div>");
                    mediaList.init();
                    ++index;
                }
                out.write(HTMLUtils.HTML_SCRIPT_JS_OPEN);
                out.write("var ");
                out.write(JS_ONGLET_MANAGER_DEBUT);
                out.write(key);
                out.write(" = ");
                out.write(HTMLUtils.OBJET_JS_ONGLET_MANAGER);
                out.write(";\n");
                for (int i = 0; i < ongletsActifs.size(); ++i) {
                    out.write(HTMLUtils.genererMediathequeLanceurJSAdd(JS_ONGLET_MANAGER_DEBUT + key + ".addNewView('" + this.genererIdVueOnglet(ongletsActifs.get(i).getCode()) + "','" + this.genererIdContenuOnglet(ongletsActifs.get(i).getCode()) + "','" + this.genererIdOnglet(ongletsActifs.get(i).getCode()) + "')", 2));
                }
                out.write(HTMLUtils.genererMediathequeLanceurJSAdd(JS_ONGLET_MANAGER_DEBUT + key + ".initView('" + this.genererIdVueOnglet(ongletsActifs.get(0).getCode()) + "')", 999));
                out.write(HTMLUtils.HTML_SCRIPT_JS_CLOSE);
            } else if (ongletsActifs.size() == 1) {
                this.initialiserPlayer(ctx, out, mediaList);
                this.initialiserPlaylist(ctx, out, mediaList);
            }
            out.write("</div>");
        }
    }

    @Override
    public void initialiserPlayer(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception {
        StringWriter strWriter = new StringWriter();
        List<Media> medias = mediaList.getMediaList();
        int maxHeight = -1;
        int maxWidth = -1;
        if (medias != null && medias.size() > 0) {
            for (Media media : medias) {
                VisionneusePlayer vPlayer = mediaList.getVisionneusePlayer(media);
                MediaStyle mStyle = mediaList.getMediaStyle(media);
                MediaPlayer mPlayer = mediaList.getMediaPlayer(media);
                vPlayer.initialiserVisionneuse(ctx, strWriter, mPlayer);
                vPlayer.setLanceurMedia(ctx, media, mPlayer, mStyle);
                maxHeight = Math.max(maxHeight, vPlayer.getMaxHeight());
                maxWidth = Math.max(maxWidth, vPlayer.getMaxWidth());
            }
        }
        out.write("<div class=\"");
        out.write(HTML_CSS_PLAYER);
        if (maxHeight > -1 || maxWidth > -1) {
            out.write("\" style=\"");
            if (maxHeight > -1) {
                out.write("height:");
                out.write(String.valueOf(maxHeight));
                out.write("px;");
            }
            if (maxWidth > -1) {
                out.write("width:");
                out.write(String.valueOf(maxWidth));
                out.write("px;");
            }
        }
        out.write("\">");
        out.write(strWriter.toString());
        out.write("</div>");
    }

    @Override
    public void initialiserPlaylist(ContexteUniv ctx, Writer out, MediaPlaylist mediaList) throws Exception {
        out.write("<div class=\"");
        out.write(HTML_CSS_PLAYLIST);
        out.write("\">");
        this.visionneusePlaylist.genererVionneusePlaylist(ctx, out, mediaList);
        out.write("</div>");
    }

    private List<ClassificationMedia> getOngletsActifs(Collection<ClassificationMedia> classifications) {
        ArrayList<ClassificationMedia> classificationsReturn = new ArrayList<ClassificationMedia>();
        for (ClassificationMedia classification : classifications) {
            if (classification.isEmpty()) continue;
            classificationsReturn.add(classification);
        }
        return classificationsReturn;
    }

    private void afficherOnglet(Writer out, String code, String intitule, int index, String key) throws IOException {
        out.write("<li data-tabid=\"");
        out.write(this.genererIdContenuOnglet(code));
        out.write("\" class=\"");
        out.write(HTML_CSS_ONGLET_DEBUT);
        out.write(String.valueOf(index));
        out.write("\">");
        out.write(MessageHelper.getCoreMessage(intitule));
        out.write("</li>");
    }

    private String genererIdVueOnglet(String codeOnglet) {
        return "vue_" + codeOnglet;
    }

    private String genererIdContenuOnglet(String codeOnglet) {
        return "galerie_onglet_contenu_" + codeOnglet;
    }

    private String genererIdOnglet(String codeOnglet) {
        return "galerie_onglet_" + codeOnglet;
    }

    public ClassifieurMedia getClassifieur() {
        return this.classifieur;
    }

    public void setClassifieur(ClassifieurMedia classifieur) {
        this.classifieur = classifieur;
    }
}

