/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.player;

import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.style.PlayerStyle;
import com.univ.mediatheque.utils.HTMLUtils;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMediaPlayer
implements MediaPlayer {
    protected static String FONCTION_JS_START = "set";
    private final Logger LOG = LoggerFactory.getLogger(AbstractMediaPlayer.class);
    protected PlayerStyle style;

    public void setStyle(PlayerStyle style) {
        this.style = style;
    }

    @Override
    public PlayerStyle getStyle() {
        return this.style;
    }

    protected String getInitJSPlayerStyle(String playerJSObject) {
        StringBuilder returnStr = new StringBuilder();
        Collection<String> proprietesPlayer = this.style.getListeNomsProprieteInitialisation();
        if (proprietesPlayer != null) {
            for (String nomPropriete : proprietesPlayer) {
                String valeurPropiete = this.style.getValeurProprieteInitialisation(nomPropriete);
                if (!this.getType().isAutorisee(nomPropriete) || valeurPropiete == null || valeurPropiete.length() <= 0) continue;
                StringBuilder fonctionJS = new StringBuilder();
                fonctionJS.append(FONCTION_JS_START);
                fonctionJS.append(nomPropriete.substring(0, 1).toUpperCase());
                fonctionJS.append(nomPropriete.substring(1).toLowerCase());
                returnStr.append(HTMLUtils.genererMediathequeLanceurJSAdd(playerJSObject + "." + fonctionJS + "('" + StringEscapeUtils.escapeEcmaScript((String)valeurPropiete) + "')", 5));
            }
        }
        return returnStr.toString();
    }

    protected String genererDefaultURLplayerDistant(ContexteUniv ctx, Media media) {
        try {
            StringBuilder urlHTTP = new StringBuilder();
            String urlPlayerDistantSpecific = this.style.getSpecificUrlPlayerDistant();
            if (StringUtils.isEmpty((CharSequence)urlPlayerDistantSpecific)) {
                urlHTTP.append(this.getType().getUrlDistante());
            } else {
                urlHTTP.append(urlPlayerDistantSpecific);
            }
            urlHTTP.append("?URL_MEDIA=");
            urlHTTP.append(URLResolver.getAbsoluteUrl(media.getUrlAbsolue(), ctx));
            Collection<String> proprietesPlayer = this.style.getListeNomsProprieteInitialisation();
            if (proprietesPlayer != null) {
                for (String nomPropriete : proprietesPlayer) {
                    String valeurPropiete = this.style.getValeurProprieteInitialisation(nomPropriete);
                    if (!this.getType().isAutorisee(nomPropriete) || valeurPropiete == null || valeurPropiete.length() <= 0) continue;
                    urlHTTP.append("&amp");
                    urlHTTP.append(nomPropriete);
                    urlHTTP.append("=");
                    urlHTTP.append(URLEncoder.encode(valeurPropiete, "UTF-8"));
                }
            }
            int width = this.getWidth();
            if (urlHTTP.length() > 0) {
                urlHTTP.append("&amp;");
            }
            urlHTTP.append("width=");
            urlHTTP.append(width);
            int height = this.getHeight();
            urlHTTP.append("&amp;height=");
            urlHTTP.append(height);
            return URLResolver.getAbsoluteUrl(urlHTTP.toString(), ctx);
        }
        catch (UnsupportedEncodingException e) {
            this.LOG.error("erreur d'encodage", (Throwable)e);
            return null;
        }
    }

    protected int getWidth() {
        int width = this.style.getWidth();
        if (width < -1) {
            width = this.getType().getWidth();
        }
        return width;
    }

    protected int getHeight() {
        int height = this.style.getHeight();
        if (height < -1) {
            height = this.getType().getHeight();
        }
        return height;
    }
}

