/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.player;

import com.kportal.core.config.PropertyHelper;

public enum MediaPlayerType {
    VIDEO_PLAYER("mediatheque.video.player.media.type", "mediatheque.video.player.height", "mediatheque.video.player.width", "mediatheque.video.player.url", "mediatheque.video.player.urlDistante", "mediatheque.video.player.proprieteAutorise"),
    AUDIO_PLAYER("mediatheque.audio.player.media.type", "mediatheque.audio.player.height", "mediatheque.audio.player.width", "mediatheque.audio.player.url", "mediatheque.audio.player.urlDistante", "mediatheque.audio.player.proprieteAutorise"),
    FICHIER_PLAYER("mediatheque.fichier.player.media.type", "", "", "", "", ""),
    FLASH_PLAYER("mediatheque.flash.player.media.type", "mediatheque.flash.player.height", "mediatheque.flash.player.width", "", "mediatheque.flash.player.urlDistante", ""),
    PHOTO_PLAYER("mediatheque.photo.player.media.type", "mediatheque.photo.player.height", "mediatheque.photo.player.width", "", "", ""),
    FLIPBOOK_PLAYER("mediatheque.flipbook.player.media.type", "mediatheque.flipbook.player.height", "mediatheque.flipbook.player.width", "", "mediatheque.flipbook.player.urlDistante", "");

    private String propertyMediaType;
    private String propertyHeight;
    private String propertyWidth;
    private String propertyUrl;
    private String propertyUrlPlayerDistant;
    private String propertyProprieteAutorisee;

    private MediaPlayerType(String propertyMediaType, String propertyHeight, String propertyWidth, String propertyUrl, String propertyUrlPlayerDistant, String propertyProprieteAutorisee) {
        this.propertyMediaType = propertyMediaType;
        this.propertyHeight = propertyHeight;
        this.propertyWidth = propertyWidth;
        this.propertyUrl = propertyUrl;
        this.propertyUrlPlayerDistant = propertyUrlPlayerDistant;
        this.propertyProprieteAutorisee = propertyProprieteAutorisee;
    }

    public String getMediaType() {
        return PropertyHelper.getCoreProperty(this.propertyMediaType);
    }

    public int getHeight() {
        String height = PropertyHelper.getCoreProperty(this.propertyHeight);
        if (height != null) {
            return Integer.parseInt(height);
        }
        return -1;
    }

    public int getWidth() {
        String width = PropertyHelper.getCoreProperty(this.propertyWidth);
        if (width != null) {
            return Integer.parseInt(width);
        }
        return -1;
    }

    public String getPlayerUrl() {
        return PropertyHelper.getCoreProperty(this.propertyUrl);
    }

    public String getUrlDistante() {
        return PropertyHelper.getCoreProperty(this.propertyUrlPlayerDistant);
    }

    public boolean isAutorisee(String propriete) {
        String stringProprietes = PropertyHelper.getCoreProperty(this.propertyProprieteAutorisee);
        if (stringProprietes != null) {
            return stringProprietes.indexOf("[" + propriete + "]") > -1;
        }
        return false;
    }
}

