/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.player;

import com.univ.mediatheque.container.AttributBaliseHTML;
import com.univ.mediatheque.container.LanceurMedia;
import com.univ.mediatheque.player.AbstractMediaPlayer;
import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.player.MediaPlayerType;
import com.univ.mediatheque.utils.HTMLUtils;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class PhotoPlayer
extends AbstractMediaPlayer
implements MediaPlayer {
    public static MediaPlayerType PLAYER_TYPE = MediaPlayerType.PHOTO_PLAYER;
    private static String HTML_NOM_CLASS_CSS_LANCEUR = "lanceur_media lanceur_media_photo";
    private static String HTML_NOM_CLASS_CSS_PLAYER = "player_photo";
    private String photoLoadingURL;

    @Override
    public String getInialiserVuePlayer(ContexteUniv ctx, String palyerId) {
        int width = super.getWidth();
        int height = super.getHeight();
        StringBuilder returnPlayer = new StringBuilder();
        returnPlayer.append("<p id=\"");
        returnPlayer.append(palyerId);
        returnPlayer.append("\" class=\"");
        returnPlayer.append(HTML_NOM_CLASS_CSS_PLAYER);
        returnPlayer.append("\"></p>\n");
        returnPlayer.append(HTMLUtils.HTML_SCRIPT_JS_OPEN);
        returnPlayer.append("var obj_");
        returnPlayer.append(palyerId);
        returnPlayer.append(" = new PhotoPlayer(\"");
        returnPlayer.append(palyerId);
        returnPlayer.append("\", ");
        returnPlayer.append(width);
        returnPlayer.append(", ");
        returnPlayer.append(height);
        returnPlayer.append(", \"");
        returnPlayer.append(this.photoLoadingURL);
        returnPlayer.append("\");\n");
        returnPlayer.append(this.getInitJSPlayerStyle("obj_" + palyerId));
        returnPlayer.append(HTMLUtils.genererMediathequeLanceurJSAdd("obj_" + palyerId + ".genererPlayer()", 100));
        returnPlayer.append(HTMLUtils.HTML_SCRIPT_JS_CLOSE);
        return returnPlayer.toString();
    }

    @Override
    public LanceurMedia getLanceurMedia(ContexteUniv ctx, Media media, String playerId) {
        LanceurMedia lanceur = new LanceurMedia(media);
        lanceur.addAttributHTML(AttributBaliseHTML.CLASS, HTML_NOM_CLASS_CSS_LANCEUR);
        lanceur.addAttributHTML(AttributBaliseHTML.ON_CLICK, "obj_" + playerId + ".lancerMedia('" + StringEscapeUtils.escapeEcmaScript((String)URLResolver.getAbsoluteUrl(media.getUrlAbsolue(), ctx)) + "', this);");
        return lanceur;
    }

    @Override
    public MediaPlayerType getType() {
        return PLAYER_TYPE;
    }

    @Override
    public String getURLPlayerDistant(ContexteUniv ctx, Media media) {
        String urlPlayerDistantSpecif = this.style.getSpecificUrlPlayerDistant();
        if (StringUtils.isNotEmpty((CharSequence)urlPlayerDistantSpecif)) {
            return this.genererDefaultURLplayerDistant(ctx, media);
        }
        return URLResolver.getAbsoluteUrl(media.getUrlAbsolue(), ctx);
    }

    public void setPhotoLoading(String photoLoadingUrl) {
        this.photoLoadingURL = photoLoadingUrl;
    }
}

