/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.player.visionneuse;

import com.univ.mediatheque.container.AttributBaliseHTML;
import com.univ.mediatheque.container.LanceurMedia;
import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.player.visionneuse.VisionneusePlayer;
import com.univ.mediatheque.player.visionneuse.VisionneusePlayerType;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.mediatheque.utils.HTMLUtils;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class VisionneuseModeTele
implements VisionneusePlayer {
    public static VisionneusePlayerType MODE = VisionneusePlayerType.TELE;
    private static String HTML_CSS_PLAYER = "visionneuse_tele_player";
    private static String HTML_CSS_PLAYER_MEDIA_DEBUT = "visionneuse_tele_player_";
    private List<String> playerAlreadyInit;
    private boolean visionneuseAlreadyInit;
    private String vionneuseKey;
    private int maxHeight = -1;
    private int maxWidth = -1;

    public VisionneuseModeTele() {
        this.init();
    }

    @Override
    public void init() {
        this.playerAlreadyInit = new ArrayList<String>();
        this.visionneuseAlreadyInit = false;
        this.vionneuseKey = String.valueOf(System.currentTimeMillis());
        this.maxHeight = -1;
        this.maxWidth = -1;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public VisionneusePlayerType getType() {
        return MODE;
    }

    @Override
    public void initialiserVisionneuse(ContexteUniv ctx, Writer out, MediaPlayer player) throws Exception {
        if (!this.playerAlreadyInit.contains(this.getVisonneuseKey(player))) {
            this.maxHeight = Math.max(this.maxHeight, player.getStyle().getHeight());
            this.maxWidth = Math.max(this.maxWidth, player.getStyle().getWidth());
            String playerId = this.getJSPlayerId(player);
            out.write("<div id=\"");
            out.write(this.getVisonneuseKey(player));
            out.write("\" class=\"");
            out.write(HTML_CSS_PLAYER);
            out.write(" ");
            out.write(HTML_CSS_PLAYER_MEDIA_DEBUT);
            out.write(player.getType().getMediaType().toLowerCase());
            out.write("\">");
            out.write(player.getInialiserVuePlayer(ctx, playerId));
            out.write("</div>");
            out.write(HTMLUtils.HTML_SCRIPT_JS_OPEN);
            if (!this.visionneuseAlreadyInit) {
                out.write("var ");
                out.write(this.getJSPlayerManagerName());
                out.write(" = new OngletManager();\n");
            }
            out.write(HTMLUtils.genererMediathequeLanceurJSAdd(this.getJSPlayerManagerName() + ".addNewView('" + this.getJSPlayerVueId(player) + "','" + this.getVisonneuseKey(player) + "','')", 1));
            if (!this.visionneuseAlreadyInit) {
                out.write(HTMLUtils.genererMediathequeLanceurJSAdd(this.getJSPlayerManagerName() + ".initView('" + this.getJSPlayerVueId(player) + "')", 500));
                this.visionneuseAlreadyInit = true;
            }
            out.write(HTMLUtils.HTML_SCRIPT_JS_CLOSE);
            this.playerAlreadyInit.add(this.getVisonneuseKey(player));
        }
    }

    @Override
    public void setLanceurMedia(ContexteUniv ctx, Media media, MediaPlayer player, MediaStyle mediaStyle) {
        String playerId = this.getJSPlayerId(player);
        LanceurMedia lanceur = player.getLanceurMedia(ctx, media, playerId);
        lanceur.addAttributHTML(AttributBaliseHTML.HREF, URLResolver.getAbsoluteUrl(media.getUrlAbsolue(), ctx));
        lanceur.addAttributHTML(AttributBaliseHTML.CLASS, "lanceur_media");
        mediaStyle.setLanceurMedia(lanceur);
    }

    private String getJSPlayerManagerName() {
        return "playerManager" + this.vionneuseKey;
    }

    private String getJSPlayerId(MediaPlayer player) {
        return "player_" + this.getVisonneuseKey(player);
    }

    private String getJSPlayerVueId(MediaPlayer player) {
        return "vue_" + this.getVisonneuseKey(player);
    }

    private String getVisonneuseKey(MediaPlayer player) {
        return (Object)((Object)player.getType()) + "_" + player.getStyle().getName() + "_" + this.vionneuseKey;
    }
}

