/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.playlist;

import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.SpecificUrl;
import com.univ.mediatheque.player.MediaPlayer;
import com.univ.mediatheque.player.visionneuse.VisionneusePlayer;
import com.univ.mediatheque.playlist.MediaPlaylist;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistDefaut
implements MediaPlaylist {
    private static Logger LOG = LoggerFactory.getLogger(PlaylistDefaut.class);
    private ContexteUniv ctx;
    private VisionneusePlayer visionneusePlayer;
    private MediaStyle mediaStyle;
    private MediaPlayer playerDefaut;
    private Map<String, MediaPlayer> players;
    private List<Media> mediaList;
    private String titre;
    private String name;

    public void setPlayers(List<MediaPlayer> players) {
        this.players = new HashMap<String, MediaPlayer>();
        for (MediaPlayer player : players) {
            LOG.debug("Ajout du player : " + (Object)((Object)player.getType()));
            this.players.put(player.getType().getMediaType(), player);
        }
    }

    @Override
    public void setMediaList(List<Media> mediaList) {
        this.mediaList = new ArrayList<Media>(mediaList);
    }

    @Override
    public List<Media> getMediaList() {
        return this.mediaList;
    }

    @Override
    public MediaPlayer getMediaPlayer(Media media) {
        String urlMedia = media.getUrlAbsolue();
        MediaPlayer player = null;
        LOG.debug("Demande de player pour le media ID : " + media.getIdMedia());
        Boolean isVideoExterneSupport = Boolean.FALSE;
        if (media.getTypeRessource().equalsIgnoreCase("video")) {
            HashMap<String, SpecificUrl> supportVideosExternes = Mediatheque.getInstance().getTypesUrl();
            for (SpecificUrl specUrl : supportVideosExternes.values()) {
                if (!urlMedia.startsWith(specUrl.getUrlSource())) continue;
                isVideoExterneSupport = Boolean.TRUE;
                player = this.players.get("flash");
                LOG.debug("Player FLASH car m\u00e9dia de type vid\u00e9o externe");
                break;
            }
        }
        if (!isVideoExterneSupport.booleanValue()) {
            player = this.players.get(media.getTypeRessource());
        }
        if (player == null) {
            LOG.info("Pas de player pour le media car il est de type '" + media.getTypeMedia() + "'");
            return this.playerDefaut;
        }
        return player;
    }

    @Override
    public MediaStyle getMediaStyle(Media media) {
        return this.mediaStyle;
    }

    public void setMediaStyle(MediaStyle mediaStyle) {
        this.mediaStyle = mediaStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitre() {
        return this.titre;
    }

    @Override
    public VisionneusePlayer getVisionneusePlayer(Media media) {
        return this.visionneusePlayer;
    }

    public void setVisionneusePlayer(VisionneusePlayer visionneusePlayer) {
        this.visionneusePlayer = visionneusePlayer;
    }

    @Override
    public void init() {
        this.visionneusePlayer.init();
        this.mediaStyle.init();
        this.mediaStyle.setCtx(this.ctx);
    }

    @Override
    public void setCtx(ContexteUniv ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setTitre(String titre) {
        this.titre = titre;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MediaPlayer getPlayerDefaut() {
        return this.playerDefaut;
    }

    public void setPlayerDefaut(MediaPlayer playerDefaut) {
        this.playerDefaut = playerDefaut;
    }
}

