/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.playlist.visionneuse;

import com.univ.mediatheque.playlist.MediaPlaylist;
import com.univ.mediatheque.playlist.visionneuse.VisionneusePlaylist;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.objetspartages.om.Media;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVisionneusePlaylistDefaut
implements VisionneusePlaylist {
    private static Logger LOG = LoggerFactory.getLogger(AbstractVisionneusePlaylistDefaut.class);
    protected String name;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void produireVisionneusePlaylistDefaut(Writer out, MediaPlaylist playlist) throws IOException {
        List<Media> medias = playlist.getMediaList();
        if (medias != null && medias.size() > 0) {
            String ulClass;
            StringBuilder stringBuider = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)playlist.getTitre())) {
                String classTitre = this.getClassTitre();
                stringBuider.append("<p");
                if (StringUtils.isNotEmpty((CharSequence)classTitre)) {
                    stringBuider.append(" class=\"");
                    stringBuider.append(classTitre);
                    stringBuider.append("\"");
                } else {
                    LOG.debug("Classe CSS du titre de la playlist VIDE");
                }
                stringBuider.append(">");
                stringBuider.append(playlist.getTitre());
                stringBuider.append("</p>");
            } else {
                LOG.debug("Titre de la playlist VIDE");
            }
            stringBuider.append("<ul ");
            String ulId = this.getUlId();
            if (StringUtils.isNotEmpty((CharSequence)ulId)) {
                stringBuider.append("id=\"" + ulId + "\" ");
            }
            if (StringUtils.isNotEmpty((CharSequence)(ulClass = this.getUlClass()))) {
                stringBuider.append("class=\"" + ulClass + "\" ");
            }
            stringBuider.append(">");
            String liClassPair = this.getLiClassPair();
            String liClassImpair = this.getLiClassImpair();
            String liClassPremier = this.getLiClassPremier();
            String liClassDernier = this.getLiClassDernier();
            String liClass = this.getLiClass();
            LOG.debug("Affichage des " + medias.size() + " dans une liste UL - LI");
            for (int i = 0; i < medias.size(); ++i) {
                StringBuilder liClassLi = new StringBuilder();
                Media media = medias.get(i);
                stringBuider.append("<li");
                this.addClassCSS(liClassLi, liClass);
                if (i == 0) {
                    this.addClassCSS(liClassLi, liClassPremier);
                } else if (i + 1 == medias.size()) {
                    this.addClassCSS(liClassLi, liClassDernier);
                }
                if (i % 2 == 0) {
                    this.addClassCSS(liClassLi, liClassPair);
                } else {
                    this.addClassCSS(liClassLi, liClassImpair);
                }
                if (liClassLi.length() > 0) {
                    stringBuider.append(" class=\"");
                    stringBuider.append((CharSequence)liClassLi);
                    stringBuider.append("\"");
                }
                stringBuider.append(">");
                stringBuider.append(this.getElementHTML(media, playlist));
                stringBuider.append("</li>");
            }
            stringBuider.append("</ul>");
            out.write(stringBuider.toString());
        } else {
            LOG.info("La liste de m\u00e9dia contenus dans la playlist est vide");
        }
    }

    protected String getElementHTML(Media media, MediaPlaylist playlist) {
        MediaStyle style = playlist.getMediaStyle(media);
        if (style != null) {
            return style.getContenuHTML(media);
        }
        LOG.info("Impossible de trouver un style de m\u00e9dia pour le m\u00e9dia ID :" + media.getIdMedia());
        return "";
    }

    private void addClassCSS(StringBuilder container, String classCss) {
        if (classCss != null && classCss.length() > 0) {
            if (container.length() > 0) {
                container.append(" ");
            }
            container.append(classCss);
        }
    }

    public abstract String getUlId();

    public abstract String getUlClass();

    public abstract String getLiClass();

    public abstract String getLiClassPremier();

    public abstract String getLiClassDernier();

    public abstract String getLiClassPair();

    public abstract String getLiClassImpair();

    public abstract String getClassTitre();
}

