/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.playlist.visionneuse;

import com.kportal.core.config.MessageHelper;
import com.univ.mediatheque.playlist.MediaPlaylist;
import com.univ.mediatheque.playlist.visionneuse.AbstractVisionneusePlaylistDefaut;
import com.univ.mediatheque.playlist.visionneuse.VisionneusePlaylistType;
import com.univ.mediatheque.playlist.visionneuse.pagination.PositionMessagePagination;
import com.univ.mediatheque.playlist.visionneuse.pagination.VisionneusePlaylistPaginationContexte;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisionneusePlaylistPagination
extends AbstractVisionneusePlaylistDefaut {
    private static Logger LOG = LoggerFactory.getLogger(VisionneusePlaylistPagination.class);
    public static VisionneusePlaylistType TYPE = VisionneusePlaylistType.PAGINATION;
    public String MESSAGE_PAGINATION_NUM_PAGE_COURANTE = "[PG_COURANTE]";
    public String MESSAGE_PAGINATION_NB_PAGE_TOTAL = "[NB_PG_TOTAL]";
    private String MESSAGE_PAGINATION_NUM_PAGE_COURANTE_ESCAPED = "\\[PG_COURANTE\\]";
    private String MESSAGE_PAGINATION_NB_PAGE_TOTAL_ESCAPED = "\\[NB_PG_TOTAL\\]";
    protected static String HTML_ID_VISIONNEUSE_PAGINATION = "visionneuse_pagination";
    protected static String CSS_CLASS_VISIONNEUSE_PAGINATION = "visionneuse_pagination";
    protected static String CSS_CLASS_PAGINATION_CONTENU = "pagination_contenu";
    protected static String CSS_CLASS_PAGINATION_VIDE = "pagination_vide";
    protected static String CSS_CLASS_PAGINATION_AUCUNE = "pagination_aucune";
    protected static String CSS_CLASS_PAGINATION_GAUCHE = "pagination_gauche";
    protected static String CSS_CLASS_PAGINATION_PRECEDENT = "pagination_precedent";
    protected static String CSS_CLASS_PAGINATION_PAGE_PRECEDENTE = "pagination_gauche pagination_precedent";
    protected static String CSS_CLASS_PAGINATION_DROITE = "pagination_droite";
    protected static String CSS_CLASS_PAGINATION_SUIVANT = "pagination_suivant";
    protected static String CSS_CLASS_PAGINATION_PAGE_SUIVANTE = "pagination_droite pagination_suivant";
    protected static String CSS_CLASS_PAGINATION_PAIR = "pagination_pair";
    protected static String CSS_CLASS_PAGINATION_IMPAIR = "pagination_impair";
    protected String imagePagePrecedente = "";
    protected String imagePageSuivante = "";
    protected String imagePageSuivanteAucune = "";
    protected String imagePagePrecedenteAucune = "";
    protected int nombreLignes = 0;
    protected int nombreColonnes = 0;
    protected PositionMessagePagination positionPagination = PositionMessagePagination.BAS;
    protected String messagePagination = "";
    protected String messageNavigationPrecedent = "";
    protected String messageNavigationSuivante = "";
    protected String messageNavigationAucune = "";

    private void paginationGenererNavPrecedent(VisionneusePlaylistPaginationContexte context, int numPage) throws IOException {
        Writer out = context.getOut();
        if (numPage != 0) {
            String idPagePrecedente = context.getKey() + (numPage - 1);
            String message = MessageHelper.getCoreMessage(this.messageNavigationPrecedent);
            message = StringUtils.isNotEmpty((CharSequence)message) ? StringEscapeUtils.escapeHtml4((String)message) : "";
            out.write("<div class=\"");
            out.write(CSS_CLASS_PAGINATION_PAGE_PRECEDENTE);
            out.write("\"><a href=\"#ANC_");
            out.write(idPagePrecedente);
            out.write("\" title=\"");
            out.write(message);
            out.write("\"><img src=\"");
            out.write(this.imagePagePrecedente);
            out.write("\" alt=\"");
            out.write(message);
            out.write("\"/></a></div>");
        } else {
            this.genererPaginationNavPrecedenteAucune(context, CSS_CLASS_PAGINATION_GAUCHE);
        }
    }

    private void paginationGenererNavSuivant(VisionneusePlaylistPaginationContexte context, int numPage) throws IOException {
        Writer out = context.getOut();
        if (numPage < context.getNombrePage() - 1) {
            String idPageSuivante = context.getKey() + (numPage + 1);
            String message = MessageHelper.getCoreMessage(this.messageNavigationSuivante);
            message = StringUtils.isNotEmpty((CharSequence)message) ? StringEscapeUtils.escapeHtml4((String)message) : "";
            out.write("<div class=\"");
            out.write(CSS_CLASS_PAGINATION_PAGE_SUIVANTE);
            out.write("\"><a href=\"#ANC_");
            out.write(idPageSuivante);
            out.write("\" title=\"");
            out.write(message);
            out.write("\"><img src=\"");
            out.write(this.imagePageSuivante);
            out.write("\" alt=\"");
            out.write(message);
            out.write("\"/></a></div>");
        } else {
            this.genererPaginationNavSuivanteAucune(context, CSS_CLASS_PAGINATION_DROITE);
        }
    }

    private void genererPaginationNavPrecedenteAucune(VisionneusePlaylistPaginationContexte context, String complementClass) throws IOException {
        Writer out = context.getOut();
        out.write("<div class=\"");
        out.write(CSS_CLASS_PAGINATION_AUCUNE);
        out.write(" ");
        out.write(complementClass);
        out.write("\">");
        if (StringUtils.isNotEmpty((CharSequence)this.imagePagePrecedenteAucune)) {
            String message = MessageHelper.getCoreMessage(this.messageNavigationAucune);
            message = StringUtils.isNotEmpty((CharSequence)message) ? StringEscapeUtils.escapeHtml4((String)message) : "";
            out.write("<img src=\"");
            out.write(this.imagePagePrecedenteAucune);
            out.write("\" alt=\"");
            out.write(message);
            out.write("\"/>");
        }
        out.write("</div>");
    }

    private void genererPaginationNavSuivanteAucune(VisionneusePlaylistPaginationContexte context, String complementClass) throws IOException {
        Writer out = context.getOut();
        out.write("<div class=\"");
        out.write(CSS_CLASS_PAGINATION_AUCUNE);
        out.write(" ");
        out.write(complementClass);
        out.write("\">");
        if (StringUtils.isNotEmpty((CharSequence)this.imagePageSuivanteAucune)) {
            String message = MessageHelper.getCoreMessage(this.messageNavigationAucune);
            message = StringUtils.isNotEmpty((CharSequence)message) ? StringEscapeUtils.escapeHtml4((String)message) : "";
            out.write("<img src=\"");
            out.write(this.imagePageSuivanteAucune);
            out.write("\" alt=\"");
            out.write(message);
            out.write("\"/>");
        }
        out.write("</div>");
    }

    private void genererTFoot(VisionneusePlaylistPaginationContexte context, int numPage) throws IOException {
        Writer out = context.getOut();
        out.write("<div class=\"footer\">");
        this.pagniationGenererContenuTheadTfoot(context, PositionMessagePagination.BAS, numPage);
        out.write("</div>");
    }

    private void genererTHead(VisionneusePlaylistPaginationContexte context, int numPage) throws IOException {
        Writer out = context.getOut();
        out.write("<div class=\"head\">");
        this.pagniationGenererContenuTheadTfoot(context, PositionMessagePagination.HAUT, numPage);
        out.write("</div>");
    }

    private void pagniationGenererContenuTheadTfoot(VisionneusePlaylistPaginationContexte context, PositionMessagePagination position, int numPage) throws IOException {
        Writer out = context.getOut();
        if ((position.equals((Object)this.positionPagination) || this.positionPagination.equals((Object)PositionMessagePagination.TOUT)) && context.afficherBoutonsNavigation()) {
            out.write(this.genererMessagePagination(context, numPage));
        }
    }

    private String genererMessagePagination(VisionneusePlaylistPaginationContexte context, int pageCourante) {
        String nombrePageTotal = String.valueOf(context.getNombrePage());
        String numPageCourante = String.valueOf(pageCourante + 1);
        String message = MessageHelper.getCoreMessage(this.messagePagination);
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            return message.replaceAll(this.MESSAGE_PAGINATION_NB_PAGE_TOTAL_ESCAPED, nombrePageTotal).replaceAll(this.MESSAGE_PAGINATION_NUM_PAGE_COURANTE_ESCAPED, numPageCourante);
        }
        return "";
    }

    @Override
    public void genererVionneusePlaylist(ContexteUniv ctx, Writer out, MediaPlaylist playList) throws Exception {
        LOG.debug("Debut de la generation du code de la visionneuse de playlist Pagination");
        List<Media> medias = playList.getMediaList();
        if (medias != null && medias.size() > 0) {
            VisionneusePlaylistPaginationContexte context = new VisionneusePlaylistPaginationContexte(ctx, out, medias.size(), this.nombreLignes, this.nombreColonnes);
            if (context.getNombrePage() > 0) {
                LOG.debug("Nombre de pages \u00e0 afficher : " + context.getNombrePage());
                LOG.debug("Nombre de lignes par page : " + context.getNombreLigne());
                LOG.debug("Nombre de colonnes par page : " + context.getNombreColonne());
                int numElement = 0;
                for (int numPage = 0; numPage < context.getNombrePage(); ++numPage) {
                    LOG.debug("Construction de la page : " + numPage);
                    out.write("<a name=\"ANC_");
                    out.write(context.getKey());
                    out.write(String.valueOf(numPage));
                    out.write("\"></a>");
                    out.write("<div id=\"");
                    out.write(HTML_ID_VISIONNEUSE_PAGINATION);
                    out.write(context.getKey());
                    out.write(String.valueOf(numPage));
                    out.write("\" class=\"");
                    out.write(CSS_CLASS_VISIONNEUSE_PAGINATION);
                    out.write("\">");
                    out.write("<div class=\"caption\">");
                    out.write(playList.getTitre());
                    out.write("</div>");
                    this.genererTHead(context, numPage);
                    if (context.afficherBoutonsNavigation()) {
                        this.paginationGenererNavPrecedent(context, numPage);
                    }
                    out.write("<div class=\"");
                    out.write(CSS_CLASS_PAGINATION_CONTENU);
                    out.write("\" summary=\"\">");
                    for (int numCol = 0; numCol < context.getNombreColonne(); ++numCol) {
                        if (numCol % 2 == 0) {
                            out.write("<col class=\"");
                            out.write(CSS_CLASS_PAGINATION_PAIR);
                            out.write("\" />");
                            continue;
                        }
                        out.write("<col class=\"");
                        out.write(CSS_CLASS_PAGINATION_IMPAIR);
                        out.write("\" />");
                    }
                    out.write("<div>");
                    for (int numRow = 0; numRow < context.getNombreLigne(); ++numRow) {
                        if (numRow % 2 == 0) {
                            out.write("<div class=\"");
                            out.write(CSS_CLASS_PAGINATION_PAIR);
                            out.write("\">");
                        } else {
                            out.write("<div>");
                        }
                        for (int numCol = 0; numCol < context.getNombreColonne(); ++numCol) {
                            if (numElement < context.getNombreElement()) {
                                Media media = medias.get(numElement);
                                out.write(super.getElementHTML(media, playList));
                                ++numElement;
                                continue;
                            }
                            out.write("&nbsp;");
                        }
                        out.write("</div>");
                    }
                    out.write("</div>");
                    out.write("</div>");
                    if (context.afficherBoutonsNavigation()) {
                        this.paginationGenererNavSuivant(context, numPage);
                    }
                    this.genererTFoot(context, numPage);
                    out.write("</div>");
                }
            } else {
                LOG.debug("Aucune information sur le nombre de colonnes et de lignes \u00e0 afficher => affichage en UL - LI");
                super.produireVisionneusePlaylistDefaut(out, playList);
            }
        } else {
            LOG.info("La liste d em\u00e9dias \u00e0 afficher est vide");
        }
    }

    @Override
    public VisionneusePlaylistType getType() {
        return TYPE;
    }

    public void setImagePagePrecedente(String imagePagePrecedente) {
        this.imagePagePrecedente = imagePagePrecedente;
    }

    public void setImagePageSuivante(String imagePageSuivante) {
        this.imagePageSuivante = imagePageSuivante;
    }

    public void setImagePageAucune(String imagePageAucune) {
        this.imagePagePrecedenteAucune = imagePageAucune;
    }

    public void setNombreLignes(int nombreLignes) {
        this.nombreLignes = nombreLignes;
    }

    public void setNombreColonnes(int nombreColonnes) {
        this.nombreColonnes = nombreColonnes;
    }

    public void setMessagePagination(String messagePagination) {
        this.messagePagination = messagePagination;
    }

    public void setPositionPagination(PositionMessagePagination positionPagination) {
        this.positionPagination = positionPagination;
    }

    public void setPositionPaginationParLibelle(String positionPaginationLibelle) {
        PositionMessagePagination positionPagination = PositionMessagePagination.getPositionMessagePagination(positionPaginationLibelle);
        if (positionPagination != null) {
            this.setPositionPagination(positionPagination);
        } else {
            LOG.info("Aucun ENUM PositionMessagePagination ne correspond au libell\u00e9 : " + positionPaginationLibelle);
        }
    }

    public void setMessageNavigationPrecedent(String messageNavigationPrecedent) {
        this.messageNavigationPrecedent = messageNavigationPrecedent;
    }

    public void setMessageNavigationSuivante(String messageNavigationSuivante) {
        this.messageNavigationSuivante = messageNavigationSuivante;
    }

    public void setMessageNavigationAucune(String messageNavigationAucune) {
        this.messageNavigationAucune = messageNavigationAucune;
    }

    @Override
    public String getLiClass() {
        return null;
    }

    @Override
    public String getLiClassDernier() {
        return null;
    }

    @Override
    public String getLiClassImpair() {
        return CSS_CLASS_PAGINATION_IMPAIR;
    }

    @Override
    public String getLiClassPair() {
        return CSS_CLASS_PAGINATION_PAIR;
    }

    @Override
    public String getLiClassPremier() {
        return null;
    }

    @Override
    public String getUlClass() {
        return null;
    }

    @Override
    public String getUlId() {
        return null;
    }

    @Override
    public String getClassTitre() {
        return null;
    }

    public String getImagePageSuivanteAucune() {
        return this.imagePageSuivanteAucune;
    }

    public void setImagePageSuivanteAucune(String imagePageSuivanteAucune) {
        this.imagePageSuivanteAucune = imagePageSuivanteAucune;
    }

    public String getImagePagePrecedenteAucune() {
        return this.imagePagePrecedenteAucune;
    }

    public void setImagePagePrecedenteAucune(String imagePagePrecedenteAucune) {
        this.imagePagePrecedenteAucune = imagePagePrecedenteAucune;
    }
}

