/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.playlist.visionneuse.pagination;

import com.univ.utils.ContexteUniv;
import java.io.Writer;

public class VisionneusePlaylistPaginationContexte {
    private int nombreLigne;
    private int nombreColonne;
    private String key = Long.toString(System.currentTimeMillis());
    private ContexteUniv ctx;
    private Writer out;
    private int nombrePage;
    private int nombreElement;

    public VisionneusePlaylistPaginationContexte(ContexteUniv ctx, Writer out, int nombreElement, int nbLigne, int nbColonne) {
        this.nombreElement = nombreElement;
        this.ctx = ctx;
        this.out = out;
        this.nombreColonne = this.getNombreColonne(nbColonne, nbLigne, nombreElement);
        this.nombreLigne = this.getNombreLigne(nbColonne, nbLigne, nombreElement);
        this.nombrePage = this.calculNombrePage(nbColonne, nbLigne, nombreElement);
    }

    private int calculNombrePage(int nbColonne, int nbLigne, int nombreElement) {
        if (nbColonne != 0 && nbLigne != 0) {
            int nbElementPerPage = this.getNombreColonne(nbColonne, nbLigne, nombreElement) * this.getNombreLigne(nbColonne, nbLigne, nombreElement);
            int nbPage = nombreElement / nbElementPerPage;
            if (nombreElement % nbElementPerPage > 0) {
                ++nbPage;
            }
            return nbPage;
        }
        if (nbColonne != 0 || nbLigne != 0) {
            return 1;
        }
        return 0;
    }

    private int getNombreColonne(int nbColonne, int nbLigne, int nombreElement) {
        if (nbColonne > 0) {
            return nbColonne;
        }
        if (nbLigne > 0) {
            int nbColonneNew = nombreElement / nbLigne;
            if (nombreElement % nbLigne > 0) {
                ++nbColonneNew;
            }
            return nbColonneNew;
        }
        return 0;
    }

    private int getNombreLigne(int nbColonne, int nbLigne, int nombreElement) {
        if (nbLigne > 0) {
            return nbLigne;
        }
        if (nbColonne > 0) {
            int nbLigneNew = nombreElement / nbColonne;
            if (nombreElement % nbColonne > 0) {
                ++nbLigneNew;
            }
            return nbLigneNew;
        }
        return 0;
    }

    public int getNombreLigne() {
        return this.nombreLigne;
    }

    public int getNombreColonne() {
        return this.nombreColonne;
    }

    public String getKey() {
        return this.key;
    }

    public ContexteUniv getCtx() {
        return this.ctx;
    }

    public Writer getOut() {
        return this.out;
    }

    public int getNombrePage() {
        return this.nombrePage;
    }

    public int getNombreElement() {
        return this.nombreElement;
    }

    public boolean afficherBoutonsNavigation() {
        return this.nombrePage > 1;
    }
}

