/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.scheduler;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.scheduling.spring.quartz.LogReportJob;
import com.univ.objetspartages.om.Media;
import com.univ.utils.FileUtil;
import com.univ.utils.ImageInfo;
import com.univ.utils.PhotoUtil;
import java.io.File;
import java.io.FileInputStream;

public class GenerateThumbnailJob
extends LogReportJob {
    @Override
    public void perform() {
        String[] thumbnailDimensions = PropertyHelper.getCoreProperty("phototheque.vignette").split("/", -2);
        int width = Integer.parseInt(thumbnailDimensions[1]);
        int height = Integer.parseInt(thumbnailDimensions[2]);
        this.rebuildThumbnails(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildThumbnails(int requestedWidth, int requestedHeight) {
        ContextePage ctx = null;
        boolean resize = true;
        try {
            ctx = new ContextePage();
            Media media = new Media();
            media.setCtx(ctx);
            media.init();
            this.logger.info(String.format("%d m\u00e9dias \u00e0 traiter", media.count(" where T1.TYPE_RESSOURCE = 'photo'")));
            media.select(" where T1.TYPE_RESSOURCE = 'photo'");
            while (media.nextItem()) {
                try {
                    this.logger.info(String.format("Traitement du m\u00e9dia \"%s\"", media.getUrlAbsolue()));
                    resize = true;
                    String vignetteDestinationPath = "";
                    if (media.getUrlVignette().length() == 0) {
                        resize = false;
                        this.logger.info(String.format("Pas de vignette pour le m\u00e9dia \"%s\". Passage au m\u00e9dia suivant.", media.getUrlAbsolue()));
                    } else {
                        this.logger.info(String.format("Vignette d\u00e9tect\u00e9e pour le m\u00e9dia \"%s\". R\u00e9cup\u00e9ration des informations.", media.getUrlAbsolue()));
                        vignetteDestinationPath = media.getPathAbsolu().replaceFirst("[^/\\\\]*$", media.getUrlVignette());
                        File vignetteDestination = new File(vignetteDestinationPath);
                        if (vignetteDestination.exists() && vignetteDestination.isFile()) {
                            FileInputStream fis = null;
                            ImageInfo ii = new ImageInfo();
                            try {
                                fis = new FileInputStream(vignetteDestinationPath);
                                ii.setInput(fis);
                                ii.check();
                                ii.close();
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                    ii.close();
                                }
                            }
                        }
                    }
                    if (!resize) continue;
                    this.logger.info(String.format("Cr\u00e9ation de la vignette pour le m\u00e9dia \"%s\".", media.getUrlAbsolue()));
                    FileInputStream mediaFileIs = null;
                    File mediaFile = null;
                    ImageInfo imageInfo = new ImageInfo();
                    try {
                        this.logger.info(String.format("Tentative de calcul des dimensions du m\u00e9dia %s", media.getUrlAbsolue()));
                        mediaFile = new File(media.getPathAbsolu());
                        if (!mediaFile.exists()) continue;
                        mediaFileIs = new FileInputStream(mediaFile);
                        imageInfo.setInput(mediaFileIs);
                    }
                    catch (Exception e) {
                        this.logger.error(String.format("Echec lors de la tentative de calcul des dimensions du m\u00e9dia %s", media.getUrlAbsolue()), (Throwable)e);
                    }
                    finally {
                        if (mediaFileIs == null) continue;
                        mediaFileIs.close();
                        imageInfo.close();
                        continue;
                    }
                    int largeurVignette = requestedWidth;
                    int hauteurVignette = requestedHeight;
                    this.logger.info(String.format("Pr\u00e9paration du redimmensionnement du m\u00e9dia %s : dimension cibl\u00e9e [%dx%d]", media.getUrlAbsolue(), largeurVignette, hauteurVignette));
                    mediaFile = new File(media.getPathAbsolu());
                    if (mediaFile.exists()) {
                        File vignette = PhotoUtil.resize(media.getPathAbsolu(), FileUtil.getExtension(media.getUrl()), largeurVignette, hauteurVignette, false);
                        FileUtil.copierFichier(vignette, new File(vignetteDestinationPath), vignette.getName().startsWith("tmp_"));
                        continue;
                    }
                    this.logger.info(String.format("M\u00e9dia %s inexistant. Passage au m\u00e9dia suivant.", media.getUrlAbsolue()));
                }
                catch (Exception e) {
                    this.logger.error(String.format("Une erreur est survenue lors de la tentative de g\u00e9n\u00e9ration de vignette pour le m\u00e9dia %s", media.getUrlAbsolue()), (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ctx != null) {
                ctx.release();
            }
        }
    }
}

