/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.style;

import com.kportal.core.config.MessageHelper;
import com.univ.mediatheque.container.AttributBaliseHTML;
import com.univ.mediatheque.container.LanceurMedia;
import com.univ.mediatheque.style.MapMedia;
import com.univ.mediatheque.style.MediaStyle;
import com.univ.mediatheque.utils.HTMLUtils;
import com.univ.objetspartages.om.Media;
import com.univ.utils.ContexteUniv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMediaStyle
implements MediaStyle {
    protected ContexteUniv ctx = null;
    Map<Long, List<LanceurMedia>> lanceursMedia = new HashMap<Long, List<LanceurMedia>>();
    private String name;

    @Override
    public void setCtx(ContexteUniv ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setLanceurMedia(LanceurMedia lanceur) {
        Long idMedia = lanceur.getMedia().getIdMedia();
        List<LanceurMedia> listeLanceur = this.lanceursMedia.get(idMedia);
        if (listeLanceur == null) {
            listeLanceur = new ArrayList<LanceurMedia>();
            this.lanceursMedia.put(idMedia, listeLanceur);
        }
        listeLanceur.add(lanceur);
    }

    @Override
    public String getContenuHTML(Media media) {
        List<LanceurMedia> lanceurs = this.lanceursMedia.get(media.getIdMedia());
        if (lanceurs != null && lanceurs.size() > 0) {
            StringBuilder contenuHtmlAvant = new StringBuilder();
            StringBuilder contenuHtmlApres = new StringBuilder();
            StringBuilder contenuJsAvant = new StringBuilder();
            StringBuilder contenuJsApres = new StringBuilder();
            StringBuilder contenuHtml = new StringBuilder();
            for (LanceurMedia lanceur : lanceurs) {
                contenuHtmlAvant.append(lanceur.getHTMLAvantLanceur());
                contenuHtmlApres.append(lanceur.getHTMLApresLanceur());
                contenuJsAvant.append(lanceur.getJSAvantLanceur());
                contenuJsApres.append(lanceur.getJSApresLanceur());
            }
            contenuHtml.append((CharSequence)contenuHtmlAvant);
            if (contenuJsAvant.length() > 0) {
                contenuHtml.append(HTMLUtils.HTML_SCRIPT_JS_OPEN);
                contenuHtml.append((CharSequence)contenuJsAvant);
                contenuHtml.append(HTMLUtils.HTML_SCRIPT_JS_CLOSE);
            }
            contenuHtml.append(this.getHTML(media));
            contenuHtml.append((CharSequence)contenuHtmlApres);
            if (contenuJsApres.length() > 0) {
                contenuHtml.append(HTMLUtils.HTML_SCRIPT_JS_OPEN);
                contenuHtml.append((CharSequence)contenuJsApres);
                contenuHtml.append(HTMLUtils.HTML_SCRIPT_JS_CLOSE);
            }
            return contenuHtml.toString();
        }
        return this.getHTML(media);
    }

    @Override
    public void init() {
    }

    protected String genererLanceurMediaDebut(Media media) {
        String messageInfo;
        StringBuilder valeurAttributHTMLTmp;
        Set<Object> attributHTMLTmp;
        List<LanceurMedia> lanceurs = this.lanceursMedia.get(media.getIdMedia());
        StringBuilder startLanceur = new StringBuilder();
        startLanceur.append("<a");
        HashMap<AttributBaliseHTML, StringBuilder> attributsHTML = new HashMap<AttributBaliseHTML, StringBuilder>();
        for (LanceurMedia lanceurMedia : lanceurs) {
            attributHTMLTmp = lanceurMedia.getAttributsBaliseHTML();
            for (AttributBaliseHTML attributBaliseHTML : attributHTMLTmp) {
                String valeurAttributLanceur = lanceurMedia.getValeurAttributHTML(attributBaliseHTML);
                if (!StringUtils.isNotEmpty((CharSequence)valeurAttributLanceur)) continue;
                valeurAttributHTMLTmp = (StringBuilder)attributsHTML.get((Object)attributBaliseHTML);
                if (valeurAttributHTMLTmp == null) {
                    valeurAttributHTMLTmp = new StringBuilder();
                    attributsHTML.put(attributBaliseHTML, valeurAttributHTMLTmp);
                    valeurAttributHTMLTmp.append(valeurAttributLanceur);
                    continue;
                }
                valeurAttributHTMLTmp.append(" ");
                valeurAttributHTMLTmp.append(valeurAttributLanceur);
            }
        }
        attributHTMLTmp = attributsHTML.keySet();
        for (AttributBaliseHTML attributBaliseHTML : attributHTMLTmp) {
            valeurAttributHTMLTmp = (StringBuilder)attributsHTML.get((Object)attributBaliseHTML);
            if (valeurAttributHTMLTmp == null || valeurAttributHTMLTmp.length() <= 0) continue;
            startLanceur.append(" ");
            startLanceur.append(attributBaliseHTML.getLibelle());
            startLanceur.append("=\"");
            startLanceur.append((CharSequence)valeurAttributHTMLTmp);
            if (AttributBaliseHTML.HREF.equals((Object)attributBaliseHTML) && media.isLocal()) {
                startLanceur.append(String.format("%sMEDIA_ID=%s", startLanceur.toString().indexOf("?") != -1 ? "&" : "?", media.getIdMedia().toString()));
                startLanceur.append("#TARGET=BLANK");
            }
            startLanceur.append("\"");
        }
        if (!attributHTMLTmp.contains((Object)AttributBaliseHTML.TITLE) && StringUtils.isNotEmpty((CharSequence)(messageInfo = this.getMessageInformatifLanceur(media)))) {
            startLanceur.append(" title=\"");
            startLanceur.append(StringEscapeUtils.escapeHtml4((String)MessageHelper.getCoreMessage(messageInfo)));
            startLanceur.append("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)media.getTypeRessource())) {
            startLanceur.append(" data-type=\"");
            startLanceur.append(MapMedia.getInstance().getTypeMediaFront(media.getTypeRessource()));
            startLanceur.append("\"");
        }
        startLanceur.append(">");
        return startLanceur.toString();
    }

    protected String genererLanceurMediaFin(Media media) {
        return "</a>";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract String getHTML(Media var1);

    protected abstract String getMessageInformatifLanceur(Media var1);
}

