/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.style;

import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.style.AbstractMediaStyle;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.utils.URLResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaStyleComplet
extends AbstractMediaStyle {
    protected int HAUTEUR_MAX_VIGNETTE_DEFAUT = 75;
    protected int LARGEUR_MAX_VIGNETTE_DEFAUT = 100;
    private static Logger LOG = LoggerFactory.getLogger(MediaStyleComplet.class);
    private String messageInformatifLanceur;
    private int hauteurMaxVignette = this.HAUTEUR_MAX_VIGNETTE_DEFAUT;
    private int largeurMaxVignette = this.LARGEUR_MAX_VIGNETTE_DEFAUT;

    public void setMessageInformatifLanceur(String messageInformatifLanceur) {
        this.messageInformatifLanceur = messageInformatifLanceur;
    }

    @Override
    protected String getHTML(Media media) {
        String auteur;
        String description;
        StringBuilder returnString = new StringBuilder();
        String legende = media.getLegende();
        returnString.append("<div class=\"style1_media\">");
        Properties proprieteMedia = new Properties();
        try {
            proprieteMedia.load(new ByteArrayInputStream(media.getSpecificData().getBytes()));
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        returnString.append(this.genererLanceurMediaDebut(media));
        returnString.append("<span class=\"style1_media_vignette\" style=\"height:");
        returnString.append(String.valueOf(this.getHauteurMaxVignette()));
        returnString.append("px; line-height:");
        returnString.append(String.valueOf(this.getHauteurMaxVignette()));
        returnString.append("px\"><img src=\"");
        if (media.getUrlVignetteAbsolue().length() > 0) {
            returnString.append(URLResolver.getAbsoluteUrl(media.getUrlVignetteAbsolue(), this.ctx));
        } else {
            Mediatheque mediatheque = Mediatheque.getInstance();
            SpecificMedia specificMedia = mediatheque.getRessource(media.getTypeRessource());
            returnString.append(URLResolver.getAbsoluteUrl(specificMedia.getUrlVignette(), this.ctx));
        }
        returnString.append("\"");
        String strHauteurVignette = (String)proprieteMedia.get("HAUTEUR");
        String strLargeurVignette = (String)proprieteMedia.get("LARGEUR");
        if (StringUtils.isNotEmpty((CharSequence)strHauteurVignette) && StringUtils.isNotEmpty((CharSequence)strLargeurVignette)) {
            int hauteur = Integer.valueOf(strHauteurVignette);
            int largeur = Integer.valueOf(strLargeurVignette);
            if (hauteur > 0 && largeur > 0) {
                int newHauteur = hauteur > this.getHauteurMaxVignette() ? this.getHauteurMaxVignette() : hauteur;
                int newLargeur = (int)((float)largeur / (float)(hauteur / newHauteur));
                if (newLargeur > this.getLargeurMaxVignette()) {
                    newHauteur = (int)((float)newHauteur / (float)(newLargeur / this.getLargeurMaxVignette()));
                    newLargeur = this.getLargeurMaxVignette();
                }
                returnString.append(" height=\"");
                returnString.append(String.valueOf(newHauteur));
                returnString.append("px\"");
                returnString.append(" width=\"");
                returnString.append(String.valueOf(newLargeur));
                returnString.append("px\"");
            }
        }
        returnString.append(" alt=\"");
        returnString.append(StringEscapeUtils.escapeHtml4((String)legende));
        returnString.append("\" /></span>");
        returnString.append(this.genererLanceurMediaFin(media));
        returnString.append("<div class=\"style1_media_contenu\"><strong class=\"style1_media_titre\">");
        String titre = media.getTitre();
        if (StringUtils.isEmpty((CharSequence)titre)) {
            titre = media.getSource();
        }
        returnString.append(titre);
        returnString.append("</strong>");
        if (StringUtils.isNotEmpty((CharSequence)legende)) {
            returnString.append("<p class=\"style1_media_legende\">");
            returnString.append(legende);
            returnString.append("</p>");
        }
        if (StringUtils.isNotEmpty((CharSequence)(description = media.getDescription()))) {
            returnString.append("<p class=\"style1_media_description\">");
            returnString.append(description);
            returnString.append("</p>");
        }
        if (StringUtils.isNotEmpty((CharSequence)(auteur = media.getAuteur()))) {
            returnString.append("<p class=\"style1_media_auteur\">");
            returnString.append(auteur);
            returnString.append("</p>");
        }
        returnString.append("</div><!-- style1_media_contenu --></div><!-- style1_media -->");
        return returnString.toString();
    }

    @Override
    protected String getMessageInformatifLanceur(Media media) {
        return this.messageInformatifLanceur;
    }

    public int getHauteurMaxVignette() {
        return this.hauteurMaxVignette;
    }

    public void setHauteurMaxVignette(int hauteurMaxVignette) {
        this.hauteurMaxVignette = hauteurMaxVignette;
    }

    public int getLargeurMaxVignette() {
        return this.largeurMaxVignette;
    }

    public void setLargeurMaxVignette(int largeurMaxVignette) {
        this.largeurMaxVignette = largeurMaxVignette;
    }
}

