/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.style;

import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.style.AbstractMediaStyle;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.utils.URLResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaStyleSimple
extends AbstractMediaStyle {
    protected int HAUTEUR_MAX_VIGNETTE_DEFAUT = 75;
    protected int LARGEUR_MAX_VIGNETTE_DEFAUT = 100;
    private static final Logger LOG = LoggerFactory.getLogger(MediaStyleSimple.class);
    private String messageInformatifLanceur;
    private int hauteurMaxVignette = this.HAUTEUR_MAX_VIGNETTE_DEFAUT;
    private int largeurMaxVignette = this.LARGEUR_MAX_VIGNETTE_DEFAUT;

    public void setMessageInformatifLanceur(String messageInformatifLanceur) {
        this.messageInformatifLanceur = messageInformatifLanceur;
    }

    @Override
    protected String getHTML(Media media) {
        StringBuilder returnString = new StringBuilder();
        String legende = media.getLegende();
        returnString.append("<div class=\"style1_media\">");
        Properties proprieteMedia = new Properties();
        try {
            proprieteMedia.load(new ByteArrayInputStream(media.getSpecificData().getBytes()));
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        returnString.append(this.genererLanceurMediaDebut(media));
        returnString.append("<span class=\"style1_media_vignette\" style=\"height:");
        returnString.append(String.valueOf(this.getHauteurMaxVignette()));
        returnString.append("px; line-height:");
        returnString.append(String.valueOf(this.getHauteurMaxVignette()));
        returnString.append("px\"><img src=\"");
        if (media.getUrlVignetteAbsolue().length() > 0) {
            returnString.append(URLResolver.getAbsoluteUrl(media.getUrlVignetteAbsolue(), this.ctx));
        } else {
            Mediatheque mediatheque = Mediatheque.getInstance();
            SpecificMedia specificMedia = mediatheque.getRessource(media.getTypeRessource());
            returnString.append(URLResolver.getAbsoluteUrl(specificMedia.getUrlVignette(), this.ctx));
        }
        returnString.append("\"");
        returnString.append(" alt=\"");
        returnString.append(StringEscapeUtils.escapeHtml4((String)legende));
        returnString.append("\" />");
        returnString.append("<span class=\"style1_media_contenu\">");
        String titre = media.getTitre();
        if (StringUtils.isEmpty((CharSequence)titre)) {
            titre = media.getSource();
        }
        returnString.append("<strong class=\"style1_media_titre\">");
        returnString.append("<p class=\"titre_corps\">");
        returnString.append(titre);
        returnString.append("</p>");
        if (StringUtils.isNotEmpty((CharSequence)legende)) {
            returnString.append("<p class=\"style1_media_legende\">");
            returnString.append(legende);
            returnString.append("</p>");
        }
        returnString.append("</strong>");
        returnString.append("</span><!-- style1_media_contenu -->");
        returnString.append("</span>");
        returnString.append(this.genererLanceurMediaFin(media));
        returnString.append("</div><!-- style1_media -->");
        return returnString.toString();
    }

    @Override
    protected String getMessageInformatifLanceur(Media media) {
        return this.messageInformatifLanceur;
    }

    public int getHauteurMaxVignette() {
        return this.hauteurMaxVignette;
    }

    public void setHauteurMaxVignette(int hauteurMaxVignette) {
        this.hauteurMaxVignette = hauteurMaxVignette;
    }

    public int getLargeurMaxVignette() {
        return this.largeurMaxVignette;
    }

    public void setLargeurMaxVignette(int largeurMaxVignette) {
        this.largeurMaxVignette = largeurMaxVignette;
    }
}

