/*
 * Decompiled with CFR 0.152.
 */
package com.univ.mediatheque.utils;

import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MediathequeHelper {
    private static final String DEFAULT_STYLES_TAG_GALERIE = "/adminsite/fcktoolbox/kosmos/plugins/k_galerie/styles.jsp";
    private static final String MEDIATHEQUE_STYLES_TAG_GALERIE = "mediatheque.styles.tag.galerie";
    private static final String MEDIATHEQUE_PATH_PROPERTIES_KEY = "mediatheque.path";
    private static final String MEDIATHEQUE_FOLDER = "mediatheque.folder";
    public static final String CRITERES_VIGNETTE_PROPERTIES_KEY = "phototheque.vignette";
    public static final String CRITERES_LIMITE_PROPERTIES_KEY = "phototheque.limite";
    public static final String CRITERES_DIMENSION_PROPERTIES_KEY = "phototheque.dimension";
    public static final String CRITERES_PROPORTIONS_PROPERTIES_KEY = "phototheque.proportions";
    private static final Pattern PATTERN_VIMEO = Pattern.compile("(http://|http://)vimeo.com/([0-9]+)");
    private static final Pattern PATTERN_YOUTUBE = Pattern.compile("(http|https):\\/\\/(?:youtu\\.be\\/|(?:[a-z]{2,3}\\.)?youtube\\.com\\/watch(?:\\?|#\\!)v=)([\\w-]{11}).*");
    private static final Pattern PATTERN_DAILYMOTION = Pattern.compile("(http|https):\\/\\/www.dailymotion.com\\/(embed\\/video|video|swf)\\/([^_&]+).*");
    public static final String PRE_EXTENSION_CHARACTER = "-";

    public static String getAbsolutePath() {
        String res = (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(MEDIATHEQUE_PATH_PROPERTIES_KEY), (CharSequence)(WebAppUtil.getAbsolutePath() + MediathequeHelper.getDefaultRelativePath()));
        if (StringUtils.isNotEmpty((CharSequence)res) && !new File(res).exists()) {
            new File(res).mkdir();
        }
        return res;
    }

    public static String getDefaultRelativePath() {
        return PropertyHelper.getCoreProperty(MEDIATHEQUE_FOLDER);
    }

    public static String getUrlRelativePath() {
        return StringUtils.replace((String)System.getProperty("media.url-pattern"), (String)"/*", (String)"/");
    }

    public static String getTemplateStylesTagGalerie() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)PropertyHelper.getCoreProperty(MEDIATHEQUE_STYLES_TAG_GALERIE), (CharSequence)DEFAULT_STYLES_TAG_GALERIE);
    }

    public static String convertToEmbedUrl(String url) {
        String convertedUrl = url;
        Matcher matcherVimeo = PATTERN_VIMEO.matcher(url);
        Matcher matcherYoutube = PATTERN_YOUTUBE.matcher(url);
        Matcher matcherDailymotion = PATTERN_DAILYMOTION.matcher(url);
        if (matcherYoutube.matches()) {
            convertedUrl = String.format("//www.youtube.com/embed/%s", matcherYoutube.group(2));
        } else if (matcherDailymotion.matches()) {
            convertedUrl = String.format("//www.dailymotion.com/embed/video/%s", matcherDailymotion.group(3));
        } else if (matcherVimeo.matches()) {
            convertedUrl = String.format("//player.vimeo.com/video/%s", matcherVimeo.group(2));
        }
        return convertedUrl;
    }

    public static String getUrlTempPath() {
        String res = String.format("%stmp/", MediathequeHelper.getUrlRelativePath());
        return res;
    }
}

