/*
 * Decompiled with CFR 0.152.
 */
package com.univ.migration;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.utils.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.jsp.JspWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationFront51 {
    private File readDir = null;
    private final ArrayList<String> listeMethode = new ArrayList();
    private Properties propsMigration = null;
    private JspWriter out = null;
    private StringBuffer bilan = null;
    private final Logger LOG = LoggerFactory.getLogger(MigrationFront51.class);

    public static void migrer(JspWriter _out) throws Exception {
        InputStream isProp;
        _out.println("DEBUT du traitement ...<br />");
        _out.flush();
        ContextePage ctx = new ContextePage("");
        String startDir = WebAppUtil.getAbsolutePath() + File.separator + "jsp";
        MigrationFront51 migration = new MigrationFront51();
        migration.setOut(_out);
        migration.setReadDir(new File(startDir));
        Properties prop = new Properties();
        String propPath = "migration.methodes";
        try {
            isProp = MigrationFront51.class.getResourceAsStream("/" + propPath);
            prop.load(isProp);
        }
        catch (Exception e) {
            System.err.println("ERROR: fichier de migration de m\u00e9thodes non trouv\u00e9");
            return;
        }
        migration.setPropsMigration(prop);
        _out.println("<br />*** Migration des jsps du front office ***<br />");
        migration.migrerMethodes();
        propPath = "migration.libelles";
        prop = new Properties();
        try {
            isProp = MigrationFront51.class.getResourceAsStream("/" + propPath);
            prop.load(isProp);
        }
        catch (Exception e) {
            System.err.println("ERROR: fichier de migration de libell\u00e9s non trouv\u00e9");
            return;
        }
        migration.setPropsMigration(prop);
        _out.println("<br />*** Migration des libell\u00e9s du front office ***<br />");
        String newProperties = migration.migrerLibelles(ctx);
        if (newProperties.length() > 0) {
            _out.println("<br />Ecriture des libell\u00e9s ...");
            FileWriter fw = new FileWriter(WebAppUtil.getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "Message_fr_FR.properties", true);
            BufferedWriter output = new BufferedWriter(fw);
            output.write("\n");
            output.write(newProperties);
            output.flush();
            output.close();
        }
        _out.println("<br /><br />FIN du traitement.");
        ctx.release();
    }

    public void setReadDir(File readDir) {
        this.readDir = readDir;
    }

    public void migrerMethodes() {
        try {
            Enumeration<Object> en = this.propsMigration.keys();
            while (en.hasMoreElements()) {
                String[] elementsMethode;
                String nomMethode = (String)en.nextElement();
                if (nomMethode.indexOf("methode.") != 0 || (elementsMethode = nomMethode.split("\\.", -2)).length <= 2 || !elementsMethode[2].equals("old")) continue;
                this.listeMethode.add(elementsMethode[1]);
            }
            this.bilan = new StringBuffer();
            this.processFile(this.readDir);
            this.printlnOut("<br /><br />*** BILAN ***", true);
            this.printlnOut(this.bilan.toString(), true);
            this.out.flush();
        }
        catch (IOException e) {
            this.LOG.error("impossible de flusher le flux de sortie", (Throwable)e);
        }
    }

    public String migrerLibelles(ContextePage ctx) {
        String res = "";
        boolean changed = false;
        Properties prop = new Properties();
        try {
            Enumeration<Object> en = this.propsMigration.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (MessageHelper.getCoreMessage(key).length() != 0) continue;
                prop.put(key, this.propsMigration.get(key));
                this.printlnOut("<br />LIBELLE ajout\u00e9 : " + key, true);
                changed = true;
            }
            if (changed) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                prop.store(baos, "Migration des libell\u00e9s");
                res = baos.toString();
                baos.close();
            }
        }
        catch (Exception e) {
            this.LOG.error("erreur d'ecriture dans l'outputStream", (Throwable)e);
        }
        return res;
    }

    private void printlnOut(String s, boolean system) {
        try {
            if (system) {
                System.out.println(s);
            }
            this.out.write(s);
            this.out.newLine();
        }
        catch (IOException e) {
            this.LOG.error("erreur d'ecriture", (Throwable)e);
        }
    }

    private void processFile(File fRead) {
        if (fRead.isDirectory()) {
            File[] listFiles;
            for (File listFile : listFiles = fRead.listFiles()) {
                if (listFile.isHidden()) continue;
                this.processFile(listFile);
            }
        } else if (fRead.getName().endsWith(".jsp")) {
            this.processJsp(fRead);
        }
    }

    private void processJsp(File fRead) {
        File fWrite = new File(fRead.getAbsolutePath() + ".tmp");
        this.printlnOut("<br />Traitement du fichier : " + fRead, true);
        StringBuffer sb = new StringBuffer();
        boolean changed = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fRead));
            BufferedWriter writer = new BufferedWriter(new FileWriter(fWrite));
            String line = null;
            String methode = "";
            int indiceLine = 1;
            while ((line = reader.readLine()) != null) {
                for (int i = 0; i < this.listeMethode.size(); ++i) {
                    methode = this.propsMigration.getProperty("methode." + this.listeMethode.get(i) + ".old");
                    if (!line.contains(methode)) continue;
                    changed = true;
                    line = this.processAttribute(line, indiceLine, i, sb);
                }
                writer.write(line + "\r\n");
                ++indiceLine;
            }
            reader.close();
            writer.flush();
            writer.close();
            if (changed) {
                FileUtil.copierFichier(fWrite, fRead);
            } else {
                fWrite.delete();
            }
            if (sb.length() > 0) {
                this.bilan.append("<br /><br />Fichier : ").append(fRead);
                this.bilan.append(sb);
            }
        }
        catch (IOException e) {
            this.LOG.error("erreur lors du traitement des JSP", (Throwable)e);
        }
    }

    private String processAttribute(String line, int indiceLine, int indAttrib, StringBuffer stringBuffer) {
        StringBuilder bufferLine = new StringBuilder(line);
        int pos = 0;
        String oldMethode = this.propsMigration.getProperty("methode." + this.listeMethode.get(indAttrib) + ".old");
        String newMethode = this.propsMigration.getProperty("methode." + this.listeMethode.get(indAttrib) + ".new");
        String commMethode = this.propsMigration.getProperty("methode." + this.listeMethode.get(indAttrib) + ".commentaire");
        while ((pos = bufferLine.indexOf(oldMethode, pos)) != -1) {
            if (commMethode == null) {
                bufferLine.delete(pos, pos + oldMethode.length());
                bufferLine.insert(pos, newMethode);
                pos += newMethode.length();
                continue;
            }
            pos += oldMethode.length();
        }
        if (commMethode != null) {
            this.printlnOut("--> TODO methode a remplacer : " + oldMethode + " , ligne " + indiceLine, true);
            bufferLine.insert(bufferLine.length(), "<br /><br />/* TODO MIGRATION remplacer " + oldMethode + "<br /><br />" + this.propsMigration.getProperty("methode." + this.listeMethode.get(indAttrib) + ".commentaire") + "<br /><br />*/");
            stringBuffer.append("<br />--> TODO , ligne ").append(indiceLine).append(" , m\u00e9thode ").append(oldMethode);
        } else {
            this.printlnOut("<br />&nbsp;&nbsp;&nbsp;--> INFO methode migree : " + newMethode + " , ligne " + indiceLine, true);
            stringBuffer.append("<br />--> INFO methode migree : ").append(newMethode).append(" , ligne ").append(indiceLine);
        }
        return bufferLine.toString();
    }

    public Properties getPropsMigration() {
        return this.propsMigration;
    }

    public void setPropsMigration(Properties propsMigration) {
        this.propsMigration = propsMigration;
    }

    public void setOut(JspWriter out) {
        this.out = out;
    }
}

