/*
 * Decompiled with CFR 0.152.
 */
package com.univ.migration;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.collaboratif.om.Fichiergw;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Photo;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.util.RessourceUtil;
import com.univ.utils.FileUtil;
import com.univ.utils.ImageInfo;
import com.univ.utils.PhotoUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class MigrationPhototheque
implements Runnable {
    private static final String LOG_DEBUG = "DEBUG";
    private static final String LOG_ERROR = "ERROR";
    private static final String LOG_INFO = "INFO";
    private static Logger logger = (Logger)LoggerFactory.getLogger(MigrationPhototheque.class);
    private static JspWriter outWriter = null;

    public static void main(String[] args) {
        MigrationPhototheque capture = new MigrationPhototheque();
        Thread thread = new Thread(capture);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception e) {
            logger.error("Echec thread.join()", (Throwable)e);
        }
    }

    public static void migrer(JspWriter out) throws Exception {
        outWriter = out;
        MigrationPhototheque mig = new MigrationPhototheque();
        FileAppender<ILoggingEvent> appender = mig.initialisationLog();
        mig.migrerPhototheque();
        logger.detachAppender(appender);
    }

    public void migrerPhototheque() throws Exception {
        logger.info("Date D\u00e9but migration phototheque: " + new Date(System.currentTimeMillis()));
        MigrationPhototheque.ecrireLog("DEBUT du traitement ...", LOG_INFO);
        ContextePage ctx = new ContextePage("");
        ctx.setConnectionLongue(true);
        MigrationPhototheque.migrerPhotos(ctx);
        MigrationPhototheque.migrerFichiergw(ctx);
        MigrationPhototheque.migrerReferenceAuMedia(ctx);
        MigrationPhototheque.ecrireLog("FIN du traitement.", LOG_INFO);
        ctx.release();
        logger.info("Date fin migration phototheque: " + new Date(System.currentTimeMillis()));
    }

    public static void migrerPhotos(ContextePage ctx) throws Exception {
        MigrationPhototheque.ecrireLog("*** Migration des photos en medias de type photo ***", LOG_INFO);
        int nbModifs = 0;
        int nbErreur = 0;
        int nbMigres = 0;
        String repertoire = MediathequeHelper.getAbsolutePath();
        File fRepertoire = new File(repertoire);
        if (!fRepertoire.exists()) {
            fRepertoire.mkdir();
        }
        if (!(fRepertoire = new File(repertoire = repertoire + File.separator + "photo")).exists()) {
            fRepertoire.mkdir();
        }
        Photo photo = new Photo();
        photo.init();
        photo.setCtx(ctx);
        String sRepertoirePhotoOld = "";
        photo.select("");
        while (photo.nextItem()) {
            try {
                sRepertoirePhotoOld = "";
                boolean isAlreadySync = false;
                Media media = new Media();
                media.setCtx(ctx);
                media.init();
                media.setIdMedia(photo.getIdPhoto());
                media.setTitre(photo.getTitre());
                media.setLegende(photo.getLegende());
                media.setDescription(photo.getDescription());
                String url = photo.getUrl();
                sRepertoirePhotoOld = url.substring(0, url.indexOf("/") + 1);
                if (url.endsWith("gif") || url.endsWith("GIF")) {
                    media.setFormat("image/gif");
                } else {
                    media.setFormat("image/jpeg");
                }
                url = url.substring(url.indexOf("/") + 1);
                media.setUrl(url);
                media.setSource(url);
                media.setIsMutualise("0");
                media.setTypeRessource("photo");
                media.setTypeMedia(photo.getTypePhoto());
                media.setCodeRubrique(photo.getCodeRubrique());
                media.setCodeRattachement(photo.getCodeStructure());
                media.setUrlVignette("");
                media.setCodeRedacteur(photo.getCodeRedacteur());
                media.setDateCreation(photo.getDateCreation());
                media.setMetaKeywords(photo.getMetaKeywords());
                String sDatas = "";
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(sDatas.getBytes()));
                properties.setProperty("LARGEUR", photo.getLargeur().toString());
                properties.setProperty("HAUTEUR", photo.getHauteur().toString());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                properties.store(baos, "");
                sDatas = baos.toString();
                media.setSpecificData(sDatas);
                Hashtable<String, String> hLangue = LangueUtil.getListeLangues();
                sDatas = "";
                properties = new Properties();
                properties.load(new ByteArrayInputStream(sDatas.getBytes()));
                if (hLangue.containsKey("0")) {
                    hLangue.remove("0");
                }
                String sMetaKeywords = photo.getMetaKeywords();
                if (hLangue.size() > 0) {
                    String sLangue = "";
                    String sLg = "";
                    int idxDebut = 0;
                    int idxFin = 0;
                    Enumeration<String> en = hLangue.keys();
                    while (en.hasMoreElements()) {
                        sLg = en.nextElement();
                        idxDebut = sMetaKeywords.indexOf("[" + sLg);
                        if (idxDebut != -1) {
                            idxFin = sMetaKeywords.indexOf("]", idxDebut);
                            if (idxFin == -1) continue;
                            sLangue = sMetaKeywords.substring(idxDebut + 1, idxFin);
                            sMetaKeywords = sMetaKeywords.substring(0, idxDebut) + sMetaKeywords.substring(idxFin + 1, sMetaKeywords.length());
                            String[] itemLg = sLangue.split("/", -2);
                            if (itemLg.length == 3) {
                                properties.setProperty("LEGENDE_" + sLg, itemLg[1]);
                                properties.setProperty("DESCRIPTION_" + sLg, itemLg[2]);
                                continue;
                            }
                            properties.setProperty("LEGENDE_" + sLg, "");
                            properties.setProperty("DESCRIPTION_" + sLg, "");
                            continue;
                        }
                        properties.setProperty("LEGENDE_" + sLg, "");
                        properties.setProperty("DESCRIPTION_" + sLg, "");
                    }
                }
                baos = new ByteArrayOutputStream();
                properties.store(baos, "");
                sDatas = baos.toString();
                media.setTraductionData(sDatas);
                File oldPhoto = new File(photo.getPathAbsolu());
                File newMedia = null;
                if (oldPhoto.exists()) {
                    newMedia = new File(media.getPathAbsolu());
                    if (!newMedia.exists()) {
                        int nResCopierFichier = FileUtil.copierFichier(oldPhoto, newMedia);
                        media.setPoids(new Integer(nResCopierFichier / 1024));
                    } else {
                        isAlreadySync = true;
                        ++nbMigres;
                    }
                } else {
                    throw new Exception("fichier " + photo.getPathAbsolu() + " inexistant");
                }
                if (isAlreadySync) continue;
                if (newMedia != null) {
                    try {
                        String critere = PropertyHelper.getCoreProperty("phototheque.vignette");
                        String[] lstLimite = critere.split("/", -2);
                        boolean vignetteOk = false;
                        String PathVignette = PropertyHelper.getCoreProperty("phototheque.path") + File.separator + sRepertoirePhotoOld + "v_" + media.getUrl();
                        File file = new File(PathVignette);
                        if (file.exists()) {
                            ImageInfo ii = new ImageInfo();
                            FileInputStream inpStream = new FileInputStream(PathVignette);
                            ii.setInput(inpStream);
                            ii.check();
                            ii.close();
                            lstLimite = critere.split("/", -2);
                            int largeur = Integer.parseInt(lstLimite[1]);
                            int hauteur = Integer.parseInt(lstLimite[2]);
                            if (ii.getWidth() >= largeur || ii.getHeight() >= hauteur) {
                                FileUtil.copierFichier(file, new File(repertoire + File.separator + "v_" + media.getUrl()));
                                vignetteOk = true;
                            }
                        }
                        if (!vignetteOk) {
                            File fVignette = newMedia;
                            lstLimite = critere.split("/", -2);
                            ImageInfo ii = new ImageInfo();
                            FileInputStream inpStream = new FileInputStream(photo.getPathAbsolu());
                            ii.setInput(inpStream);
                            ii.check();
                            ii.close();
                            int largeur = Integer.parseInt(lstLimite[1]);
                            int hauteur = Integer.parseInt(lstLimite[2]);
                            if (largeur < ii.getWidth() && hauteur < ii.getHeight()) {
                                String extension = FileUtil.getExtension(media.getSource());
                                fVignette = MigrationPhototheque.resize(fVignette.getAbsolutePath(), extension, largeur, hauteur, false);
                                FileUtil.copierFichier(fVignette, new File(repertoire + File.separator + "v_" + media.getUrl()));
                            } else {
                                FileUtil.copierFichier(fVignette, new File(repertoire + File.separator + "v_" + media.getUrl()));
                            }
                        }
                        media.setUrlVignette("v_" + media.getUrl());
                    }
                    catch (Exception e) {
                        MigrationPhototheque.ecrireLog("ERREUR lors de la creation de vignette de la photo " + media.getUrl() + " Exception :" + e, LOG_ERROR);
                    }
                }
                try {
                    media.add();
                    ++nbModifs;
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                MigrationPhototheque.ecrireLog("Erreur sur la photo " + photo.getPathAbsolu() + " : " + e.getMessage(), LOG_ERROR);
                ++nbErreur;
            }
        }
        MigrationPhototheque.ecrireLog(nbModifs + " photo(s) migr\u00e9e(s) ", LOG_INFO);
        MigrationPhototheque.ecrireLog(nbMigres + " photo(s) d\u00e9ja migr\u00e9e(s).", LOG_INFO);
        MigrationPhototheque.ecrireLog(nbErreur + " erreur(s).", LOG_INFO);
    }

    private static void migrerReferenceAuMedia(ContextePage ctx) throws Exception {
        Metatag metaDonnees = new Metatag();
        metaDonnees.setCtx(ctx);
        metaDonnees.init();
        metaDonnees.select("WHERE META_LISTE_REFERENCES LIKE '%[photo;%'");
        while (metaDonnees.nextItem()) {
            String[] listeIdMedia;
            String listeReference = metaDonnees.getMetaListeReferences();
            for (String idMedia : listeIdMedia = StringUtils.substringsBetween((String)listeReference, (String)"[photo;", (String)"]")) {
                MigrationPhototheque.migrerRessource(ctx, metaDonnees, idMedia);
            }
        }
    }

    private static void migrerRessource(OMContext ctx, Metatag metaDonnees, String idMedia) throws Exception {
        if (MigrationPhototheque.isRessourceAMigrer(idMedia)) {
            boolean mediaExist;
            String codeParent = MigrationPhototheque.formaterCodeParent(metaDonnees);
            Ressource ressource = new Ressource();
            ressource.init();
            ressource.setCtx(ctx);
            int nbResultat = ressource.select("WHERE ID_MEDIA=" + idMedia);
            boolean dejaImportee = Boolean.FALSE;
            while (ressource.nextItem() && !dejaImportee) {
                dejaImportee = codeParent.equals(ressource.getCodeParent());
            }
            Media media = new Media();
            media.init();
            media.setCtx(ctx);
            boolean bl = mediaExist = media.select("WHERE ID_MEDIA=" + idMedia) > 0;
            if (!dejaImportee && mediaExist) {
                ressource.init();
                ressource.setIdMedia(Long.valueOf(idMedia));
                ressource.setCodeParent(codeParent);
                ressource.setOrdre(nbResultat);
                ressource.setEtat("1");
                ressource.add();
                MigrationPhototheque.ecrireLog("reference du media " + idMedia + " \u00e0 la fiche " + codeParent + " import\u00e9e", LOG_INFO);
            } else {
                MigrationPhototheque.ecrireLog("reference du media " + idMedia + " \u00e0 la fiche " + codeParent + " d\u00e9j\u00e0 import\u00e9e", LOG_INFO);
            }
        }
    }

    private static String formaterCodeParent(Metatag metaDonnees) {
        return metaDonnees.getMetaIdFiche() + ",TYPE=IMG_" + metaDonnees.getMetaCodeObjet() + ",CODE=" + metaDonnees.getMetaCode();
    }

    private static boolean isRessourceAMigrer(String idMedia) {
        return !idMedia.startsWith("F");
    }

    public static File resize(String path, String format, int newLargeur, int newHauteur, boolean replace) throws Exception {
        BufferedImage bImage;
        File fOld = new File(path);
        File fNew = new File(fOld.getParent(), "tmp_" + System.currentTimeMillis());
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = writers.next();
        BufferedImage image = ImageIO.read(fOld);
        if (!image.equals(bImage = PhotoUtil.scale(image, newLargeur, newHauteur, format))) {
            ImageOutputStream ios = ImageIO.createImageOutputStream(fNew);
            writer.setOutput(ios);
            writer.write(bImage);
            ios.close();
            writer.dispose();
        } else {
            fNew = fOld;
        }
        if (replace) {
            FileUtil.copierFichier(fNew, fOld, true);
            return fOld;
        }
        return fNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrerFichiergw(ContextePage ctx) throws Exception {
        MigrationPhototheque.ecrireLog("*** Migration des fichiergw ***", LOG_INFO);
        int nbModifs = 0;
        int nbMigres = 0;
        int nbErreur = 0;
        Fichiergw f = new Fichiergw();
        f.setCtx(ctx);
        f.init();
        if (f.select("WHERE ETAT = '1' AND TYPE_FICHIER != 'vignette'") > 0) {
            while (f.nextItem()) {
                ContextePage ctx2 = new ContextePage("");
                try {
                    Long idMedia;
                    block41: {
                        idMedia = new Long(0L);
                        Media media = new Media();
                        media.setCtx(ctx2);
                        media.init();
                        MigrationPhototheque.ecrireLog("Migration fichier " + f.getPathAbsolu() + ";IdFichiergw=" + f.getIdFichiergw() + "code=" + f.getCode(), LOG_INFO);
                        if (f.getIdPhoto().equals("")) {
                            try {
                                idMedia = new Long(f.getCode());
                                media.setIdMedia(idMedia);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            media.setTitre(f.getLibelleFichierJoint());
                            media.setLegende("");
                            media.setDescription(f.getCommentaireVersion());
                            media.setFormat(f.getFormatFichierJoint());
                            media.setUrl(f.getPathFichierJoint());
                            media.setSource(f.getNomFichierJoint());
                            media.setIsMutualise("2");
                            media.setCodeRedacteur(f.getAuteurVersion());
                            media.setDateCreation(f.getDateVersion());
                            try {
                                media.setPoids(new Integer(f.getPoidsFichierJoint()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (f.getTypeFichier().equals("fichier") || f.getTypeFichier().equals("document") || f.getTypeFichier().equals("lien")) {
                                media.setTypeRessource("fichier");
                            } else if (f.getTypeFichier().equals("photo") || f.getTypeFichier().equals("image") || f.getTypeFichier().equals("img") || f.getTypeFichier().equals("logo") || f.getTypeFichier().equals("galerie")) {
                                media.setTypeRessource("photo");
                            }
                            if (f.getIdVignette().length() > 0) {
                                Fichiergw vignette = new Fichiergw();
                                vignette.setCtx(ctx2);
                                vignette.init();
                                try {
                                    vignette.setIdFichiergw(new Long(f.getIdVignette()));
                                    vignette.retrieve();
                                    media.setUrlVignette(vignette.getPathFichierJoint());
                                    File file = new File(vignette.getPathAbsolu());
                                    if (file.exists()) {
                                        File file2 = new File(media.getPathVignetteAbsolu());
                                        if (!file2.exists()) {
                                            FileUtil.copierFichier(file, file2);
                                        }
                                    } else {
                                        File file2;
                                        File filePhoto = new File(PropertyHelper.getCoreProperty("phototheque.path") + File.separator + vignette.getPathFichierJoint());
                                        if (filePhoto.exists() && !(file2 = new File(media.getPathVignetteAbsolu())).exists()) {
                                            FileUtil.copierFichier(filePhoto, file2);
                                        }
                                    }
                                }
                                catch (Exception file) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (media.select("WHERE URL='" + media.getUrl() + "'") == 0) {
                                    media.add();
                                    idMedia = media.getIdMedia();
                                    break block41;
                                }
                                media.nextItem();
                                idMedia = media.getIdMedia();
                            }
                            catch (Exception vignette) {}
                        } else {
                            try {
                                media.setIdMedia(new Long(f.getIdPhoto()));
                                media.retrieve();
                                idMedia = media.getIdMedia();
                            }
                            catch (Exception vignette) {
                                // empty catch block
                            }
                        }
                    }
                    if (!idMedia.equals(new Long(0L))) {
                        boolean objetParentExiste = Boolean.FALSE;
                        Ressource ressource = new Ressource();
                        ressource.setCtx(ctx2);
                        ressource.init();
                        if (f.getCodeParent().matches("^([0-9]+)(,TYPE=)([0-9]+)$")) {
                            ressource.setCodeParent(f.getCodeParent() + ",NO=1");
                        } else {
                            ressource.setCodeParent(f.getCodeParent());
                        }
                        ressource.setEtat(f.getEtat());
                        ressource.setIdMedia(idMedia);
                        try {
                            ressource.setOrdre(new Integer(f.getNumeroVersion()));
                        }
                        catch (Exception filePhoto) {
                            // empty catch block
                        }
                        String codeParent = ressource.getCodeParent();
                        FicheUniv ficheUniv = null;
                        if (MigrationPhototheque.isAppartientAFicheUniv(ressource).booleanValue() && MigrationPhototheque.isFichierAImporter(ressource.getEtat())) {
                            String idFiche = codeParent.substring(0, codeParent.indexOf(","));
                            String typeObjet = MigrationPhototheque.recupererTypeFicheParent(codeParent);
                            ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(typeObjet));
                            try {
                                if (ficheUniv != null) {
                                    ficheUniv.setCtx(ctx2);
                                    ficheUniv.init();
                                    ficheUniv.setIdFiche(new Long(idFiche));
                                    ficheUniv.retrieve();
                                    objetParentExiste = Boolean.TRUE;
                                }
                            }
                            catch (Exception e) {
                                MigrationPhototheque.ecrireLog("Erreur lors du test de l'existence de la FicheUniv : " + idFiche + " Exception: " + e + "Class=" + ficheUniv.getClass(), LOG_ERROR);
                            }
                        } else if (MigrationPhototheque.isFichierEspaceCollaboratif(codeParent) && MigrationPhototheque.isFichierAImporter(ressource.getEtat())) {
                            Espacecollaboratif espaceParent = Espacecollaboratif.getEspace(MigrationPhototheque.getCodeEspaceCollaboratif(codeParent));
                            boolean bl = objetParentExiste = espaceParent != null;
                        }
                        if (ressource.select("WHERE CODE_PARENT='" + ressource.getCodeParent() + "' AND ID_MEDIA='" + idMedia + "' ") == 0 && objetParentExiste) {
                            ressource.add();
                            MigrationPhototheque.ecrireLog("=> OK", LOG_INFO);
                            ++nbModifs;
                            continue;
                        }
                        if (!objetParentExiste) continue;
                        MigrationPhototheque.ecrireLog("=> d\u00e9ja migr\u00e9", LOG_INFO);
                        ++nbMigres;
                        continue;
                    }
                    MigrationPhototheque.ecrireLog("=> fichiergw code 0, pas de creation de media ", LOG_INFO);
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        ++nbMigres;
                        MigrationPhototheque.ecrireLog("=> d\u00e9ja migr\u00e9", LOG_INFO);
                        continue;
                    }
                    MigrationPhototheque.ecrireLog("Erreur sur le fichier " + f.getPathAbsolu() + " : " + e.getMessage(), LOG_ERROR);
                    ++nbErreur;
                }
                finally {
                    if (ctx2 == null) continue;
                    ctx2.release();
                }
            }
        }
        MigrationPhototheque.ecrireLog(nbModifs + " fichiergw(s) migr\u00e9(s).", LOG_INFO);
        MigrationPhototheque.ecrireLog(nbMigres + " fichiergw(s) d\u00e9ja migre(s).", LOG_INFO);
        MigrationPhototheque.ecrireLog(nbErreur + " erreur(s).", LOG_INFO);
    }

    private static String getCodeEspaceCollaboratif(String codeParent) {
        String codeEspace = null;
        String[] codeParentSpliter = codeParent.split(",");
        if (codeParentSpliter.length > 0) {
            codeEspace = codeParentSpliter[0];
        }
        return codeEspace;
    }

    private static Boolean isAppartientAFicheUniv(Ressource ressource) {
        String codeParent = ressource.getCodeParent();
        return StringUtils.isNotEmpty((CharSequence)codeParent) && !codeParent.startsWith("TYPE") && !MigrationPhototheque.isFichierEspaceCollaboratif(codeParent);
    }

    private static boolean isFichierAImporter(String etat) {
        return !"0".equals(etat) && !"2".equals(etat);
    }

    private static boolean isFichierEspaceCollaboratif(String codeParent) {
        return codeParent.contains("LOGO_ESPACE");
    }

    private static String recupererTypeFicheParent(String codeParent) {
        String typeObjet = codeParent.substring(codeParent.indexOf("TYPE=") + 5);
        if (typeObjet.length() > 4) {
            if (typeObjet.indexOf("_") != -1) {
                typeObjet = typeObjet.substring(typeObjet.indexOf("_") + 1, typeObjet.indexOf("_") + 5);
            }
            if (typeObjet.indexOf(",") != -1) {
                typeObjet = typeObjet.substring(0, typeObjet.indexOf(","));
            }
        }
        return typeObjet;
    }

    public static void migrerVignette(JspWriter out, ContextePage ctx) throws Exception {
        out.println("<br />*** Migration des vignettes ***<br />");
        out.flush();
        int nbModifs = 0;
        int nbMigres = 0;
        int nbErreur = 0;
        Media media = new Media();
        media.setCtx(ctx);
        media.init();
        String newPath = "";
        String oldPath = "";
        String mediathequePath = MediathequeHelper.getAbsolutePath();
        String fichiergwPath = RessourceUtil.getAbsolutePath();
        if (media.select("WHERE URL_VIGNETTE != ''") > 0) {
            while (media.nextItem()) {
                newPath = "";
                oldPath = "";
                try {
                    File fileCible;
                    newPath = mediathequePath;
                    if (media.getTypeRessource().length() > 0) {
                        newPath = newPath + "/" + media.getTypeRessource().toLowerCase();
                    }
                    if (!(fileCible = new File(newPath = newPath + "/" + media.getUrlVignette())).exists()) {
                        oldPath = fichiergwPath + "/" + media.getUrlVignette();
                        File fileOrig = new File(oldPath);
                        if (fileOrig.exists()) {
                            FileUtil.copierFichier(fileOrig, fileCible);
                            ++nbModifs;
                        } else {
                            ++nbErreur;
                            out.println("Erreur vignette inexistante : " + fileOrig + "<br />");
                            out.flush();
                        }
                    }
                }
                catch (Exception e) {
                    ++nbErreur;
                    out.println("Erreur " + e.getMessage() + "<br />");
                    out.flush();
                }
                ++nbMigres;
            }
        }
        out.println(nbModifs + " vignette(s) d\u00e9plac\u00e9e(s) sur un total de " + nbMigres + "<br />");
        out.println(nbErreur + " erreur(s).<br />");
        out.flush();
    }

    @Override
    public void run() {
        try {
            FileAppender<ILoggingEvent> appender = this.initialisationLog();
            this.migrerPhototheque();
            logger.detachAppender(appender);
        }
        catch (Exception e) {
            logger.error("Erreur lors du traitement de migration > Message :" + e.getMessage() + "StackTrace :");
        }
    }

    private FileAppender<ILoggingEvent> initialisationLog() throws Exception {
        FileAppender appender = null;
        String sFileLog = "";
        try {
            String logPath = WebAppUtil.getLogsPath();
            sFileLog = logPath + File.separator + "MigrationPhototheque.log";
            appender = new FileAppender();
            appender.setFile(sFileLog);
            appender.setEncoder((Encoder)new PatternLayoutEncoder());
            appender.setAppend(false);
            logger.detachAndStopAllAppenders();
            logger.addAppender((Appender)appender);
        }
        catch (Exception e) {
            logger.error("Erreur lors du traitement de migration > Message :" + e.getMessage() + "StackTrace :");
        }
        return appender;
    }

    private static void ecrireLog(String sTexteLog, String sMode) throws Exception {
        if (outWriter != null) {
            outWriter.println(sTexteLog + "<br />");
            outWriter.flush();
        }
        if (sMode.equals(LOG_INFO)) {
            logger.info(sTexteLog);
        } else if (sMode.equals(LOG_ERROR)) {
            logger.error(sTexteLog);
        } else if (sMode.equals(LOG_DEBUG)) {
            logger.debug(sTexteLog);
        }
    }

    public static void setOutWriter(JspWriter outWriter) {
        MigrationPhototheque.outWriter = outWriter;
    }
}

