/*
 * Decompiled with CFR 0.152.
 */
package com.univ.migration;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.jsbsoft.jtf.database.SOSJDBCProxy;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.util.RessourceUtil;
import com.univ.utils.FileUtil;
import java.io.File;
import java.util.Date;
import javax.servlet.jsp.JspWriter;
import org.slf4j.LoggerFactory;

public class MigrationRessources
implements Runnable {
    private static Logger logger = (Logger)LoggerFactory.getLogger(MigrationRessources.class);
    private static JspWriter OutWriter = null;

    public static void main(String[] args) {
        MigrationRessources capture = new MigrationRessources();
        Thread thread = new Thread(capture);
        thread.start();
        try {
            thread.join();
        }
        catch (Exception e) {
            logger.error("Echec thread.join()", (Throwable)e);
        }
    }

    public static void migrer(JspWriter out) throws Exception {
        OutWriter = out;
        MigrationRessources mig = new MigrationRessources();
        FileAppender<ILoggingEvent> appender = mig.initialisationLog();
        mig.securiserAll();
        logger.detachAppender(appender);
    }

    public void securiserAll() throws Exception {
        MigrationRessources.ecrireLog("D\u00e9but traitement securisation ressources : " + new Date(System.currentTimeMillis()), "INFO");
        ContextePage ctx = new ContextePage("");
        ctx.setConnectionLongue(true);
        String pathFichierSecurise = RessourceUtil.getAbsolutePath();
        String pathMediaPublic = MediathequeHelper.getAbsolutePath();
        int compteurPrive = 0;
        int compteurPublic = 0;
        int erreur = 0;
        Mediatheque mediatheque = Mediatheque.getInstance();
        for (String type : mediatheque.getTypesMedia().keySet()) {
            File destination;
            File source;
            Media media;
            String secure = PropertyHelper.getCoreProperty("mediatheque.secure." + type.toLowerCase());
            if ("2".equals(secure)) {
                media = new Media();
                media.init();
                media.setCtx(ctx);
                media.select("WHERE TYPE_RESSOURCE='" + type.toLowerCase() + "' AND IS_MUTUALISE NOT IN ('0','2')");
                while (media.nextItem()) {
                    try {
                        if (!media.isLocal() || !(source = new File(media.getPathAbsolu())).exists()) continue;
                        destination = new File(pathFichierSecurise + "/" + media.getUrl());
                        FileUtil.copierFichier(source, destination);
                        if (!destination.exists()) continue;
                        source.delete();
                        media.setIsMutualise("2");
                        media.update();
                        ++compteurPrive;
                    }
                    catch (Exception e) {
                        ++erreur;
                        MigrationRessources.ecrireLog("Erreur copie fichier " + media.getPathAbsolu(), "ERROR");
                    }
                }
            } else if ("1".equals(secure)) {
                media = new Media();
                media.init();
                media.setCtx(ctx);
                media.select("WHERE TYPE_RESSOURCE='" + type.toLowerCase() + "' AND IS_MUTUALISE NOT IN ('0','1')");
                while (media.nextItem()) {
                    try {
                        if (!media.isLocal() || !(source = new File(media.getPathAbsolu())).exists()) continue;
                        destination = new File(pathMediaPublic + "/" + media.getTypeRessource().toLowerCase() + "/" + media.getUrl());
                        FileUtil.copierFichier(source, destination);
                        if (!destination.exists()) continue;
                        source.delete();
                        media.setIsMutualise("1");
                        media.update();
                        ++compteurPublic;
                    }
                    catch (Exception e) {
                        ++erreur;
                        MigrationRessources.ecrireLog("Erreur copie fichier " + media.getPathAbsolu(), "ERROR");
                    }
                }
            }
            SOSJDBCProxy.cleanConnection(ctx.getConnection());
        }
        MigrationRessources.ecrireLog("Bilan", "INFO");
        MigrationRessources.ecrireLog(compteurPrive + " ressource(s) s\u00e9curis\u00e9e(s)", "INFO");
        MigrationRessources.ecrireLog(compteurPublic + " ressource(s) rendue(s) publique(s)", "INFO");
        MigrationRessources.ecrireLog(erreur + " erreur(s)", "INFO");
        ctx.release();
        MigrationRessources.ecrireLog("Fin traitement securisation ressources : " + new Date(System.currentTimeMillis()), "INFO");
    }

    protected void moveFile(String destinationPath) {
    }

    @Override
    public void run() {
        try {
            FileAppender<ILoggingEvent> appender = this.initialisationLog();
            this.securiserAll();
            logger.detachAppender(appender);
        }
        catch (Exception e) {
            logger.error("Erreur lors du traitement de migration > Message :" + e.getMessage() + "StackTrace :");
        }
    }

    private FileAppender<ILoggingEvent> initialisationLog() throws Exception {
        FileAppender appender = null;
        String sFileLog = "";
        try {
            String logPath = WebAppUtil.getLogsPath();
            sFileLog = logPath + File.separator + "migrationRessource.log";
            appender = new FileAppender();
            appender.setEncoder((Encoder)new PatternLayoutEncoder());
            appender.setAppend(false);
            appender.setFile(sFileLog);
            logger.detachAndStopAllAppenders();
            logger.setAdditive(false);
            logger.addAppender((Appender)appender);
        }
        catch (Exception e) {
            logger.error("Erreur initialisation fichier de log migrationRessource.log");
        }
        return appender;
    }

    private static void ecrireLog(String sTexteLog, String sMode) throws Exception {
        if (OutWriter != null) {
            OutWriter.println(sTexteLog + "<br />");
            OutWriter.flush();
        }
        if (sMode.equals("INFO")) {
            logger.info(sTexteLog);
        } else if (sMode.equals("ERROR")) {
            logger.error(sTexteLog);
        } else if (sMode.equals("DEBUG")) {
            logger.debug(sTexteLog);
        }
    }
}

