/*
 * Decompiled with CFR 0.152.
 */
package com.univ.multisites;

import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class InfosSite
implements Serializable {
    private static final long serialVersionUID = 748460367842507382L;
    public static final String HTTPHOSTNAME_DEFAUT = "";
    public static final String HTTPSHOSTNAME_DEFAUT = "";
    public static final String JSPFO_DEFAUT = "/jsp";
    public static final int HTTPPORT_DEFAUT = -1;
    public static final int HTTPSPORT_DEFAUT = -1;
    public static final int SSLMODE_DEFAUT = 0;
    public static final int BOSSLMODE_DEFAUT = 0;
    public static final int RESTRICTION_DEFAUT = 0;
    public static final int NIVEAUMINREECRITURERUBRIQUE_DEFAUT = 0;
    public static final int NIVEAUMAXREECRITURERUBRIQUE_DEFAUT = 100;
    public static final int MODEREECRITURERUBRIQUE_DEFAUT = 0;
    public static Set<Integer> HTTPACTIONS_SET_DEFAUT = Collections.emptySet();
    public static Set<Integer> HTTPSACTIONS_SET_DEFAUT = Collections.emptySet();
    public static boolean SSO_DEFAUT = Boolean.FALSE;
    protected long idInfosSite = 0L;
    protected String alias = "";
    protected String intitule = "";
    protected String httpHostname = "";
    protected String urlAccueil = "";
    protected int httpPort = -1;
    protected String httpsHostname = "";
    protected int httpsPort = -1;
    protected int sslMode = 0;
    protected Set<Integer> httpActionsSet = HTTPACTIONS_SET_DEFAUT;
    protected Set<Integer> httpsActionsSet = HTTPSACTIONS_SET_DEFAUT;
    protected int boSslMode = 0;
    protected String codeRubrique = "";
    protected int restriction = 0;
    protected Set<String> listeHostAlias = new HashSet<String>();
    protected int niveauMinReecritureRubrique = 0;
    protected int niveauMaxReecritureRubrique = 100;
    protected int modeReecritureRubrique = 0;
    protected String jspFo = "/jsp";
    protected boolean sso = SSO_DEFAUT;
    protected boolean isSitePrincipal = Boolean.FALSE;
    protected Map<String, Object> proprietesComplementaires = new HashMap<String, Object>();
    protected boolean isActif = Boolean.TRUE;
    protected String codeTemplate = "";
    protected Date dateCreation = new Date();
    protected Date dateDerniereModification = new Date();
    protected String codeCreateur = "";
    protected String codeDernierModificateur = "";
    protected transient String historique = "";

    public long getIdInfosSite() {
        return this.idInfosSite;
    }

    public Set<Integer> getHttpActionsSet() {
        return this.httpActionsSet;
    }

    public Set<Integer> getHttpsActionsSet() {
        return this.httpsActionsSet;
    }

    public Map<String, Object> getProprietesComplementaires() {
        return this.proprietesComplementaires;
    }

    public boolean isActif() {
        return this.isActif;
    }

    public String getCodeTemplate() {
        return this.codeTemplate;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateDerniereModification() {
        return this.dateDerniereModification;
    }

    public String getCodeCreateur() {
        return this.codeCreateur;
    }

    public String getCodeDernierModificateur() {
        return this.codeDernierModificateur;
    }

    public String getHistorique() {
        return this.historique;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getIntitule() {
        return this.intitule;
    }

    public String getHttpHostname() {
        return this.httpHostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getHttpsHostname() {
        return this.httpsHostname == null ? this.httpHostname : this.httpsHostname;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getSslMode() {
        return this.sslMode;
    }

    public boolean isHttpAction(int action) {
        return this.httpActionsSet.contains(new Integer(action));
    }

    public boolean isHttpsAction(int action) {
        return this.httpsActionsSet.contains(new Integer(action));
    }

    public int getBoSslMode() {
        return this.boSslMode;
    }

    public String getCodeRubrique() {
        return this.codeRubrique;
    }

    public int getRestriction() {
        return this.restriction;
    }

    public Set<String> getListeHostAlias() {
        return this.listeHostAlias;
    }

    public int getNiveauMaxReecritureRubrique() {
        return this.niveauMaxReecritureRubrique;
    }

    public int getNiveauMinReecritureRubrique() {
        return this.niveauMinReecritureRubrique;
    }

    public int getModeReecritureRubrique() {
        return this.modeReecritureRubrique;
    }

    @Deprecated
    public String getUrlAccueil() {
        return this.urlAccueil;
    }

    public String getJspFo() {
        return this.jspFo;
    }

    public boolean isSso() {
        return this.sso;
    }

    public boolean isSitePrincipal() {
        return this.isSitePrincipal;
    }

    public Set<Integer> getHttpActions() {
        return this.httpActionsSet;
    }

    public Set<Integer> getHttpsActions() {
        return this.httpsActionsSet;
    }

    public Object getProprieteComplementaire(String nomPropriete) {
        if (this.proprietesComplementaires == null) {
            return null;
        }
        return this.proprietesComplementaires.get(nomPropriete);
    }

    public String getProprieteComplementaireString(String nomPropriete) {
        if (this.proprietesComplementaires == null) {
            return null;
        }
        Object valeur = this.proprietesComplementaires.get(nomPropriete);
        if (valeur != null && valeur instanceof String) {
            return (String)valeur;
        }
        return null;
    }

    public List<String> getProprieteComplementaireListString(String nomPropriete) {
        if (this.proprietesComplementaires == null) {
            return null;
        }
        Object valeur = this.proprietesComplementaires.get(nomPropriete);
        if (valeur != null && valeur instanceof List) {
            return (List)valeur;
        }
        if (valeur != null && valeur instanceof String) {
            return Arrays.asList(String.valueOf(valeur));
        }
        return null;
    }

    public boolean isRubriqueVisibleInSite(InfosRubriques rubrique) {
        String codeRubrique = this.getCodeRubrique();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            InfosRubriques rubriqueSite = Rubrique.renvoyerItemRubrique(codeRubrique);
            return rubriqueSite.contains(rubrique);
        }
        return Boolean.FALSE;
    }
}

