/*
 * Decompiled with CFR 0.152.
 */
package com.univ.multisites;

import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.objetspartages.cache.CacheInfosSiteManager;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Site {
    public static Map<String, InfosSite> getListeInfosSites() {
        Map<String, InfosSite> infosSiteParCode = CacheInfosSiteManager.getDonneesSites().getInfosSitesParCode();
        if (infosSiteParCode == null) {
            infosSiteParCode = Collections.emptyMap();
        }
        return infosSiteParCode;
    }

    public static InfosSite getSitePrincipal() {
        return CacheInfosSiteManager.getDonneesSites().getSitePrincipal();
    }

    public static InfosSite renvoyerItemSiteParRubrique(String rubrique) {
        Map<String, InfosSite> infosSiteParRubrique = CacheInfosSiteManager.getDonneesSites().getInfosSitesParCodeRubrique();
        if (infosSiteParRubrique == null) {
            infosSiteParRubrique = Collections.emptyMap();
        }
        return infosSiteParRubrique.get(rubrique);
    }

    public static InfosSite renvoyerItemSite(String alias) {
        InfosSite itemSite;
        Map<String, InfosSite> infosSiteParCode = CacheInfosSiteManager.getDonneesSites().getInfosSitesParCode();
        if (infosSiteParCode == null) {
            infosSiteParCode = Collections.emptyMap();
        }
        if ((itemSite = infosSiteParCode.get(alias)) == null) {
            itemSite = Site.getSitePrincipal();
        }
        return itemSite;
    }

    public static InfosSite renvoyerItemSiteParHost(String host) {
        InfosSite siteParHost;
        Map<String, InfosSite> infosSiteParHost = CacheInfosSiteManager.getDonneesSites().getInfosSitesParHost();
        if (infosSiteParHost == null) {
            infosSiteParHost = Collections.emptyMap();
        }
        if ((siteParHost = infosSiteParHost.get(host)) == null) {
            siteParHost = new InfosSiteImpl();
        }
        return siteParHost;
    }

    public static InfosSite determinerSiteRubrique(String codeRubrique, boolean renvoyerSiteGlobal) {
        if (StringUtils.isEmpty((CharSequence)codeRubrique)) {
            return null;
        }
        InfosRubriques infosRubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
        while (infosRubrique.getNiveau() > 0) {
            String codeRubriqueCourante = infosRubrique.getCode();
            InfosSite infosSiteRubrique = CacheInfosSiteManager.getDonneesSites().getInfosSitesParCodeRubrique().get(codeRubriqueCourante);
            if (infosSiteRubrique == null) {
                infosRubrique = infosRubrique.getRubriqueMere();
                continue;
            }
            return infosSiteRubrique;
        }
        if (renvoyerSiteGlobal) {
            return Site.getSitePrincipal();
        }
        return null;
    }

    public static InfosSite determinerSiteRubrique(String codeRubrique) {
        return Site.determinerSiteRubrique(codeRubrique, true);
    }

    @Deprecated
    public static InfosSite getSiteGlobal() {
        return CacheInfosSiteManager.getDonneesSites().getSiteGlobal();
    }

    public static ArrayList<String> getListeCompleteHostsEtAlias() {
        return new ArrayList<String>(CacheInfosSiteManager.getDonneesSites().getUrlsDefinis());
    }
}

