/*
 * Decompiled with CFR 0.152.
 */
package com.univ.multisites.dao.impl;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.multisites.dao.InfosSiteDao;
import com.univ.multisites.helper.InfosSitePropertiesHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfosSiteDaoProperties
implements InfosSiteDao {
    private static final Logger LOG = LoggerFactory.getLogger(InfosSiteDaoProperties.class);
    private static final Object LOCK = new Object();

    @Override
    public InfosSite getInfosSite(String code) throws Exception {
        String codeTemplate;
        String jspFO;
        String siteRubrique;
        List httpsAction;
        List httpAction;
        List listeAliasHostsSite;
        String httpsHost;
        String httpHost;
        InfosSiteImpl infosSite = new InfosSiteImpl();
        PropertiesConfiguration propsConfig = InfosSiteDaoProperties.getPropertiesConfiguration(code);
        if (propsConfig.isEmpty()) {
            throw new ErreurDonneeNonTrouve("Aucun site ne correspond au code " + code);
        }
        String proprieteSite = "site." + code;
        String intitule = propsConfig.getString(proprieteSite + ".intitule");
        if (StringUtils.isNotEmpty((CharSequence)intitule)) {
            infosSite.setIntitule(intitule);
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpHost = propsConfig.getString(proprieteSite + ".host")))) {
            infosSite.setHttpHostname(httpHost);
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpsHost = propsConfig.getString(proprieteSite + ".https_host")))) {
            infosSite.setHttpsHostname(httpsHost);
        }
        if (CollectionUtils.isNotEmpty((Collection)(listeAliasHostsSite = propsConfig.getList(proprieteSite + ".alias")))) {
            infosSite.setListeHostAlias(new HashSet<String>(listeAliasHostsSite));
        }
        if (CollectionUtils.isNotEmpty((Collection)(httpAction = propsConfig.getList(proprieteSite + ".http_actions")))) {
            SortedSet<Integer> listeActions = InfosSitePropertiesHelper.transformListActionsToSet(httpAction);
            infosSite.setHttpActions(listeActions);
        }
        if (CollectionUtils.isNotEmpty((Collection)(httpsAction = propsConfig.getList(proprieteSite + ".https_actions")))) {
            SortedSet<Integer> listeActions = InfosSitePropertiesHelper.transformListActionsToSet(httpsAction);
            infosSite.setHttpsActions(listeActions);
        }
        if (StringUtils.isNotEmpty((CharSequence)(siteRubrique = propsConfig.getString(proprieteSite + ".rubrique")))) {
            infosSite.setCodeRubrique(siteRubrique);
        } else {
            infosSite.setCodeRubrique("");
        }
        String siteURLAccueil = propsConfig.getString(proprieteSite + ".url_accueil");
        if (StringUtils.isNotEmpty((CharSequence)siteURLAccueil)) {
            infosSite.setUrlAccueil(siteURLAccueil);
        }
        if (StringUtils.isNotEmpty((CharSequence)(jspFO = propsConfig.getString(proprieteSite + ".jsp_fo")))) {
            infosSite.setJspFo(StringUtils.removeEnd((String)jspFO, (String)"/"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(codeTemplate = propsConfig.getString(proprieteSite + ".code_template")))) {
            infosSite.setCodeTemplate(codeTemplate);
        }
        infosSite.setAlias(code);
        infosSite.setHttpPort(propsConfig.getInt(proprieteSite + ".port", -1));
        infosSite.setHttpsPort(propsConfig.getInt(proprieteSite + ".https_port", -1));
        infosSite.setSslMode(propsConfig.getInt(proprieteSite + ".ssl_mode", 0));
        infosSite.setBoSslMode(propsConfig.getInt(proprieteSite + ".bo.ssl_mode", 0));
        infosSite.setNiveauMinReecritureRubrique(propsConfig.getInt(proprieteSite + ".reecriture_rubrique_min", 0));
        infosSite.setNiveauMaxReecritureRubrique(propsConfig.getInt(proprieteSite + ".reecriture_rubrique_max", 100));
        infosSite.setModeReecritureRubrique(propsConfig.getInt(proprieteSite + ".reecriture_rubrique_mode", 0));
        infosSite.setRestriction(propsConfig.getInt(proprieteSite + ".restriction", 0));
        infosSite.setSso(propsConfig.getBoolean(proprieteSite + ".sso"));
        infosSite.setSitePrincipal(propsConfig.getBoolean(proprieteSite + ".principal"));
        infosSite.setActif(propsConfig.getBoolean(proprieteSite + ".actif"));
        this.setListeProprietesComplementairesDansInfosSite(infosSite, propsConfig);
        return infosSite;
    }

    @Override
    public Collection<InfosSite> getListeInfosSites() throws Exception {
        ArrayList<InfosSite> infosSites = new ArrayList<InfosSite>();
        Iterator tousLesSites = FileUtils.iterateFiles((File)new File(InfosSitePropertiesHelper.getCheminDossiersProperties()), (String[])new String[]{"properties"}, (boolean)Boolean.FALSE);
        while (tousLesSites.hasNext()) {
            File fichierCourant = (File)tousLesSites.next();
            try {
                infosSites.add(this.getInfosSite(FilenameUtils.getBaseName((String)fichierCourant.getName())));
            }
            catch (Exception e) {
                LOG.error("impossible de charger la configuration : " + fichierCourant.getName(), (Throwable)e);
            }
        }
        return infosSites;
    }

    @Override
    public void creer(InfosSite infosSite) throws Exception {
        File fichierUAS = new File(InfosSitePropertiesHelper.getCheminDossiersProperties() + infosSite.getAlias() + ".properties");
        if (fichierUAS.exists()) {
            throw new ErreursSaisieInfosSite("le site existe d\u00e9j\u00e0");
        }
        this.sauvegardeProperties(infosSite);
    }

    @Override
    public void miseAJour(InfosSite infosSite) throws Exception {
        this.sauvegardeProperties(infosSite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimer(String code) throws Exception {
        File fichierUAS = new File(InfosSitePropertiesHelper.getCheminDossiersProperties() + code + ".properties");
        Object object = LOCK;
        synchronized (object) {
            fichierUAS.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertiesConfiguration getPropertiesConfiguration(String code) throws ConfigurationException {
        PropertiesConfiguration propsConfig = null;
        Object object = LOCK;
        synchronized (object) {
            AbstractConfiguration.setDefaultListDelimiter((char)';');
            propsConfig = new PropertiesConfiguration(new File(InfosSitePropertiesHelper.getCheminDossiersProperties() + code + ".properties"));
            propsConfig.setEncoding("UTF-8");
        }
        return propsConfig;
    }

    private void setListeProprietesComplementairesDansInfosSite(InfosSiteImpl infosSite, PropertiesConfiguration propsConfig) {
        String debutCleProprieteSite = "site." + infosSite.getAlias() + ".";
        Iterator ensembleProprietes = propsConfig.getKeys();
        while (ensembleProprietes.hasNext()) {
            String cleProprieteSite;
            String clePropriete = (String)ensembleProprietes.next();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)clePropriete, (CharSequence)debutCleProprieteSite) || !StringUtils.isNotEmpty((CharSequence)(cleProprieteSite = StringUtils.removeStartIgnoreCase((String)clePropriete, (String)debutCleProprieteSite))) || InfosSitePropertiesHelper.FinNomProprieteSite.isProprieteSite(cleProprieteSite)) continue;
            infosSite.putProperty(cleProprieteSite, propsConfig.getProperty(clePropriete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sauvegardeProperties(InfosSite infosSite) throws ErreurApplicative {
        try {
            PropertiesConfiguration propsConfig = InfosSiteDaoProperties.getPropertiesConfiguration(infosSite.getAlias());
            String proprieteSite = "site." + infosSite.getAlias();
            propsConfig.setProperty(proprieteSite + ".intitule", (Object)infosSite.getIntitule());
            propsConfig.setProperty(proprieteSite + ".host", (Object)infosSite.getHttpHostname());
            propsConfig.setProperty(proprieteSite + ".https_host", (Object)infosSite.getHttpsHostname());
            propsConfig.setProperty(proprieteSite + ".alias", infosSite.getListeHostAlias());
            propsConfig.setProperty(proprieteSite + ".port", (Object)infosSite.getHttpPort());
            propsConfig.setProperty(proprieteSite + ".https_port", (Object)infosSite.getHttpsPort());
            propsConfig.setProperty(proprieteSite + ".ssl_mode", (Object)infosSite.getSslMode());
            propsConfig.setProperty(proprieteSite + ".bo.ssl_mode", (Object)infosSite.getBoSslMode());
            propsConfig.setProperty(proprieteSite + ".http_actions", infosSite.getHttpActions());
            propsConfig.setProperty(proprieteSite + ".https_actions", infosSite.getHttpsActions());
            propsConfig.setProperty(proprieteSite + ".rubrique", (Object)infosSite.getCodeRubrique());
            propsConfig.setProperty(proprieteSite + ".reecriture_rubrique_min", (Object)infosSite.getNiveauMinReecritureRubrique());
            propsConfig.setProperty(proprieteSite + ".reecriture_rubrique_max", (Object)infosSite.getNiveauMaxReecritureRubrique());
            propsConfig.setProperty(proprieteSite + ".reecriture_rubrique_mode", (Object)infosSite.getModeReecritureRubrique());
            propsConfig.setProperty(proprieteSite + ".url_accueil", (Object)infosSite.getUrlAccueil());
            propsConfig.setProperty(proprieteSite + ".restriction", (Object)infosSite.getRestriction());
            propsConfig.setProperty(proprieteSite + ".sso", (Object)infosSite.isSso());
            propsConfig.setProperty(proprieteSite + ".jsp_fo", (Object)infosSite.getJspFo());
            propsConfig.setProperty(proprieteSite + ".code_template", (Object)infosSite.getCodeTemplate());
            propsConfig.setProperty(proprieteSite + ".principal", (Object)infosSite.isSitePrincipal());
            propsConfig.setProperty(proprieteSite + ".actif", (Object)infosSite.isActif());
            this.setListeProprietesComplementairesDansProperties(infosSite, propsConfig);
            Object object = LOCK;
            synchronized (object) {
                propsConfig.save();
            }
        }
        catch (ConfigurationException e) {
            throw new ErreursSaisieInfosSite("impossible de sauvegarder le site courant" + infosSite.getAlias());
        }
    }

    private void setListeProprietesComplementairesDansProperties(InfosSite infosSite, PropertiesConfiguration propsConfig) {
        String prefixeProprieteSite = "site." + infosSite.getAlias() + ".";
        for (Map.Entry<String, Object> propriete : infosSite.getProprietesComplementaires().entrySet()) {
            propsConfig.setProperty(prefixeProprieteSite + propriete.getKey(), propriete.getValue());
        }
    }
}

