/*
 * Decompiled with CFR 0.152.
 */
package com.univ.multisites.helper;

import com.kportal.core.webapp.WebAppUtil;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfosSitePropertiesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(InfosSitePropertiesHelper.class);
    public static final String PROPERTIES_SITE_PRINCIPAL = "site.principal";
    public static final String HOST = "host";
    public static final String DEBUT_PROPERTIES_SITE = "site.";
    public static final String FIN_PROPERTIES_SITE_SSO = ".sso";
    public static final String FIN_PROPERTIES_SITE_JSP_FO = ".jsp_fo";
    public static final String FIN_PROPERTIES_SITE_TEMPLATE = ".code_template";
    public static final String FIN_PROPERTIES_SITE_ALIAS = ".alias";
    public static final String FIN_PROPERTIES_SITE_URL_ACCUEIL = ".url_accueil";
    public static final String FIN_PROPERTIES_SITE_REECRITURE_RUBRIQUE_MODE = ".reecriture_rubrique_mode";
    public static final String FIN_PROPERTIES_SITE_REECRITURE_RUBRIQUE_MAX = ".reecriture_rubrique_max";
    public static final String FIN_PROPERTIES_SITE_REECRITURE_RUBRIQUE_MIN = ".reecriture_rubrique_min";
    public static final String FIN_PROPERTIES_SITE_RESTRICTION = ".restriction";
    public static final String FIN_PROPERTIES_SITE_RUBRIQUE = ".rubrique";
    public static final String FIN_PROPERTIES_SITE_BO_SSL_MODE = ".bo.ssl_mode";
    public static final String FIN_PROPERTIES_SITE_HTTP_ACTIONS = ".http_actions";
    public static final String FIN_PROPERTIES_SITE_HTTPS_ACTIONS = ".https_actions";
    public static final String FIN_PROPERTIES_SITE_SSL_MODE = ".ssl_mode";
    public static final String FIN_PROPERTIES_SITE_HTTPS_PORT = ".https_port";
    public static final String FIN_PROPERTIES_SITE_HTTPS_HOST = ".https_host";
    public static final String FIN_PROPERTIES_SITE_PORT = ".port";
    public static final String FIN_PROPERTIES_SITE_HOST = ".host";
    public static final String FIN_PROPERTIES_SITE_INTITULE = ".intitule";
    public static final String FIN_PROPERTIES_SITE_PRINCIPAL = ".principal";
    public static final String FIN_PROPERTIES_SITE_ACTIF = ".actif";
    public static final String STRING_BOOLEAN_TRUE = "1";
    public static final String SLASH = "/";
    public static final char PROPERTIE_KEY_DELIMITEUR = '.';
    public static final char VALEUR_PROPERTIE_LISTE_DELIMITEUR = ';';
    public static final String ACTION_DECONNECTER = "DECONNECTER";
    public static final String ACTION_PRESENTER_MDP = "PRESENTER_MDP";
    public static final String ACTION_DEMANDER_MDP = "DEMANDER_MDP";
    public static final String ACTION_PERSONNALISER = "PERSONNALISER";
    public static final String ACTION_LOGIN = "LOGIN";

    public static SortedSet<Integer> transformerActionsStringEnListe(String actions) {
        String[] tableauActions = actions.split(String.valueOf(';'));
        TreeSet<Integer> listeActions = new TreeSet<Integer>();
        for (String action : tableauActions) {
            if (action.equals(ACTION_LOGIN)) {
                listeActions.add(1);
                continue;
            }
            if (action.equals(ACTION_PERSONNALISER)) {
                listeActions.add(2);
                continue;
            }
            if (action.equals(ACTION_DEMANDER_MDP)) {
                listeActions.add(3);
                continue;
            }
            if (action.equals(ACTION_PRESENTER_MDP)) {
                listeActions.add(4);
                continue;
            }
            if (action.equals(ACTION_DECONNECTER)) {
                listeActions.add(5);
                continue;
            }
            listeActions.add(0);
        }
        return listeActions;
    }

    public static SortedSet<Integer> transformListActionsToSet(List<String> actions) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (String currentAction : actions) {
            try {
                result.add(Integer.valueOf(currentAction));
            }
            catch (NumberFormatException nfe) {
                LOG.error("unable to convert the given action to an integer", (Throwable)nfe);
            }
        }
        return result;
    }

    public static final String getCheminDossiersProperties() {
        return WebAppUtil.getConfigurationSitesPath();
    }

    public static enum FinNomProprieteSite {
        SITE_SSO("sso"),
        JSP_FO("jsp_fo"),
        TEMPLATE("code_template"),
        ALIAS("alias"),
        URL_ACCUEIL("url_accueil"),
        REECRITURE_RUBRIQUE_MODE("reecriture_rubrique_mode"),
        REECRITURE_RUBRIQUE_MAX("reecriture_rubrique_max"),
        REECRITURE_RUBRIQUE_MIN("reecriture_rubrique_min"),
        RESTRICTION("restriction"),
        RUBRIQUE("rubrique"),
        BO_SSL_MODE("bo.ssl_mode"),
        HTTP_ACTIONS("http_actions"),
        HTTPS_ACTIONS("https_actions"),
        SSL_MODE("ssl_mode"),
        HTTPS_PORT("https_port"),
        HTTPS_HOST("https_host"),
        SITE_PORT("port"),
        HOST("host"),
        INTITULE("intitule"),
        PRINCIPAL("principal"),
        ACTIF("actif");

        private String nom;

        private FinNomProprieteSite(String nom) {
            this.setNom(nom);
        }

        public String getNom() {
            return this.nom;
        }

        public void setNom(String nom) {
            this.nom = nom;
        }

        public String toString() {
            return this.nom;
        }

        public static boolean isProprieteSite(String codePropriete) {
            if (StringUtils.isEmpty((CharSequence)codePropriete)) {
                return Boolean.FALSE;
            }
            for (FinNomProprieteSite proprieteSite : FinNomProprieteSite.values()) {
                if (!proprieteSite.getNom().equals(codePropriete)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

