/*
 * Decompiled with CFR 0.152.
 */
package com.univ.multisites.service.cache;

import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.multisites.service.ServiceInfosSiteFactory;
import com.univ.utils.URLResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DonneesInfosSite
implements Serializable {
    private static final long serialVersionUID = -5768970279225460911L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DonneesInfosSite.class);
    private final Map<String, InfosSite> infosSitesParCode;
    private final Map<String, InfosSite> infosSitesParHost;
    private final Map<String, InfosSite> infosSitesParCodeRubrique;
    private final Set<String> urlsDefinis;
    private InfosSite sitePrincipal;
    private InfosSite siteGlobal;
    private static final String HTTPS = "https";
    private static final String HTTP = "http";

    public DonneesInfosSite() {
        Collection<InfosSite> listeInfosSite = this.getInfosSitesDefinis();
        this.infosSitesParCode = new HashMap<String, InfosSite>(listeInfosSite.size());
        this.infosSitesParCodeRubrique = new HashMap<String, InfosSite>(listeInfosSite.size());
        this.infosSitesParHost = new HashMap<String, InfosSite>();
        this.urlsDefinis = new HashSet<String>();
        for (InfosSite infosSite : listeInfosSite) {
            if (!infosSite.isActif()) continue;
            if (infosSite.isSitePrincipal()) {
                this.sitePrincipal = infosSite;
            }
            if (StringUtils.isEmpty((CharSequence)infosSite.getCodeRubrique())) {
                this.siteGlobal = infosSite;
            }
            this.infosSitesParCode.put(infosSite.getAlias(), infosSite);
            this.infosSitesParCodeRubrique.put(infosSite.getCodeRubrique(), infosSite);
            if (StringUtils.isNotEmpty((CharSequence)infosSite.getHttpHostname())) {
                this.infosSitesParHost.put(infosSite.getHttpHostname(), infosSite);
                this.urlsDefinis.add(URLResolver.getBasePath(infosSite, Boolean.FALSE));
            }
            if (StringUtils.isNotEmpty((CharSequence)infosSite.getHttpsHostname())) {
                this.urlsDefinis.add(URLResolver.getBasePath(infosSite, Boolean.TRUE));
                this.infosSitesParHost.put(infosSite.getHttpsHostname(), infosSite);
            }
            for (String hostAlias : infosSite.getListeHostAlias()) {
                if (!StringUtils.isNotEmpty((CharSequence)hostAlias)) continue;
                this.infosSitesParHost.put(hostAlias, infosSite);
                this.urlsDefinis.add(URLResolver.getBasePath(HTTP, hostAlias, infosSite.getHttpPort()));
                this.urlsDefinis.add(URLResolver.getBasePath(HTTPS, hostAlias, infosSite.getHttpsPort()));
            }
        }
        if (this.sitePrincipal == null && this.infosSitesParHost.size() >= 1) {
            this.sitePrincipal = (InfosSite)CollectionUtils.get(this.infosSitesParHost.values(), (int)0);
        }
        if (this.siteGlobal == null) {
            this.siteGlobal = this.sitePrincipal;
        }
        LOGGER.info("Chargement de " + this.infosSitesParCode.size() + " site(s) OK");
    }

    private Collection<InfosSite> getInfosSitesDefinis() {
        Collection<InfosSite> listeInfosSite = null;
        try {
            listeInfosSite = ServiceInfosSiteFactory.getServiceInfosSite().getListeTousInfosSites();
            if (CollectionUtils.isNotEmpty(listeInfosSite)) {
                boolean hasSitePrincipal = false;
                for (InfosSite siteCourant : listeInfosSite) {
                    if (!siteCourant.isSitePrincipal()) continue;
                    hasSitePrincipal = true;
                    break;
                }
                if (!hasSitePrincipal) {
                    InfosSiteImpl newSitePrincipal = (InfosSiteImpl)listeInfosSite.iterator().next();
                    newSitePrincipal.setSitePrincipal(Boolean.TRUE);
                    ServiceInfosSiteFactory.getServiceInfosSite().modifier(newSitePrincipal, null);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("impossible de r\u00e9cup\u00e9rer la liste des sites d\u00e9clar\u00e9s dans l'application");
        }
        if (listeInfosSite == null) {
            listeInfosSite = Collections.emptyList();
        }
        return listeInfosSite;
    }

    public Map<String, InfosSite> getInfosSitesParCode() {
        return this.infosSitesParCode;
    }

    public Map<String, InfosSite> getInfosSitesParHost() {
        return this.infosSitesParHost;
    }

    public Map<String, InfosSite> getInfosSitesParCodeRubrique() {
        return this.infosSitesParCodeRubrique;
    }

    public Set<String> getUrlsDefinis() {
        return this.urlsDefinis;
    }

    public InfosSite getSitePrincipal() {
        return this.sitePrincipal;
    }

    @Deprecated
    public InfosSite getSiteGlobal() {
        return this.siteGlobal;
    }
}

