/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.cache;

import com.kdecole.cache.aspect.StaticCacheGet;
import com.kportal.cache.CacheUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRequeteGroupe;
import com.univ.utils.ContexteDao;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheGroupeDsiManager {
    public static final String ID_BEAN = "cacheGroupeDsiManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheGroupeDsiManager.class);

    @StaticCacheGet(key="CacheGroupeDsiManager.getListeGroupesDsi", contextual=false)
    public Map<String, InfosGroupeDsi> getListeGroupesDsi() {
        HashMap<String, InfosGroupeDsi> listeGroupesDsi = new HashMap<String, InfosGroupeDsi>();
        InfosGroupeDsi infosGroupeTop = new InfosGroupeDsi();
        infosGroupeTop.setCode("00");
        listeGroupesDsi.put(infosGroupeTop.getCode(), infosGroupeTop);
        try (ContexteDao ctx = new ContexteDao();){
            Groupedsi groupe = new Groupedsi();
            groupe.setCtx(ctx);
            groupe.selectNoCount("");
            int count = 0;
            while (groupe.nextItem()) {
                InfosGroupeDsi infosGroupe = new InfosGroupeDsi(groupe);
                listeGroupesDsi.put(infosGroupe.getCode(), infosGroupe);
                ++count;
            }
            LOGGER.info("Chargement de " + count + " groupes OK");
        }
        catch (Exception e) {
            LOGGER.info("Erreur de chargement des groupes");
        }
        for (InfosGroupeDsi groupe : listeGroupesDsi.values()) {
            if ("00".equals(groupe.getCode())) continue;
            try {
                InfosGroupeDsi groupePere = (InfosGroupeDsi)listeGroupesDsi.get(groupe.getCodeGroupePere());
                if (groupePere == null || groupePere.getCode().length() == 0) {
                    groupePere = infosGroupeTop;
                }
                groupe.rattacheA(groupePere);
            }
            catch (Exception e) {
                LOGGER.info("Erreur de rattachement des groupes parents dans le cache");
            }
        }
        return listeGroupesDsi;
    }

    @StaticCacheGet(key="CacheGroupeDsiManager.getListeRequetesGroupes", contextual=false)
    public Map<String, InfosRequeteGroupe> getListeRequetesGroupes() {
        HashMap<String, InfosRequeteGroupe> listeRequetesGroupes = new HashMap<String, InfosRequeteGroupe>();
        for (IExtension extension : ExtensionHelper.getExtensionManager().getExtensions().values()) {
            Properties propertiesExtensions = extension.getProperties();
            for (String nomProp : propertiesExtensions.stringPropertyNames()) {
                String tsCacheGroupesUtilisateur;
                String[] items;
                if (!StringUtils.startsWith((CharSequence)nomProp, (CharSequence)"requete_groupe.") || !(items = nomProp.split("\\.", -2))[2].equals("classe")) continue;
                String aliasRequete = items[1];
                String classe = propertiesExtensions.getProperty(nomProp);
                String intitule = propertiesExtensions.getProperty("requete_groupe." + aliasRequete + ".intitule");
                String templateJSP = propertiesExtensions.getProperty("requete_groupe." + aliasRequete + ".template_jsp");
                if (StringUtils.isNotBlank((CharSequence)templateJSP)) {
                    templateJSP = extension.getRelativePath() + templateJSP;
                }
                if ((tsCacheGroupesUtilisateur = propertiesExtensions.getProperty("requete_groupe." + aliasRequete + ".expiration_cache_utilisateur")) != null) {
                    listeRequetesGroupes.put(aliasRequete, new InfosRequeteGroupe(aliasRequete, intitule, classe, Long.valueOf(tsCacheGroupesUtilisateur), templateJSP));
                    continue;
                }
                listeRequetesGroupes.put(aliasRequete, new InfosRequeteGroupe(aliasRequete, intitule, classe, 0L, templateJSP));
            }
        }
        return listeRequetesGroupes;
    }

    public void flush() {
        CacheUtil.flushCache("CacheGroupeDsiManager.getListeGroupesDsi");
        CacheUtil.flushCache("CacheGroupeDsiManager.getListeRequetesGroupes");
    }
}

