/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.cache;

import com.jsbsoft.jtf.core.CodeLibelle;
import com.kdecole.cache.aspect.StaticCacheFlush;
import com.kdecole.cache.aspect.StaticCacheGet;
import com.kportal.extension.ExtensionHelper;
import com.univ.objetspartages.om.InfosLibelle;
import com.univ.objetspartages.om.Libelle;
import com.univ.utils.ContexteDao;
import java.util.HashMap;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheLibelleManager {
    public static final String ID_BEAN = "cacheLibelleManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheLibelleManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StaticCacheGet(key="CacheLibelleManager.getListeInfosLibelles", contextual=false)
    public HashMap<String, InfosLibelle> getListeInfosLibelles() {
        HashMap<String, InfosLibelle> listeLibelles = new HashMap<String, InfosLibelle>();
        try (ContexteDao ctx = new ContexteDao();){
            Libelle libelle = new Libelle();
            libelle.setCtx(ctx);
            libelle.selectNoCount("");
            int count = 0;
            InfosLibelle infosLibelle = null;
            while (libelle.nextItem()) {
                infosLibelle = new InfosLibelle(libelle);
                listeLibelles.put(infosLibelle.getType() + infosLibelle.getCode().toLowerCase() + infosLibelle.getLangue(), infosLibelle);
                ++count;
            }
            LOGGER.info("Chargement de " + count + " libelles OK");
        }
        return listeLibelles;
    }

    @StaticCacheGet(key="CacheLibelleManager.getListeTypesLibelles", contextual=false)
    public Hashtable<String, String> getListeTypesLibelles() {
        Hashtable<String, String> listeTypesLibelles = new Hashtable<String, String>();
        try {
            for (String idExt : ExtensionHelper.getExtensionManager().getExtensions().keySet()) {
                Hashtable<String, String> h = CodeLibelle.lireTable(idExt, "type_libelle", null);
                listeTypesLibelles.putAll(h);
                h = CodeLibelle.lireTable(idExt, idExt + "_type_libelle", null);
                listeTypesLibelles.putAll(h);
            }
            LOGGER.info("Chargement des types de libelle OK");
        }
        catch (Exception e) {
            LOGGER.info("Erreur de chargement des types de libelle");
        }
        return listeTypesLibelles;
    }

    @StaticCacheFlush(key="CacheLibelleManager.getListeInfosLibelles", contextual=false)
    public void flushListeInfosLibelles() {
    }

    @StaticCacheFlush(key="CacheLibelleManager.getListeTypesLibelles", contextual=false)
    public void flushListeTypesLibelles() {
    }

    public void flushAll() {
        this.flushListeInfosLibelles();
        this.flushListeTypesLibelles();
    }
}

