/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.cache;

import com.kdecole.cache.aspect.StaticCacheFlush;
import com.kdecole.cache.aspect.StaticCacheGet;
import com.univ.objetspartages.om.InfosRole;
import com.univ.objetspartages.om.Role;
import com.univ.utils.ContexteDao;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRoleManager {
    public static final String ID_BEAN = "cacheRoleManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheRoleManager.class);

    @StaticCacheGet(key="CacheRoleManager.getListeRoles", contextual=false)
    public HashMap<String, InfosRole> getListeRoles() {
        HashMap<String, InfosRole> listeRoles = new HashMap<String, InfosRole>();
        try (ContexteDao ctx = new ContexteDao();){
            Role role = new Role();
            role.setCtx(ctx);
            int count = role.select("");
            while (role.nextItem()) {
                InfosRole infosRole = new InfosRole(role.getCode(), role.getLibelle(), role.getPerimetre(), role.getPermissions());
                listeRoles.put(infosRole.getCode(), infosRole);
            }
            LOGGER.info("Chargement de " + count + " roles OK");
        }
        catch (Exception e) {
            LOGGER.info("Erreur de chargement des roles");
        }
        return listeRoles;
    }

    @StaticCacheFlush(key="CacheRoleManager.getListeRoles", contextual=false)
    public void flush() {
    }
}

